/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;

public final class JDBCSQLTypeInfo {
    public static final Integer DEFAULT_RADIX = 10;
    public static final Integer DEFAULT_SCALE = 0;
    public static final Integer XML_COLUMN_LENGTH = Integer.MAX_VALUE;
    private static Map<String, TypeInfo> NAME_TO_TYPEINFO = new LinkedHashMap<String, TypeInfo>();
    private static Map<Integer, TypeInfo> TYPE_TO_TYPEINFO = new HashMap<Integer, TypeInfo>();
    private static Map<String, TypeInfo> CLASSNAME_TO_TYPEINFO = new HashMap<String, TypeInfo>();

    static {
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER, 20, 19, DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId(), 2);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), "decimal"}, 22, 20, DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), 2, 3);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.BLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, Blob.class.getName(), 2004, -4);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.BOOLEAN, 5, 1, DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), -7, 16);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.BYTE.getId(), "tinyint"}, 4, 3, DataTypeManagerService.DefaultDataTypes.BYTE.getId(), -6);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.CHAR, 1, 1, DataTypeManagerService.DefaultDataTypes.CHAR.getId(), 1);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.CLOB, Integer.MAX_VALUE, Integer.MAX_VALUE, Clob.class.getName(), 2005, 2011, -16, -1);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.DATE, 10, 10, DataTypeManagerService.DefaultDataTypes.DATE.getId(), 91);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.DOUBLE, 22, 20, DataTypeManagerService.DefaultDataTypes.DOUBLE.getId(), 8, 6);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), "real"}, 22, 20, DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), 7);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.INTEGER, 11, 10, DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), 4);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.LONG.getId(), "bigint"}, 20, 19, DataTypeManagerService.DefaultDataTypes.LONG.getId(), -5);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.OBJECT, Integer.MAX_VALUE, Integer.MAX_VALUE, DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), 2000);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.SHORT.getId(), "smallint"}, 6, 5, DataTypeManagerService.DefaultDataTypes.SHORT.getId(), 5);
        JDBCSQLTypeInfo.addType(new String[]{DataTypeManagerService.DefaultDataTypes.STRING.getId(), "varchar"}, DataTypeManagerService.MAX_STRING_LENGTH, DataTypeManagerService.MAX_STRING_LENGTH, DataTypeManagerService.DefaultDataTypes.STRING.getId(), 12, -9, 1, -15);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.TIME, 8, 8, DataTypeManagerService.DefaultDataTypes.TIME.getId(), 92);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.TIMESTAMP, 29, 29, DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getId(), 93);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.XML, Integer.MAX_VALUE, Integer.MAX_VALUE, SQLXML.class.getName(), 2009);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.NULL, 4, 1, null, 0);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.VARBINARY, DataTypeManagerService.MAX_LOB_MEMORY_BYTES, DataTypeManagerService.MAX_LOB_MEMORY_BYTES, byte[].class.getName(), -3, -2);
        JDBCSQLTypeInfo.addType(DataTypeManagerService.DefaultDataTypes.VARBINARY, DataTypeManagerService.MAX_LOB_MEMORY_BYTES, DataTypeManagerService.MAX_LOB_MEMORY_BYTES, byte[].class.getName(), -3, -2);
        TypeInfo typeInfo = new TypeInfo(Integer.MAX_VALUE, 0, "ARRAY", Array.class.getName(), new int[2003]);
        CLASSNAME_TO_TYPEINFO.put(Array.class.getName(), typeInfo);
        TYPE_TO_TYPEINFO.put(2003, typeInfo);
    }

    private JDBCSQLTypeInfo() {
    }

    private static TypeInfo addType(DataTypeManagerService.DefaultDataTypes type, int maxDisplaySize, int precision, String javaClassName, int ... sqlTypes) {
        return JDBCSQLTypeInfo.addType(type.getId(), maxDisplaySize, precision, javaClassName, sqlTypes);
    }

    private static TypeInfo addType(String typeName, int maxDisplaySize, int precision, String javaClassName, int ... sqlTypes) {
        TypeInfo ti = new TypeInfo(maxDisplaySize, precision, typeName, javaClassName, sqlTypes);
        NAME_TO_TYPEINFO.put(typeName, ti);
        if (javaClassName != null) {
            CLASSNAME_TO_TYPEINFO.put(javaClassName, ti);
        }
        int[] nArray = sqlTypes;
        int n = sqlTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TYPE_TO_TYPEINFO.put(i, ti);
            ++n2;
        }
        return ti;
    }

    private static void addType(String[] typeNames, int maxDisplaySize, int precision, String javaClassName, int ... sqlTypes) {
        TypeInfo ti = JDBCSQLTypeInfo.addType(typeNames[0], maxDisplaySize, precision, javaClassName, sqlTypes);
        int i = 1;
        while (i < typeNames.length) {
            NAME_TO_TYPEINFO.put(typeNames[i], ti);
            ++i;
        }
    }

    public static final int getSQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        TypeInfo sqlType = NAME_TO_TYPEINFO.get(typeName);
        if (sqlType == null) {
            if (DataTypeManagerService.isArrayType(typeName)) {
                return 2003;
            }
            return 2000;
        }
        return sqlType.jdbcTypes[0];
    }

    public static final int getSQLTypeFromClass(String className) {
        if (className == null) {
            return 0;
        }
        TypeInfo sqlType = CLASSNAME_TO_TYPEINFO.get(className);
        if (sqlType == null) {
            return 2000;
        }
        return sqlType.jdbcTypes[0];
    }

    public static final String getJavaClassName(int jdbcSQLType) {
        TypeInfo typeInfo = TYPE_TO_TYPEINFO.get(jdbcSQLType);
        if (typeInfo == null) {
            return DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
        }
        return typeInfo.javaClassName;
    }

    public static final String getTypeName(int sqlType) {
        TypeInfo typeInfo = TYPE_TO_TYPEINFO.get(sqlType);
        if (typeInfo == null) {
            return DataTypeManagerService.DefaultDataTypes.OBJECT.getId();
        }
        return typeInfo.name;
    }

    public static Set<String> getMMTypeNames() {
        return NAME_TO_TYPEINFO.keySet();
    }

    public static Integer getMaxDisplaySize(ITeiidServerVersion teiidVersion, Class<?> dataTypeClass) {
        return JDBCSQLTypeInfo.getMaxDisplaySize(DataTypeManagerService.getInstance(teiidVersion).getDataTypeName(dataTypeClass));
    }

    public static Integer getMaxDisplaySize(String typeName) {
        TypeInfo ti = NAME_TO_TYPEINFO.get(typeName);
        if (ti == null) {
            return null;
        }
        return ti.maxDisplaySize;
    }

    public static Integer getDefaultPrecision(ITeiidServerVersion teiidVersion, Class<?> dataTypeClass) {
        return JDBCSQLTypeInfo.getDefaultPrecision(DataTypeManagerService.getInstance(teiidVersion).getDataTypeName(dataTypeClass));
    }

    public static Integer getDefaultPrecision(String typeName) {
        TypeInfo ti = NAME_TO_TYPEINFO.get(typeName);
        if (ti == null) {
            return null;
        }
        return ti.defaultPrecision;
    }

    public static class TypeInfo {
        String name;
        int maxDisplaySize;
        int defaultPrecision;
        String javaClassName;
        int[] jdbcTypes;

        public TypeInfo(int maxDisplaySize, int precision, String name, String javaClassName, int[] jdbcTypes) {
            this.maxDisplaySize = maxDisplaySize;
            this.defaultPrecision = precision;
            this.name = name;
            this.javaClassName = javaClassName;
            this.jdbcTypes = jdbcTypes;
        }
    }
}

