/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.lob;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.client.DQP;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.lob.LobChunkProducer;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.types.Streamable;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class StreamingLobChunckProducer
implements LobChunkProducer {
    private static AtomicInteger REQUEST_SEQUENCE = new AtomicInteger(0);
    private final Streamable<?> streamable;
    private final DQP dqp;
    private final long requestId;
    private final int streamRequestId = REQUEST_SEQUENCE.getAndIncrement();

    public StreamingLobChunckProducer(DQP dqp, long requestId, Streamable<?> streamable) {
        this.dqp = dqp;
        this.requestId = requestId;
        this.streamable = streamable;
    }

    @Override
    public LobChunk getNextChunk() throws IOException {
        try {
            ResultsFuture<LobChunk> result = this.dqp.requestNextLobChunk(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
            return (LobChunk)result.get();
        }
        catch (Exception e) {
            IOException ex = new IOException(Messages.getString(Messages.JDBC.Unable_to_read_data_from_stream, e.getMessage()));
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.dqp.closeLobChunkStream(this.streamRequestId, this.requestId, this.streamable.getReferenceStreamId());
        }
        catch (TeiidClientException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static class Factory {
        private final Streamable<?> streamable;
        private final DQP dqp;
        private final long requestId;

        public Factory(DQP dqp, long requestId, Streamable<?> streamable) {
            this.dqp = dqp;
            this.requestId = requestId;
            this.streamable = streamable;
        }

        public StreamingLobChunckProducer getLobChunkProducer() {
            return new StreamingLobChunckProducer(this.dqp, this.requestId, this.streamable);
        }
    }
}

