/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.XMLType;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.Messages;

public class Batch0Serializer
extends BatchSerializer {
    private ColumnSerializer defaultSerializer = new ColumnSerializer();
    private final Map<String, ColumnSerializer> serializers = new HashMap<String, ColumnSerializer>(128);
    private final Map<String, ColumnSerializer> version1serializers = new HashMap<String, ColumnSerializer>(128);
    private final int MAX_UTF = 21845;
    int DATE_NORMALIZER = 0;

    public Batch0Serializer(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(1900, 0, 1, 0, 0, 0);
        c.set(14, 0);
        this.DATE_NORMALIZER = -((int)(c.getTime().getTime() / 60000L));
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), new BigDecimalColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId(), new BigIntegerColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), new BooleanColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BYTE.getId(), new ByteColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CHAR.getId(), new CharColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new DateColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DOUBLE.getId(), new DoubleColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), new FloatColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), new IntColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.LONG.getId(), new LongColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.SHORT.getId(), new ShortColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new TimeColumnSerializer());
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getId(), new TimestampColumnSerializer());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new DateColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new TimeColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.STRING.getId(), new StringColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.CLOB.getId(), new ClobColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.BLOB.getId(), new BlobColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.XML.getId(), new XmlColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.NULL.getId(), new NullColumnSerializer1());
        this.version1serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new ObjectColumnSerializer1());
    }

    void writeIsNullData(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        int numBytes = batch.size() / 8;
        int row = 0;
        int currentByte = 0;
        int byteNum = 0;
        while (byteNum < numBytes) {
            int n = currentByte = batch.get(row).get(col) == null ? 128 : 0;
            if (batch.get(row + 1).get(col) == null) {
                currentByte |= 0x40;
            }
            if (batch.get(row + 2).get(col) == null) {
                currentByte |= 0x20;
            }
            if (batch.get(row + 3).get(col) == null) {
                currentByte |= 0x10;
            }
            if (batch.get(row + 4).get(col) == null) {
                currentByte |= 8;
            }
            if (batch.get(row + 5).get(col) == null) {
                currentByte |= 4;
            }
            if (batch.get(row + 6).get(col) == null) {
                currentByte |= 2;
            }
            if (batch.get(row + 7).get(col) == null) {
                currentByte |= 1;
            }
            out.write(currentByte);
            ++byteNum;
            row += 8;
        }
        if (batch.size() % 8 > 0) {
            currentByte = 0;
            int mask = 128;
            while (row < batch.size()) {
                if (batch.get(row).get(col) == null) {
                    currentByte |= mask;
                }
                ++row;
                mask >>= 1;
            }
            out.write(currentByte);
        }
    }

    void readIsNullData(ObjectInput in, byte[] isNullBytes) throws IOException {
        int i = 0;
        while (i < isNullBytes.length) {
            isNullBytes[i] = in.readByte();
            ++i;
        }
    }

    boolean isNullObject(byte[] isNull, int row) {
        return (isNull[row / 8] & 1 << 7 - row % 8) != 0;
    }

    private ColumnSerializer getSerializer(String type, byte version) {
        ColumnSerializer cs = null;
        if (version == 1) {
            cs = this.version1serializers.get(type == null ? DataTypeManagerService.DefaultDataTypes.OBJECT : type);
        }
        if (cs == null) {
            cs = this.serializers.get(type == null ? DataTypeManagerService.DefaultDataTypes.OBJECT : type);
        }
        if (cs == null) {
            return this.defaultSerializer;
        }
        return cs;
    }

    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch) throws IOException {
        this.writeBatch(out, types, batch, (byte)1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch, byte version) throws IOException {
        if (batch == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(batch.size());
            if (batch.size() > 0) {
                columns = types.length;
                out.writeInt(columns);
                i = 0;
                while (i < columns) {
                    block8: {
                        serializer = this.getSerializer(types[i], version);
                        try {
                            serializer.writeColumn(out, i, batch);
                            break block8;
                        }
                        catch (ClassCastException e) {
                            obj = null;
                            objectClass = null;
                            row = 0;
                            ** while (row < batch.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            obj = batch.get(row).get(i);
                            if (obj != null) {
                                objectClass = obj.getClass().getName();
                                break;
                            }
                            ++row;
                            continue;
                        }
lbl25:
                        // 2 sources

                        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID20001, new Object[]{types[i], new Integer(i), objectClass}), e);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public List<List<Object>> readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        return this.readBatch(in, types, (byte)0);
    }

    private List<List<Object>> readBatch(ObjectInput in, String[] types, byte version) throws IOException, ClassNotFoundException {
        int rows = in.readInt();
        if (rows == 0) {
            return new ArrayList<List<Object>>(0);
        }
        if (rows > 0) {
            int columns = in.readInt();
            ResizingArrayList<List<Object>> batch = new ResizingArrayList<List<Object>>(rows);
            int numBytes = rows / 8;
            int extraRows = rows % 8;
            int currentRow = 0;
            while (currentRow < rows) {
                batch.add(currentRow, Arrays.asList(new Object[columns]));
                ++currentRow;
            }
            byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
            int col = 0;
            while (col < columns) {
                this.getSerializer(types[col], version).readColumn(in, col, batch, isNullBuffer);
                ++col;
            }
            return batch;
        }
        return null;
    }

    private class BigDecimalColumnSerializer
    extends ColumnSerializer {
        private BigDecimalColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigDecimal val = (BigDecimal)obj;
            out.writeInt(val.scale());
            BigInteger unscaled = val.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int scale = in.readInt();
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    private class BigIntegerColumnSerializer
    extends ColumnSerializer {
        private BigIntegerColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigInteger val = (BigInteger)obj;
            byte[] bytes = val.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }
    }

    private class BlobColumnSerializer1
    extends ColumnSerializer {
        private BlobColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            BlobType bt = new BlobType();
            bt.readExternal(in);
            return bt;
        }
    }

    private class BooleanColumnSerializer
    extends ColumnSerializer {
        private BooleanColumnSerializer() {
            super(null, null);
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            int currentByte = 0;
            int mask = 128;
            int row = 0;
            while (row < batch.size()) {
                Object obj = batch.get(row).get(col);
                if (obj == null) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) == 0) {
                    out.write(currentByte);
                    currentByte = 0;
                    mask = 128;
                }
                if (obj != null) {
                    if (((Boolean)obj).booleanValue()) {
                        currentByte |= mask;
                    }
                    if ((mask >>= 1) == 0) {
                        out.write(currentByte);
                        currentByte = 0;
                        mask = 128;
                    }
                }
                ++row;
            }
            if (mask != 128) {
                out.write(currentByte);
            }
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            int currentByte = 0;
            int mask = 0;
            int row = 0;
            while (row < batch.size()) {
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                boolean isNullVal = (currentByte & mask) != 0;
                mask >>= 1;
                if (!isNullVal) {
                    if (mask == 0) {
                        currentByte = in.read();
                        mask = 128;
                    }
                    batch.get(row).set(col, (currentByte & mask) == 0 ? Boolean.FALSE : Boolean.TRUE);
                    mask >>= 1;
                }
                ++row;
            }
        }
    }

    private class ByteColumnSerializer
    extends ColumnSerializer {
        private ByteColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeByte(((Byte)obj).byteValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readByte();
        }
    }

    private class CharColumnSerializer
    extends ColumnSerializer {
        private CharColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeChar(((Character)obj).charValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    }

    private class ClobColumnSerializer1
    extends ColumnSerializer {
        private ClobColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            ClobType ct = new ClobType();
            ct.readExternal(in);
            return ct;
        }
    }

    private class ColumnSerializer {
        private ColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            Batch0Serializer.this.writeIsNullData(out, col, batch);
            Object obj = null;
            int i = 0;
            while (i < batch.size()) {
                obj = batch.get(i).get(col);
                if (obj != null) {
                    this.writeObject(out, obj);
                }
                ++i;
            }
        }

        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            Batch0Serializer.this.readIsNullData(in, isNull);
            int i = 0;
            while (i < batch.size()) {
                if (!Batch0Serializer.this.isNullObject(isNull, i)) {
                    batch.get(i).set(col, this.readObject(in));
                }
                ++i;
            }
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeObject(obj);
        }

        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readObject();
        }

        /* synthetic */ ColumnSerializer(ColumnSerializer columnSerializer, ColumnSerializer columnSerializer2) {
            this();
        }
    }

    private class DateColumnSerializer
    extends ColumnSerializer {
        private DateColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Date)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date(in.readLong());
        }
    }

    private class DateColumnSerializer1
    extends ColumnSerializer {
        private DateColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((int)(((Date)obj).getTime() / 60000L) + Batch0Serializer.this.DATE_NORMALIZER);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date((((long)in.readInt() & 0xFFFFFFFFL) - (long)Batch0Serializer.this.DATE_NORMALIZER) * 60000L);
        }
    }

    private class DoubleColumnSerializer
    extends ColumnSerializer {
        private DoubleColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeDouble((Double)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Double(in.readDouble());
        }
    }

    private class FloatColumnSerializer
    extends ColumnSerializer {
        private FloatColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeFloat(((Float)obj).floatValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Float(in.readFloat());
        }
    }

    private class IntColumnSerializer
    extends ColumnSerializer {
        private IntColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((Integer)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readInt();
        }
    }

    private class LongColumnSerializer
    extends ColumnSerializer {
        private LongColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong((Long)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readLong();
        }
    }

    private class NullColumnSerializer1
    extends ColumnSerializer {
        private NullColumnSerializer1() {
            super(null, null);
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
        }
    }

    public final class ObjectColumnSerializer1
    extends ColumnSerializer {
        public ObjectColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            DataTypeManagerService.DefaultDataTypes dataType = Batch0Serializer.this.getDataTypeManager().getDataType(obj.getClass());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch0Serializer.this.getTeiidVersion(), code);
                ColumnSerializer s = Batch0Serializer.this.getSerializer(dataType.getId(), (byte)1);
                s.writeObject(out, obj);
            } else {
                super.writeObject(out, obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            byte code = in.readByte();
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (in.readByte() == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch0Serializer.this.getTeiidVersion(), code);
                ColumnSerializer s = Batch0Serializer.this.getSerializer(dataType.getId(), (byte)1);
                return s.readObject(in);
            }
            return super.readObject(in);
        }
    }

    private class ShortColumnSerializer
    extends ColumnSerializer {
        private ShortColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeShort(((Short)obj).shortValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readShort();
        }
    }

    private class StringColumnSerializer1
    extends ColumnSerializer {
        private StringColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            String str = (String)obj;
            if (str.length() <= 21845) {
                out.writeByte(116);
                out.writeUTF(str);
            } else {
                out.writeByte(124);
                out.writeObject(obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            if (in.readByte() == 116) {
                return in.readUTF();
            }
            return super.readObject(in);
        }
    }

    private class TimeColumnSerializer
    extends ColumnSerializer {
        private TimeColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Time)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(in.readLong());
        }
    }

    private class TimeColumnSerializer1
    extends ColumnSerializer {
        private TimeColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((int)(((Time)obj).getTime() / 1000L));
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(((long)in.readInt() & 0xFFFFFFFFL) * 1000L);
        }
    }

    private class TimestampColumnSerializer
    extends ColumnSerializer {
        private TimestampColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Timestamp ts = (Timestamp)obj;
            out.writeLong(ts.getTime());
            out.writeInt(ts.getNanos());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            Timestamp ts = new Timestamp(in.readLong());
            ts.setNanos(in.readInt());
            return ts;
        }
    }

    private class XmlColumnSerializer1
    extends ColumnSerializer {
        private XmlColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            XMLType xt = new XMLType();
            xt.readExternal(in);
            return xt;
        }
    }
}

