/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

public class ResizingArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    public static final int MIN_SHRINK_SIZE = 32;
    protected Object[] elementData;
    protected int size;

    public ResizingArrayList() {
        this(32);
    }

    public ResizingArrayList(int initialCapacity) {
        this.elementData = new Object[initialCapacity];
    }

    public ResizingArrayList(Collection<? extends T> c) {
        this.elementData = c.toArray();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    @Override
    public T get(int index) {
        this.rangeCheck(index, false);
        return (T)this.elementData[index];
    }

    public int getModCount() {
        return this.modCount;
    }

    @Override
    public void add(int index, T element) {
        this.rangeCheck(index, true);
        ++this.modCount;
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    protected void ensureCapacity(int capacity) {
        if (capacity <= this.elementData.length) {
            return;
        }
        int newCapacity = 1 << 32 - Integer.numberOfLeadingZeros(capacity - 1);
        int lowerCapacity = newCapacity * 70 / 99;
        if (lowerCapacity > capacity) {
            newCapacity = lowerCapacity;
        }
        this.elementData = Arrays.copyOf(this.elementData, newCapacity);
    }

    @Override
    public T set(int index, T element) {
        this.rangeCheck(index, false);
        Object old = this.elementData[index];
        this.elementData[index] = element;
        return (T)old;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.rangeCheck(index, true);
        ++this.modCount;
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        for (T t : c) {
            this.elementData[index++] = t;
        }
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public T remove(int index) {
        T oldValue = this.get(index);
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
        int halfLength = this.elementData.length / 2;
        if (this.size <= halfLength && this.elementData.length > 32) {
            int newSize = Math.max(halfLength * 99 / 70, 32);
            Object[] next = new Object[newSize];
            System.arraycopy(this.elementData, 0, next, 0, this.size);
            this.elementData = next;
        }
        return oldValue;
    }

    private void rangeCheck(int index, boolean inclusive) {
        if (index > this.size || !inclusive && index == this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        if (this.size <= 32) {
            int i = 0;
            while (i < this.size) {
                this.elementData[i] = null;
                ++i;
            }
        } else {
            this.elementData = new Object[32];
        }
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public int size() {
        return this.size;
    }
}

