/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.manifest.PermissionElement;
import org.teiid.designer.vdb.manifest.Visitor;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class DataRoleElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="any-authenticated", required=false)
    private Boolean anyAuthenticated;
    @XmlAttribute(name="allow-create-temporary-tables", required=false)
    private Boolean allowCreateTempTables;
    @XmlAttribute(name="grant-all", required=false)
    private Boolean grantAll;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="permission", required=true, type=PermissionElement.class)
    private List<PermissionElement> permissions;
    @XmlElement(name="mapped-role-name")
    private List<String> mappedRoleNames;

    public DataRoleElement() {
    }

    public DataRoleElement(DataRole dataRole) {
        this.name = dataRole.getName();
        if (dataRole.isAnyAuthenticated() != null) {
            this.anyAuthenticated = dataRole.isAnyAuthenticated();
        }
        if (dataRole.isAllowCreateTempTables() != null) {
            this.allowCreateTempTables = dataRole.isAllowCreateTempTables();
        }
        if (dataRole.isGrantAll() != null) {
            this.grantAll = dataRole.isGrantAll();
        }
        this.description = dataRole.getDescription();
        for (Permission permission : dataRole.getPermissions()) {
            this.getPermissions().add(new PermissionElement(permission));
        }
        this.mappedRoleNames = new ArrayList<String>(dataRole.getRoleNames().size());
        for (String name : dataRole.getRoleNames()) {
            this.mappedRoleNames.add(name);
        }
    }

    public Boolean allowCreateTempTables() {
        return this.allowCreateTempTables;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getMappedRoleNames() {
        if (this.mappedRoleNames == null) {
            this.mappedRoleNames = new ArrayList<String>();
        }
        return this.mappedRoleNames;
    }

    public String getName() {
        return this.name;
    }

    public List<PermissionElement> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionElement>();
        }
        return this.permissions;
    }

    public Boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public Boolean doGrantAll() {
        return this.grantAll;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

