/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ddl.importer.DdlImporter;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.BasicVdb;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbFileEntry;
import org.teiid.designer.vdb.VdbImportVdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.VdbSchemaEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.VdbSourceInfo;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.dynamic.DynamicModel;
import org.teiid.designer.vdb.dynamic.DynamicModelComparator;
import org.teiid.designer.vdb.dynamic.Metadata;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.ImportVdbElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.MetadataElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.PermissionElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.SourceElement;
import org.teiid.designer.vdb.manifest.TranslatorElement;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DynamicVdb
extends BasicVdb {
    private Map<String, DynamicModel> models;

    public DynamicVdb() {
    }

    public DynamicVdb(IFile file) throws Exception {
        super(file);
    }

    private Map<String, DynamicModel> models() {
        if (this.models == null) {
            this.models = new HashMap<String, DynamicModel>();
        }
        return this.models;
    }

    @Override
    public void read(IFile file) throws Exception {
        CoreArgCheck.isNotNull((Object)file);
        this.setSourceFile(file);
        if (!file.exists()) {
            return;
        }
        final File dynVdbFile = file.getLocation().toFile();
        if (dynVdbFile.length() == 0L) {
            return;
        }
        FileInputStream xml = null;
        try {
            xml = new FileInputStream(dynVdbFile);
            this.validate(xml);
        }
        finally {
            if (xml != null) {
                ((InputStream)xml).close();
            }
        }
        OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
            InputStream fileStream = null;

            public void doIfFails() {
            }

            public void finallyDo() throws Exception {
                if (this.fileStream != null) {
                    this.fileStream.close();
                }
            }

            public void tryToDo() throws Exception {
                try {
                    String value;
                    String name;
                    this.fileStream = new FileInputStream(dynVdbFile);
                    DynamicVdb vdb = DynamicVdb.this;
                    Unmarshaller unmarshaller = vdb.getJaxbContext().createUnmarshaller();
                    unmarshaller.setSchema(vdb.getManifestSchema());
                    VdbElement manifest = (VdbElement)unmarshaller.unmarshal(this.fileStream);
                    vdb.setDescription(manifest.getDescription());
                    vdb.setVersion(manifest.getVersion());
                    vdb.setName(manifest.getName());
                    for (PropertyElement propertyElement : manifest.getProperties()) {
                        String name2 = propertyElement.getName();
                        String value2 = propertyElement.getValue();
                        if ("preview".equals(name2)) {
                            vdb.setPreview(Boolean.parseBoolean(value2));
                            continue;
                        }
                        if ("query-timeout".equals(name2)) {
                            int timeoutMillis = Integer.parseInt(value2);
                            if (timeoutMillis <= 0) continue;
                            vdb.setQueryTimeout(timeoutMillis / 1000);
                            continue;
                        }
                        if ("allowed-languages".equals(name2)) {
                            vdb.getAllowedLanguages().addAllowedLanguage(value2);
                            continue;
                        }
                        if ("security-domain".equals(name2)) {
                            vdb.setSecurityDomain(value2);
                            continue;
                        }
                        if ("gss-pattern".equals(name2)) {
                            vdb.setGssPattern(value2);
                            continue;
                        }
                        if ("password-pattern".equals(name2)) {
                            vdb.setPasswordPattern(value2);
                            continue;
                        }
                        if ("authentication-type".equals(name2)) {
                            vdb.setAuthenticationType(value2);
                            continue;
                        }
                        if ("{http://teiid.org/rest}auto-generate".equals(name2)) {
                            vdb.setAutoGenerateRESTWar(Boolean.parseBoolean(value2));
                            continue;
                        }
                        vdb.setProperty(name2, value2);
                    }
                    for (ModelElement modelElement : manifest.getModels()) {
                        DynamicModel model = new DynamicModel();
                        model.setName(modelElement.getName());
                        model.setVisible(modelElement.isVisible());
                        for (PropertyElement property : modelElement.getProperties()) {
                            name = property.getName();
                            value = property.getValue();
                            model.setProperty(name, value);
                        }
                        if (modelElement.getMetadata() != null && modelElement.getMetadata().size() > 0) {
                            MetadataElement metadataElement = modelElement.getMetadata().get(0);
                            String schemaText = metadataElement.getSchemaText();
                            String metadataType = modelElement.getMetadata().get(0).getType();
                            Metadata metadata = new Metadata();
                            metadata.setSchemaText(schemaText);
                            metadata.setType(metadataType);
                            model.setMetadata(metadata);
                        }
                        model.setModelType(modelElement.getType());
                        if (modelElement.getSources() != null && !modelElement.getSources().isEmpty()) {
                            for (SourceElement sourceElement : modelElement.getSources()) {
                                VdbSource modelSource = new VdbSource(vdb, sourceElement.getName(), sourceElement.getJndiName() == null ? "" : sourceElement.getJndiName(), sourceElement.getTranslatorName() == null ? "" : sourceElement.getTranslatorName());
                                model.addSource(modelSource);
                            }
                        }
                        vdb.addDynamicModel(model);
                    }
                    for (ImportVdbElement importVdbElement : manifest.getImportVdbEntries()) {
                        VdbImportVdbEntry vdbImport = new VdbImportVdbEntry((Vdb)vdb, importVdbElement.getName());
                        vdbImport.setImportDataPolicies(false);
                        vdbImport.setVersion(vdb.getVersion());
                        vdb.addImport(vdbImport);
                    }
                    for (TranslatorElement translatorElement : manifest.getTranslators()) {
                        TranslatorOverride translator = new TranslatorOverride(vdb, translatorElement);
                        for (PropertyElement property : translatorElement.getProperties()) {
                            name = property.getName();
                            value = property.getValue();
                            translator.setProperty(name, value);
                        }
                        vdb.addTranslator(translator);
                    }
                    for (DataRoleElement dataRoleElement : manifest.getDataPolicies()) {
                        DataRole role = new DataRole(dataRoleElement.getName());
                        role.setVdb(vdb);
                        role.setAllowCreateTempTables(dataRoleElement.allowCreateTempTables());
                        role.setAnyAuthenticated(dataRoleElement.isAnyAuthenticated());
                        role.setGrantAll(dataRoleElement.doGrantAll());
                        role.setDescription(dataRoleElement.getDescription());
                        for (PermissionElement pe : dataRoleElement.getPermissions()) {
                            MaskElement mask;
                            boolean allow = false;
                            if (pe != null) {
                                allow = pe.isAllowLanguage();
                            }
                            Permission permission = new Permission(pe.getResourceName(), pe.isCreate(), pe.isRead(), pe.isUpdate(), pe.isDelete(), pe.isExecute(), pe.isAlter());
                            ConditionElement condition = pe.getCondition();
                            if (condition != null) {
                                permission.setCondition(condition.getSql());
                                Boolean constraint = condition.getConstraint();
                                permission.setConstraint(constraint == null ? false : constraint);
                            }
                            if ((mask = pe.getMask()) != null) {
                                if (mask.getOrder() != null) {
                                    permission.setOrder(Integer.valueOf(mask.getOrder()));
                                }
                                permission.setMask(mask.getSql());
                            }
                            if (allow) {
                                permission.setAllowLanguage(true);
                            }
                            role.addPermission(permission);
                        }
                        vdb.addDataRole(role);
                        for (String mappedRoleName : dataRoleElement.getMappedRoleNames()) {
                            role.addRoleName(mappedRoleName);
                        }
                    }
                }
                finally {
                    if (this.fileStream != null) {
                        this.fileStream.close();
                    }
                }
            }
        });
    }

    private boolean validate(InputStream xml) throws Exception {
        if (xml == null) {
            return false;
        }
        Schema schema = VdbUtil.getManifestSchema();
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(xml));
        return true;
    }

    public void write(Writer destination) throws Exception {
        if (destination == null) {
            File destFile = this.getSourceFile().getFullPath().toFile();
            destination = new FileWriter(destFile);
        }
        VdbElement vdbElement = new VdbElement(this);
        try {
            Marshaller marshaller = this.getJaxbContext().createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setSchema(this.getManifestSchema());
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = docBuilderFactory.newDocumentBuilder().newDocument();
            marshaller.marshal((Object)vdbElement, (Node)document);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("cdata-section-elements", "metadata");
            transformer.transform(new DOMSource(document), new StreamResult(destination));
        }
        finally {
            destination.close();
        }
    }

    @Override
    public Collection<DynamicModel> getDynamicModels() {
        return Collections.unmodifiableCollection(this.models().values());
    }

    @Override
    public void addDynamicModel(DynamicModel model) {
        DynamicModel existing = this.models().put(model.getName(), model);
        model.setVdb(this);
        this.setChanged(existing != null);
    }

    @Override
    public boolean isSynchronized() {
        return this.isChanged();
    }

    @Override
    public void synchronize() throws Exception {
    }

    @Override
    public void save() throws Exception {
        this.write(null);
    }

    @Override
    public void removeDynamicModel(String modelToRemove) {
        DynamicModel removed = this.models().remove(modelToRemove);
        this.setChanged(removed != null);
    }

    @Override
    public <T extends VdbEntry> T addEntry(IPath name) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizeUdfJars(Set<VdbFileEntry> newJarEntries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<VdbSchemaEntry> getSchemaEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<VdbFileEntry> getUdfJarEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getUdfJarNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<VdbFileEntry> getUserFileEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<VdbEntry> getEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<VdbModelEntry> getModelEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<File> getModelFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<File> getSchemaFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEntry(VdbEntry entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DynamicVdb clone() {
        DynamicVdb clone = new DynamicVdb();
        this.populateVdb(clone);
        for (DynamicModel dynModel : this.getDynamicModels()) {
            DynamicModel cloneModel = dynModel.clone();
            clone.addDynamicModel(cloneModel);
        }
        return clone;
    }

    @Override
    public DynamicVdb dynVdbConvert(IFile destination, Properties properties) throws Exception {
        CoreArgCheck.isNotNull((Object)destination);
        File newVdbFile = destination.getLocation().toFile();
        FileWriter writer = null;
        try {
            DynamicVdb vdb;
            writer = new FileWriter(newVdbFile);
            this.write(writer);
            DynamicVdb dynamicVdb = vdb = new DynamicVdb(destination);
            return dynamicVdb;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public XmiVdb xmiVdbConvert(IFile destination, Properties options) throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            VdbPlugin.singleton().setConversionInProgress(true);
            XmiVdb xmiVdb = new XmiVdb(destination);
            this.populateVdb(xmiVdb);
            ArrayList<DynamicModel> dynamicModels = new ArrayList<DynamicModel>(this.getDynamicModels());
            if (!dynamicModels.isEmpty()) {
                Collections.sort(dynamicModels, new DynamicModelComparator());
            }
            for (DynamicModel dynModel : dynamicModels) {
                IFile sourceFile = this.getSourceFile();
                IContainer parent = sourceFile.getParent();
                String fileName = String.valueOf(dynModel.getName()) + ".xmi";
                ModelResource modelResource = null;
                IFile modelFile = parent.getFile((IPath)new Path(fileName));
                if (modelFile.exists()) {
                    modelFile.delete(true, (IProgressMonitor)monitor);
                }
                if ((modelResource = ModelerCore.create((IFile)modelFile)) == null) {
                    throw new Exception("Failed to create model resource");
                }
                ModelAnnotation annotation = modelResource.getModelAnnotation();
                annotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/Relational");
                annotation.setModelType(ModelType.get((String)dynModel.getModelType().getType()));
                VdbSource[] sources = dynModel.getSources();
                if (sources != null) {
                    VdbSource[] vdbSourceArray = sources;
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VdbSource source = vdbSourceArray[n2];
                        String translatorProperty = "translator:name";
                        ModelUtil.setModelAnnotationPropertyValue((ModelResource)modelResource, (String)translatorProperty, (String)source.getTranslatorName());
                        String jndiProperty = "connection:JBossDsJndi";
                        ModelUtil.setModelAnnotationPropertyValue((ModelResource)modelResource, (String)jndiProperty, (String)source.getJndiName());
                        ++n2;
                    }
                }
                modelResource.save((IProgressMonitor)monitor, false);
                ModelBuildUtil.indexResources((IProgressMonitor)monitor, Collections.singleton(modelResource.getCorrespondingResource()));
                Metadata metadata = dynModel.getMetadata();
                if (metadata != null) {
                    IProject project = parent.getProject();
                    DdlImporter importer = new DdlImporter(new IProject[]{project});
                    importer.setModelFolder(parent);
                    importer.setModelName(fileName);
                    importer.setOptToCreateModelEntitiesForUnsupportedDdl(false);
                    String ddlAsDescriptionOption = options.getProperty("setDDLAsDescription", Boolean.FALSE.toString());
                    importer.setOptToSetModelEntityDescription(Boolean.parseBoolean(ddlAsDescriptionOption));
                    DynamicModel.Type dynModelType = dynModel.getModelType();
                    String modelType = dynModelType.toString();
                    importer.setModelType(ModelType.get((String)modelType));
                    importer.setGenerateDefaultSQL(DynamicModel.Type.VIRTUAL.equals((Object)dynModelType));
                    importer.setDdlFileName(this.getSourceFile().getLocation().toOSString());
                    importer.setSpecifiedParser("TEIID");
                    importer.importDdl(metadata.getSchemaText(), (IProgressMonitor)monitor, 1, new Properties());
                    if (importer.hasParseError()) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Error Message:").append("\t");
                        buffer.append(importer.getParseErrorMessage().trim()).append("\n");
                        buffer.append("\t").append("\t").append(" ").append(" ").append("Error Line Number:").append("\t");
                        buffer.append(importer.getParseErrorLineNumber()).append("\n");
                        buffer.append("\t").append("\t").append(" ").append(" ").append("Error Column Number:").append("\t");
                        buffer.append(importer.getParseErrorColNumber()).append("\n");
                        buffer.append("\t").append("\t").append(" ").append(" ").append("Error Index:").append("\t");
                        buffer.append(importer.getParseErrorIndex()).append("\n");
                        throw new Exception(buffer.toString());
                    }
                    if (!importer.noDdlImported()) {
                        importer.save((IProgressMonitor)monitor, 1);
                    }
                    modelResource = importer.model();
                }
                VdbModelEntry modelEntry = (VdbModelEntry)xmiVdb.addEntry(modelFile.getFullPath());
                for (Map.Entry<Object, Object> prop : dynModel.getProperties().entrySet()) {
                    modelEntry.setProperty(prop.getKey().toString(), prop.getValue().toString());
                }
                VdbSourceInfo sourceInfo = modelEntry.getSourceInfo();
                sourceInfo.setIsMultiSource(dynModel.isMultiSource());
                sourceInfo.setAddColumn(dynModel.doAddColumn());
                sourceInfo.setColumnAlias(dynModel.getColumnAlias());
                VdbSource[] vdbSourceArray = dynModel.getSources();
                int n = vdbSourceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    VdbSource source = vdbSourceArray[n3];
                    sourceInfo.add(source.getName(), source.getJndiName(), source.getTranslatorName());
                    ++n3;
                }
            }
            XmiVdb xmiVdb2 = xmiVdb;
            return xmiVdb2;
        }
        finally {
            VdbPlugin.singleton().setConversionInProgress(false);
        }
    }
}

