/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbUnit;

public class VdbSource
extends VdbUnit {
    private String jndiName;
    private String translatorName;

    public VdbSource(Vdb vdb, String name, String jndiName, String translatorName) {
        this.setVdb(vdb);
        this.setName(name);
        this.jndiName = jndiName;
        this.translatorName = translatorName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        if (!StringUtilities.equals((String)this.jndiName, (String)jndiName)) {
            this.jndiName = jndiName;
            this.setModified(this, "modelEntry.jndiName", jndiName, this.jndiName);
        }
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public void setTranslatorName(String translatorName) {
        if (!StringUtilities.equals((String)this.translatorName, (String)translatorName)) {
            this.translatorName = translatorName;
            this.setModified(this, "modelEntry.translator", translatorName, this.translatorName);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("VdbSource : ");
        text.append("\n\tsource name = ").append(this.getName());
        text.append("\n\ttranslator name = ").append(this.getTranslatorName());
        text.append("\n\tjndi name = ").append(this.getJndiName());
        return text.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.jndiName == null ? 0 : this.jndiName.hashCode());
        result = 31 * result + (this.translatorName == null ? 0 : this.translatorName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdbSource other = (VdbSource)obj;
        if (this.jndiName == null ? other.jndiName != null : !this.jndiName.equals(other.jndiName)) {
            return false;
        }
        return !(this.translatorName == null ? other.translatorName != null : !this.translatorName.equals(other.translatorName));
    }

    @Override
    public VdbSource clone() {
        VdbSource clone = new VdbSource(this.getVdb(), this.getName(), this.getJndiName(), this.getTranslatorName());
        this.cloneVdbObject(clone);
        return clone;
    }
}

