/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbUnit;

public class AllowedLanguages
extends VdbUnit
implements Iterable<String> {
    private Set<String> languages = new HashSet<String>();

    public AllowedLanguages() {
    }

    public AllowedLanguages(String inputString) {
        this();
        this.addAllowedLanguage(inputString);
    }

    public AllowedLanguages(String[] values) {
        this();
        this.addAllowedLanguages(values);
    }

    public AllowedLanguages(Vdb vdb) {
        this();
        this.setVdb(vdb);
    }

    public String getOutputString() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int max = this.languages.size();
        for (String lang : this.languages) {
            sb.append(lang);
            if (++count >= max) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String[] getAllowedLanguageValues() {
        return this.languages.toArray(new String[this.languages.size()]);
    }

    public void addAllowedLanguage(String value) {
        if (value.contains(",")) {
            this.loadFromString(value);
        } else {
            this.setChanged(this.languages.add(value));
        }
    }

    public void removeAllowedLanguage(String value) {
        this.setChanged(this.languages.remove(value));
    }

    public void addAllowedLanguages(String[] values) {
        boolean changed = false;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean result = this.languages.add(value);
            if (result) {
                changed = true;
            }
            ++n2;
        }
        this.setChanged(changed);
    }

    private boolean loadFromString(String commaSeparatedValues) {
        String[] values = commaSeparatedValues.split(",");
        boolean changed = false;
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boolean result = this.languages.add(value.trim());
            if (result) {
                changed = true;
            }
            ++n2;
        }
        return changed;
    }

    public boolean isEmpty() {
        return this.languages.isEmpty();
    }

    public int size() {
        return this.languages.size();
    }

    @Override
    public Iterator<String> iterator() {
        return this.languages.iterator();
    }

    @Override
    public AllowedLanguages clone() {
        AllowedLanguages clone = new AllowedLanguages();
        for (String language : this.languages) {
            clone.addAllowedLanguage(language);
        }
        this.cloneVdbObject(clone);
        return clone;
    }
}

