/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.Map;
import java.util.Properties;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.StringUtilities;

public abstract class AbstractVdbObject
implements StringConstants {
    private String name = "";
    private String description = "";
    private Properties properties = new Properties();
    private boolean changed;

    public Properties getProperties() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.setChanged(this.name, newName);
        this.name = newName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String key, String value) {
        if (this.properties.get(key) != null) {
            String valueString = this.properties.getProperty(key);
            if (StringUtilities.areDifferent((String)value, (String)valueString)) {
                this.properties.put(key, value);
                this.setChanged(true);
            }
        } else {
            this.properties.put(key, value);
            this.setChanged(true);
        }
    }

    public String removeProperty(String key) {
        String property = this.properties.getProperty(key);
        Object removed = this.properties.remove(key);
        this.setChanged(removed != null);
        return property;
    }

    public void setDescription(String newDescription) {
        this.setChanged(this.description, newDescription);
        this.description = newDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void setChanged(boolean value) {
        this.changed = value;
    }

    protected void setChanged(boolean value1, boolean value2) {
        this.setChanged(value1 ^ value2);
    }

    protected void setChanged(String value1, String value2) {
        this.setChanged(StringUtilities.areDifferent((String)value1, (String)value2));
    }

    protected void setChanged(int value1, int value2) {
        this.setChanged(value1 != value2);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVdbObject other = (AbstractVdbObject)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    protected void cloneVdbObject(AbstractVdbObject clone) {
        if (StringUtilities.areDifferent((String)this.name, (String)clone.getName())) {
            clone.setName(this.name);
        }
        if (StringUtilities.areDifferent((String)this.description, (String)clone.getDescription())) {
            clone.setDescription(this.description);
        }
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            clone.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public abstract AbstractVdbObject clone();
}

