/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles;

import org.teiid.designer.roles.Crud;
import org.teiid.designer.vdb.VdbUnit;

public class Permission
extends VdbUnit {
    boolean DEFAULT_ALLOW_ALTER = false;
    boolean DEFAULT_ALLOW_CREATE = false;
    boolean DEFAULT_ALLOW_DELETE = false;
    boolean DEFAULT_ALLOW_EXECUTE = false;
    boolean DEFAULT_ALLOW_LANGUAGE = false;
    boolean DEFAULT_ALLOW_READ = false;
    boolean DEFAULT_ALLOW_UPDATE = false;
    Permission[] NO_PERMISSIONS = new Permission[0];
    private Crud crud;
    private boolean primary;
    private boolean constraint = true;
    private String condition;
    private int order;
    private String mask;
    private boolean allowLanguage;
    private boolean canFilter;
    private boolean canMask;
    private String NULL = "null";

    public Permission(String targetName) {
        this.setName(targetName);
        this.crud = new Crud();
    }

    public Permission(String targetName, Boolean createAllowed, Boolean readAllowed, Boolean updateAllowed, Boolean deleteAllowed, Boolean executeAllowed, Boolean alterAllowed) {
        this.setName(targetName);
        this.crud = new Crud(createAllowed, readAllowed, updateAllowed, deleteAllowed, executeAllowed, alterAllowed);
    }

    public Permission(String targetName, Crud crud) {
        this.setName(targetName);
        this.crud = new Crud(crud.c, crud.r, crud.u, crud.d, crud.e, crud.a);
    }

    public String getTargetName() {
        return this.getName();
    }

    public Boolean isCreateAllowed() {
        return this.crud.c;
    }

    public void setCreateAllowed(Boolean createAllowed) {
        this.crud.c = createAllowed;
    }

    public Boolean isReadAllowed() {
        return this.crud.r;
    }

    public void setReadAllowed(Boolean readAllowed) {
        this.crud.r = readAllowed;
    }

    public Boolean isUpdateAllowed() {
        return this.crud.u;
    }

    public void setUpdateAllowed(Boolean updateAllowed) {
        this.crud.u = updateAllowed;
    }

    public Boolean isDeleteAllowed() {
        return this.crud.d;
    }

    public void setDeleteAllowed(Boolean deleteAllowed) {
        this.crud.d = deleteAllowed;
    }

    public Boolean isExecuteAllowed() {
        return this.crud.e;
    }

    public void setExecuteAllowed(Boolean executeAllowed) {
        this.crud.e = executeAllowed;
    }

    public Boolean isAlterAllowed() {
        return this.crud.a;
    }

    public void setAlterAllowed(Boolean alterAllowed) {
        this.crud.a = alterAllowed;
    }

    public Crud getCRUD() {
        return new Crud(this.crud);
    }

    public void setCRUD(Boolean c, Boolean r, Boolean u, Boolean d, Boolean e, Boolean a) {
        this.crud = new Crud(c, r, u, d, e, a);
    }

    public void setCRUDValue(Boolean value, Crud.Type type) {
        switch (type) {
            case CREATE: {
                this.setCreateAllowed(value);
                break;
            }
            case READ: {
                this.setReadAllowed(value);
                break;
            }
            case UPDATE: {
                this.setUpdateAllowed(value);
                break;
            }
            case DELETE: {
                this.setDeleteAllowed(value);
                break;
            }
            case EXECUTE: {
                this.setExecuteAllowed(value);
                break;
            }
            case ALTER: {
                this.setAlterAllowed(value);
            }
        }
    }

    public Boolean getCRUDValue(Crud.Type type) {
        switch (type) {
            case CREATE: {
                return this.isCreateAllowed();
            }
            case READ: {
                return this.isReadAllowed();
            }
            case UPDATE: {
                return this.isUpdateAllowed();
            }
            case DELETE: {
                return this.isDeleteAllowed();
            }
            case EXECUTE: {
                return this.isExecuteAllowed();
            }
            case ALTER: {
                return this.isAlterAllowed();
            }
        }
        return null;
    }

    public void toggleCRUDValue(Crud.Type type) {
        Boolean currentValue = this.getCRUDValue(type);
        if (currentValue == Boolean.FALSE) {
            this.setCRUDValue(Boolean.TRUE, type);
        } else {
            this.setCRUDValue(Boolean.FALSE, type);
        }
    }

    public boolean childCrudValueIsDifferent(Boolean parentValue, Boolean childValue) {
        if (parentValue == null) {
            return true;
        }
        if (parentValue == Boolean.TRUE && childValue == null) {
            return false;
        }
        if (parentValue == Boolean.TRUE && childValue == Boolean.TRUE) {
            return false;
        }
        return parentValue != Boolean.FALSE || childValue != Boolean.FALSE;
    }

    public Boolean isEquivalentCRUD(Permission permission) {
        return this.crud.equivalent(permission.getCRUD());
    }

    public boolean isNullCrud() {
        return this.crud.c == null && this.crud.r == null && this.crud.u == null && this.crud.d == null && this.crud.e == null && this.crud.a == null;
    }

    public boolean isFalseCrud() {
        return this.crud.c == Boolean.FALSE && this.crud.r == Boolean.FALSE && this.crud.u == Boolean.FALSE && this.crud.d == Boolean.FALSE && this.crud.e == Boolean.FALSE && this.crud.a == Boolean.FALSE;
    }

    @Override
    public boolean equals(Object obj) {
        Permission perm;
        if (obj instanceof Permission && (perm = (Permission)obj).getName().equalsIgnoreCase(this.getName())) {
            return perm.getCRUD().isSameAs(this.getCRUD());
        }
        return false;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Permission: ").append(this.getTargetName());
        String value = this.NULL;
        if (this.crud.c != null) {
            value = Boolean.toString(this.crud.c);
        }
        sb.append("\n\t").append("c = " + value);
        value = this.NULL;
        if (this.crud.r != null) {
            value = Boolean.toString(this.crud.r);
        }
        sb.append("\n\t").append("r = " + value);
        value = this.NULL;
        if (this.crud.u != null) {
            value = Boolean.toString(this.crud.u);
        }
        sb.append("\n\t").append("u = " + value);
        value = this.NULL;
        if (this.crud.d != null) {
            value = Boolean.toString(this.crud.d);
        }
        sb.append("\n\t").append("d = " + value);
        value = this.NULL;
        if (this.crud.e != null) {
            value = Boolean.toString(this.crud.e);
        }
        sb.append("\n\t").append("e = " + value);
        value = this.NULL;
        if (this.crud.a != null) {
            value = Boolean.toString(this.crud.a);
        }
        sb.append("\n\t").append("a = " + value);
        sb.append("\n\t").append("allow-language = " + this.allowLanguage);
        return sb.toString();
    }

    public boolean isConstraint() {
        return this.constraint;
    }

    public void setConstraint(boolean constraint) {
        this.constraint = constraint;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public boolean isAllowLanguage() {
        return this.allowLanguage;
    }

    public void setAllowLanguage(boolean allowLanguage) {
        this.allowLanguage = allowLanguage;
    }

    public boolean canMask() {
        return this.canMask;
    }

    public void setCanMask(boolean canMask) {
        this.canMask = canMask;
    }

    public boolean canFilter() {
        return this.canFilter;
    }

    public void setCanFilter(boolean canFilter) {
        this.canFilter = canFilter;
    }

    @Override
    public Permission clone() {
        Permission clone = new Permission(this.getName());
        this.cloneVdbObject(clone);
        clone.crud = this.getCRUD().clone();
        clone.setPrimary(this.isPrimary());
        clone.setConstraint(this.isConstraint());
        clone.setCondition(this.getCondition());
        clone.setOrder(this.getOrder());
        clone.setMask(this.getMask());
        clone.setAllowLanguage(this.isAllowLanguage());
        clone.setCanFilter(this.canFilter());
        clone.setCanMask(this.canMask());
        return clone;
    }
}

