/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.roles;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.VdbUnit;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.DataRoleElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.PermissionElement;

public class DataRole
extends VdbUnit {
    boolean DEFAULT_ALLOW_CREATE_TEMP_TABLES = false;
    boolean DEFAULT_ANY_AUTHENTICATED = false;
    boolean DEFAULT_GRANT_ALL = false;
    DataRole[] NO_DATA_ROLES = new DataRole[0];
    private Boolean grantAll;
    private Set<String> roleNames;
    private Map<String, Permission> permissions;
    private Boolean anyAuthenticated;
    private Boolean allowCreateTempTables;

    public DataRole(String name) {
        this.setName(name);
        this.roleNames = new HashSet<String>();
        this.permissions = new HashMap<String, Permission>();
    }

    public DataRole(DataRole dataRole) {
        this.setVdb(dataRole.getVdb());
        this.setName(dataRole.getName());
        this.setDescription(dataRole.getDescription());
        this.setGrantAll(dataRole.isGrantAll());
        this.setRoleNames(dataRole.getRoleNames());
        this.setPermissions(dataRole.getPermissions());
        this.setAnyAuthenticated(dataRole.isAnyAuthenticated());
        this.setAllowCreateTempTables(dataRole.isAllowCreateTempTables());
    }

    public DataRole(DataRoleElement element) {
        this(element.getName());
        this.setAnyAuthenticated(element.isAnyAuthenticated());
        this.setAllowCreateTempTables(element.allowCreateTempTables());
        this.setGrantAll(element.doGrantAll());
        this.setDescription(element.getDescription() == null ? "" : element.getDescription());
        this.setRoleNames(element.getMappedRoleNames());
        for (PermissionElement pe : element.getPermissions()) {
            MaskElement mask;
            boolean allow = false;
            if (pe != null) {
                allow = pe.isAllowLanguage();
            }
            Permission permission = new Permission(pe.getResourceName(), pe.isCreate(), pe.isRead(), pe.isUpdate(), pe.isDelete(), pe.isExecute(), pe.isAlter());
            ConditionElement condition = pe.getCondition();
            if (condition != null) {
                permission.setCondition(condition.getSql());
                if (!condition.getConstraint().booleanValue()) {
                    permission.setConstraint(condition.getConstraint());
                }
            }
            if ((mask = pe.getMask()) != null) {
                permission.setMask(mask.getSql());
                if (mask.getOrder() != null) {
                    permission.setOrder(Integer.valueOf(mask.getOrder()));
                }
            }
            if (allow) {
                permission.setAllowLanguage(true);
            }
            this.addPermission(permission);
        }
    }

    public DataRole(String name, String description, Boolean anyAuthenticated, Boolean allowCreateTempTables, Boolean grantAll, Collection<String> roleNames, Collection<Permission> permissions) {
        this.setName(name);
        this.setDescription(description);
        this.anyAuthenticated = anyAuthenticated;
        this.allowCreateTempTables = allowCreateTempTables;
        this.grantAll = grantAll;
        this.roleNames = new HashSet<String>(roleNames);
        this.setPermissions(permissions);
    }

    public Collection<Permission> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions.values());
    }

    public Permission getPermission(String name) {
        return this.permissions.get(name);
    }

    public void setPermissions(Collection<Permission> permissions) {
        if (this.permissions == null) {
            this.permissions = new HashMap<String, Permission>();
        } else {
            this.permissions.clear();
        }
        if (permissions != null) {
            for (Permission next : permissions) {
                Permission perm = next.clone();
                this.permissions.put(perm.getTargetName(), perm);
            }
        }
    }

    public Permission createPermission(String targetName, Boolean createAllowed, Boolean readAllowed, Boolean updateAllowed, Boolean deleteAllowed, Boolean executeAllowed, Boolean alterAllowed) {
        Permission perm = new Permission(targetName, createAllowed, readAllowed, updateAllowed, deleteAllowed, executeAllowed, alterAllowed);
        this.addPermission(perm);
        return perm;
    }

    public void addPermission(Permission permission) {
        CoreArgCheck.isNotNull((Object)permission, (String)"permission");
        this.permissions.put(permission.getTargetName(), permission);
        this.setChanged(true);
    }

    public void removePermission(Permission permission) {
        CoreArgCheck.isNotNull((Object)permission, (String)"permission");
        if (this.permissions.remove(permission) != null) {
            this.setChanged(true);
        }
    }

    public Boolean isGrantAll() {
        return this.grantAll;
    }

    public void setGrantAll(Boolean newGrantAll) {
        if (this.grantAll != newGrantAll) {
            this.grantAll = newGrantAll;
            this.setChanged(true);
        }
    }

    public Boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public void setAnyAuthenticated(Boolean newAnyAuthenticated) {
        if (this.anyAuthenticated != newAnyAuthenticated) {
            this.anyAuthenticated = newAnyAuthenticated;
            this.setChanged(true);
        }
    }

    public Collection<String> getRoleNames() {
        return this.roleNames;
    }

    public void setRoleNames(Collection<String> roleNames) {
        CoreArgCheck.isNotNull(roleNames, (String)"roleNames");
        this.roleNames = new HashSet<String>(roleNames);
    }

    public void addRoleName(String roleName) {
        if (!this.roleNames.contains(roleName)) {
            this.roleNames.add(roleName);
            this.setChanged(true);
        }
    }

    public void removeRoleName(String roleNameToRemove) {
        if (this.roleNames.remove(roleNameToRemove)) {
            this.setChanged(true);
        }
    }

    public Boolean isAllowCreateTempTables() {
        return this.allowCreateTempTables;
    }

    public void setAllowCreateTempTables(Boolean newAllowCreateTempTables) {
        if (this.allowCreateTempTables != newAllowCreateTempTables) {
            this.allowCreateTempTables = newAllowCreateTempTables;
            this.setChanged(true);
        }
    }

    @Override
    public DataRole clone() {
        DataRole clone = new DataRole(this.getName());
        this.cloneVdbObject(clone);
        clone.setAnyAuthenticated(this.isAnyAuthenticated());
        clone.setAllowCreateTempTables(this.isAllowCreateTempTables());
        clone.setGrantAll(this.isGrantAll());
        if (this.getDescription() != null) {
            clone.setDescription(this.getDescription());
        }
        for (String roleName : this.getRoleNames()) {
            clone.addRoleName(roleName);
        }
        for (Permission permission : this.getPermissions()) {
            clone.addPermission(permission.clone());
        }
        return clone;
    }
}

