/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.viewsupport.ListContentProvider;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;
import org.teiid.designer.ui.viewsupport.IPropertiesContext;
import org.teiid.designer.ui.viewsupport.ModelLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.viewsupport.SingleProjectFilter;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.editor.VdbEditor;

public final class NewVdbWizard
extends AbstractWizard
implements IPropertiesContext,
INewWizard,
InternalUiConstants.Widgets,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(NewVdbWizard.class);
    private static final String TITLE = NewVdbWizard.getString("title");
    private static final String PAGE_TITLE = NewVdbWizard.getString("pageTitle");
    private static final String VDB_NAME_ERROR = NewVdbWizard.getString("vdbNameError");
    private static final int COLUMN_COUNT = 3;
    private static final String NAME_LABEL = NewVdbWizard.getString("nameLabel");
    private static final String FOLDER_LABEL = NewVdbWizard.getString("folderLabel");
    private static final String INITIAL_MESSAGE = NewVdbWizard.getString("initialMessage");
    private static final String CREATE_FILE_ERROR_MESSAGE = NewVdbWizard.getString("createFileErrorMessage");
    private static final String NOT_MODEL_PROJECT_MSG = NewVdbWizard.getString("notModelProjectMessage");
    private static final String SELECT_FOLDER_MESSAGE = NewVdbWizard.getString("selectFolderMessage");
    static final String ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE = VdbUiConstants.Util.getString("addFileDialogInvalidSelectionMessage", new Object[0]);
    static final String ADD_FILE_DIALOG_NON_MODEL_SELECTED_MESSAGE = VdbUiConstants.Util.getString("addFileDialogNonModelSelectedMessage", new Object[0]);
    static final String ADD_FILE_DIALOG_VDB_SOURCE_MODEL_SELECTED_MESSAGE = VdbUiConstants.Util.getString("addFileDialogVdbSourceModelSelectedMessage", new Object[0]);
    static final String SELECTED_MODELS_CONTAIN_DUPLICATE_NAMES = VdbUiConstants.Util.getString("selectedModelsAndDependenciesContainDuplicateNamesMessage", new Object[0]);
    static final String ADD_FILE_DIALOG_MODELS_IN_DIFFERENT_PROJECTS_MESSAGE = VdbUiConstants.Util.getString("selectedModelsAreInDifferentProjectsMessage", new Object[0]);
    private static final StringNameValidator nameValidator = new StringNameValidator(1, 255, new char[]{'_', '-', '.'});
    String name;
    IContainer folder;
    private WizardPage mainPage;
    Text nameText;
    Text folderText;
    TableViewer modelsViewer;
    StyledTextEditor descriptionTextEditor;
    Button btnBrowse;
    Button addModelsButton;
    Button removeModelsButton;
    private ISelectionStatusValidator projectValidator = new ModelProjectSelectionStatusValidator();
    final ModelLabelProvider modelLabelProvider = new ModelLabelProvider();
    IStructuredSelection initialSelection;
    List<IResource> modelsForVdb;
    Properties designerProperties;
    private boolean openProjectExists = true;
    private IProject newProject;
    final ISelectionStatusValidator validator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            int ndx = selection.length;
            while (--ndx >= 0) {
                Object obj = selection[ndx];
                if (obj instanceof IContainer) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_INVALID_SELECTION_MESSAGE, null);
                }
                if (!(obj instanceof IFile)) continue;
                IFile file = (IFile)obj;
                if (!ModelUtilities.isModelFile((IResource)file) && !ModelUtil.isXsdFile((IResource)file)) {
                    return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_NON_MODEL_SELECTED_MESSAGE, null);
                }
                if (!ModelUtilities.isVdbSourceModel((IFile)file)) continue;
                return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_VDB_SOURCE_MODEL_SELECTED_MESSAGE, null);
            }
            IProject targetProject = null;
            int ndx2 = selection.length;
            while (--ndx2 >= 0) {
                Object obj = selection[ndx2];
                if (!(obj instanceof IFile)) continue;
                IProject proj = ((IFile)obj).getProject();
                if (targetProject == null) {
                    targetProject = proj;
                    continue;
                }
                if (proj == targetProject) continue;
                return new Status(4, "org.teiid.designer.vdb.ui", 0, ADD_FILE_DIALOG_MODELS_IN_DIFFERENT_PROJECTS_MESSAGE, null);
            }
            return new Status(0, "org.teiid.designer.vdb.ui", 0, "", null);
        }
    };

    static String getString(String id) {
        return VdbUiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public NewVdbWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, null);
        this.modelsForVdb = new ArrayList<IResource>();
    }

    public boolean finish() {
        if (!this.name.endsWith(".vdb")) {
            this.name = String.valueOf(this.name) + ".vdb";
        }
        if (this.designerProperties != null) {
            DesignerPropertiesUtil.setVdbName((Properties)this.designerProperties, (String)this.name);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        VdbEditor editor;
                        IFile vdbFile = NewVdbWizard.this.folder.getFile((IPath)new Path(NewVdbWizard.this.name));
                        vdbFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, monitor);
                        XmiVdb newVdb = new XmiVdb(vdbFile, false);
                        String desc = NewVdbWizard.this.descriptionTextEditor.getText();
                        if (desc != null && desc.length() > 0) {
                            newVdb.setDescription(desc);
                        }
                        newVdb.save();
                        NewVdbWizard.this.folder.refreshLocal(2, monitor);
                        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)vdbFile);
                        if (NewVdbWizard.this.modelsForVdb != null && !NewVdbWizard.this.modelsForVdb.isEmpty() && (editor = NewVdbWizard.this.getVdbEditor(vdbFile)) != null) {
                            ArrayList<IFile> models = new ArrayList<IFile>();
                            for (IResource nextModel : NewVdbWizard.this.modelsForVdb) {
                                models.add((IFile)nextModel);
                            }
                            editor.addModels(models);
                            editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, op);
            return true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            VdbUiConstants.Util.log(err);
            WidgetUtil.showError((String)CREATE_FILE_ERROR_MESSAGE);
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection originalSelection) {
        IStructuredSelection selection = originalSelection;
        this.openProjectExists = ModelerUiViewUtils.workspaceHasOpenModelProjects();
        if (!this.openProjectExists) {
            this.newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (this.newProject != null) {
                selection = new StructuredSelection((Object)this.newProject);
                this.openProjectExists = true;
            } else {
                this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
                return;
            }
        }
        if (this.isAllModelsSelected((ISelection)selection)) {
            this.initialSelection = new StructuredSelection(selection.toArray());
        }
        if (selection != null && !selection.isEmpty()) {
            this.folder = ModelUtil.getContainer((Object)selection.getFirstElement());
        }
        if (this.folder != null && !this.folderInModelProject()) {
            this.mainPage = new WizardPage(NewVdbWizard.class.getSimpleName(), PAGE_TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)NewVdbWizard.this.createEmptyPageControl(parent));
                }
            };
            this.mainPage.setMessage(NOT_MODEL_PROJECT_MSG, 3);
        } else {
            this.mainPage = new WizardPage(NewVdbWizard.class.getSimpleName(), PAGE_TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)NewVdbWizard.this.createPageControl(parent));
                }
            };
            this.mainPage.setMessage(INITIAL_MESSAGE);
            if (this.folder != null) {
                if (!this.projectValidator.validate(new Object[]{this.folder}).isOK()) {
                    this.folder = null;
                }
            } else {
                this.mainPage.setMessage(SELECT_FOLDER_MESSAGE, 3);
            }
        }
        this.mainPage.setPageComplete(false);
        this.addPage((IWizardPage)this.mainPage);
    }

    private boolean folderInModelProject() {
        boolean result = false;
        if (this.folder != null) {
            IProject project = this.folder.getProject();
            try {
                if (project != null && project.getNature("org.teiid.designer.core.modelNature") != null) {
                    result = true;
                }
            }
            catch (CoreException ex) {
                VdbUiConstants.Util.log((Throwable)ex);
            }
        }
        return result;
    }

    boolean isAllModelsSelected(ISelection theSelection) {
        boolean result;
        if (theSelection == null || theSelection.isEmpty()) {
            return true;
        }
        boolean bl = result = theSelection instanceof IStructuredSelection && SelectionUtilities.isAllIResourceObjects((ISelection)theSelection);
        if (result) {
            List selectedObjects = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
            for (IResource res : selectedObjects) {
                if (ModelUtilities.isModelFile((IResource)res) && !ModelUtilities.isVdbSourceModel((IFile)((IFile)res))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    Composite createPageControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        mainPanel.setLayout((Layout)new GridLayout(3, false));
        WidgetFactory.createLabel((Composite)mainPanel, (String)FOLDER_LABEL);
        String name = this.folder == null ? null : this.folder.getFullPath().makeRelative().toString();
        this.folderText = WidgetFactory.createTextField((Composite)mainPanel, (int)768, (int)1, (String)name, (int)8);
        this.folderText.setBackground(this.getShell().getDisplay().getSystemColor(19));
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewVdbWizard.this.folderModified();
            }
        });
        this.btnBrowse = WidgetFactory.createButton((Composite)mainPanel, (String)BROWSE_BUTTON);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewVdbWizard.this.browseButtonSelected();
            }
        });
        WidgetFactory.createLabel((Composite)mainPanel, (String)NAME_LABEL);
        this.nameText = WidgetFactory.createTextField((Composite)mainPanel, (int)256, (int)2);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewVdbWizard.this.nameModified();
            }
        });
        if (this.folder == null) {
            this.btnBrowse.setFocus();
        } else {
            this.nameText.setFocus();
        }
        Group descGroup = WidgetFactory.createGroup((Composite)mainPanel, (String)NewVdbWizard.getString("description"), (int)768, (int)3);
        this.descriptionTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridData descGridData = new GridData(1808);
        descGridData.horizontalSpan = 1;
        descGridData.heightHint = 50;
        descGridData.minimumHeight = 30;
        descGridData.grabExcessVerticalSpace = true;
        this.descriptionTextEditor.setLayoutData((Object)descGridData);
        this.descriptionTextEditor.setText("");
        Group group = WidgetFactory.createGroup((Composite)mainPanel, (String)NewVdbWizard.getString("selectedModelsGroupTitle"), (int)1808, (int)3, (int)2);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        Composite leftToolbarPanel = new Composite((Composite)group, 0);
        leftToolbarPanel.setLayout((Layout)new GridLayout());
        GridData ltpGD = new GridData(1040);
        ltpGD.heightHint = 120;
        leftToolbarPanel.setLayoutData((Object)ltpGD);
        this.addModelsButton = new Button(leftToolbarPanel, 8);
        this.addModelsButton.setText(NewVdbWizard.getString("add"));
        this.addModelsButton.setToolTipText(NewVdbWizard.getString("addModelsTooltip"));
        this.addModelsButton.setLayoutData((Object)new GridData(768));
        this.addModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewVdbWizard.this.handleAddModelsSelected();
                if (!NewVdbWizard.this.modelsViewer.getSelection().isEmpty()) {
                    NewVdbWizard.this.removeModelsButton.setEnabled(true);
                }
            }
        });
        this.removeModelsButton = new Button(leftToolbarPanel, 8);
        this.removeModelsButton.setText(NewVdbWizard.getString("remove"));
        this.removeModelsButton.setLayoutData((Object)new GridData(768));
        this.removeModelsButton.setEnabled(false);
        this.removeModelsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<IResource> models = new ArrayList<IResource>();
                IStructuredSelection selection = (IStructuredSelection)NewVdbWizard.this.modelsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof IResource) {
                        models.add((IResource)obj);
                    }
                    ++n2;
                }
                NewVdbWizard.this.removeModels(models);
                NewVdbWizard.this.removeModelsButton.setEnabled(false);
            }
        });
        this.modelsViewer = new TableViewer((Composite)group);
        GridData gdv = new GridData(1808);
        this.modelsViewer.getControl().setLayoutData((Object)gdv);
        this.modelsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.modelsViewer.setLabelProvider((IBaseLabelProvider)new ModelExplorerLabelProvider());
        if (this.designerProperties != null && !this.designerProperties.isEmpty()) {
            IFile sourceMdl = DesignerPropertiesUtil.getSourceModel((Properties)this.designerProperties);
            IFile viewMdl = DesignerPropertiesUtil.getViewModel((Properties)this.designerProperties);
            if (sourceMdl != null) {
                this.modelsForVdb.add((IResource)sourceMdl);
            }
            if (viewMdl != null) {
                this.modelsForVdb.add((IResource)viewMdl);
            }
        } else {
            this.modelsForVdb.addAll(SelectionUtilities.getSelectedIResourceObjects((ISelection)this.initialSelection));
        }
        this.modelsViewer.setInput(this.modelsForVdb);
        this.modelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewVdbWizard.this.removeModelsButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.updateForProperties();
        return mainPanel;
    }

    void handleAddModelsSelected() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IContainer) {
                    if (NewVdbWizard.this.folder != null) {
                        return NewVdbWizard.this.folder.getProject() == ((IContainer)element).getProject();
                    }
                    return true;
                }
                IFile file = (IFile)element;
                return ModelUtilities.isModelFile((IResource)file) && !ModelUtil.isXsdFile((IResource)file);
            }
        };
        ModelingResourceFilter wsFilter = new ModelingResourceFilter(filter);
        wsFilter.setShowHiddenProjects(true);
        Object[] models = WidgetUtil.showWorkspaceObjectSelectionDialog((String)NewVdbWizard.getString("selectModelsTitle"), (String)NewVdbWizard.getString("selectModelsMessage"), (boolean)true, null, (ViewerFilter)wsFilter, (ISelectionStatusValidator)this.validator, (ILabelProvider)this.modelLabelProvider);
        this.addModels(models);
    }

    void addModels(Object[] models) {
        Object[] objectArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object model = objectArray[n2];
            if (this.folder == null) {
                this.folder = ((IFile)model).getProject();
                this.folderText.setText(this.folder.getFullPath().makeRelative().toString());
            }
            if (!this.modelsForVdb.contains(model)) {
                this.modelsForVdb.add((IResource)model);
            }
            ++n2;
        }
        this.modelsViewer.refresh();
        this.validatePage();
    }

    void removeModels(Collection<IResource> models) {
        for (IResource model : models) {
            this.modelsForVdb.remove(model);
        }
        this.modelsViewer.refresh();
        this.validatePage();
    }

    void browseButtonSelected() {
        ModelingResourceFilter resFilter = new ModelingResourceFilter();
        resFilter.addFilter((ViewerFilter)new SingleProjectFilter(this.designerProperties));
        this.folder = WidgetUtil.showFolderSelectionDialog((IContainer)this.folder, (ViewerFilter)resFilter, (ISelectionStatusValidator)this.projectValidator);
        if (this.folder != null) {
            this.folderText.setText(this.folder.getFullPath().makeRelative().toString());
            if (CoreStringUtil.isEmpty((String)this.nameText.getText())) {
                this.nameText.setFocus();
            }
        }
        this.validatePage();
    }

    void folderModified() {
        this.validatePage();
    }

    void nameModified() {
        this.validatePage();
    }

    private void validatePage() {
        boolean okToAdd = true;
        try {
            for (IResource model : this.modelsForVdb) {
                if (VdbUtil.canAddModelToVdb((IFile)((IFile)model), null)) continue;
                okToAdd = false;
                break;
            }
        }
        catch (Exception ex) {
            okToAdd = false;
            VdbUiConstants.Util.log((Throwable)ex);
            WizardUtil.setPageComplete((WizardPage)this.mainPage, (String)ex.getLocalizedMessage(), (int)3);
        }
        if (!okToAdd) {
            this.mainPage.setPageComplete(false);
            this.mainPage.setErrorMessage(SELECTED_MODELS_CONTAIN_DUPLICATE_NAMES);
            return;
        }
        try {
            IContainer folder = WizardUtil.validateFileAndFolder((Text)this.nameText, (Text)this.folderText, (WizardPage)this.mainPage, (String)".vdb", (boolean)false);
            if (this.mainPage.getMessageType() == 3) {
                return;
            }
            IStatus status = this.projectValidator.validate(new Object[]{folder});
            String proposedName = this.nameText.getText();
            if (!status.isOK()) {
                if (folder != null) {
                    this.mainPage.setErrorMessage(status.getMessage());
                    this.mainPage.setPageComplete(false);
                }
            } else if (!nameValidator.isValidName(proposedName)) {
                this.mainPage.setErrorMessage(VDB_NAME_ERROR);
                this.mainPage.setPageComplete(false);
            } else if (ModelUtilities.vdbNameReservedValidation((String)proposedName) != null) {
                this.mainPage.setErrorMessage(ModelUtilities.vdbNameReservedValidation((String)proposedName));
                this.mainPage.setPageComplete(false);
            } else {
                this.mainPage.setErrorMessage(null);
                this.mainPage.setPageComplete(true);
            }
            if (this.mainPage.isPageComplete()) {
                this.name = proposedName;
                this.folder = folder;
            }
        }
        catch (CoreException err) {
            VdbUiConstants.Util.log((Throwable)err);
            WizardUtil.setPageComplete((WizardPage)this.mainPage, (String)err.getLocalizedMessage(), (int)3);
        }
    }

    public VdbEditor getVdbEditor(IFile vdb) {
        VdbEditor editor;
        IWorkbenchPage page;
        IWorkbenchWindow window = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = this.findEditorPart(page, vdb)) != null) {
            return editor;
        }
        return null;
    }

    private VdbEditor findEditorPart(IWorkbenchPage page, IFile vdbFile) {
        IEditorReference[] editors = page.getEditorReferences();
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i].getEditor(false);
            if (editor instanceof VdbEditor) {
                VdbEditor vdbEditor = (VdbEditor)editor;
                IPath editorVdbPath = vdbEditor.getVdb().getSourceFile().getFullPath();
                if (vdbFile.getFullPath().equals((Object)editorVdbPath)) {
                    return vdbEditor;
                }
            }
            ++i;
        }
        return null;
    }

    public void setProperties(Properties properties) {
        this.designerProperties = properties;
    }

    private void updateForProperties() {
        if (this.designerProperties != null) {
            IFile sourceModel;
            IFile viewModel;
            IProject project;
            if (this.folder == null && (project = DesignerPropertiesUtil.getProject((Properties)this.designerProperties)) != null) {
                this.folder = project;
                this.folderText.setText(this.folder.getFullPath().makeRelative().toString());
                if (CoreStringUtil.isEmpty((String)this.nameText.getText())) {
                    this.nameText.setFocus();
                }
            }
            if ((viewModel = DesignerPropertiesUtil.getViewModel((Properties)this.designerProperties)) != null) {
                this.addModels(new IFile[]{viewModel});
            }
            if ((sourceModel = DesignerPropertiesUtil.getSourceModel((Properties)this.designerProperties)) != null) {
                this.addModels(new IFile[]{sourceModel});
            }
        }
        if (this.designerProperties != null && !this.openProjectExists) {
            DesignerPropertiesUtil.setProjectStatus((Properties)this.designerProperties, (String)"noOpenProject");
        }
    }
}

