/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xsd.XsdHeader;
import org.teiid.designer.common.xsd.XsdHeaderReader;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.core.xmi.ModelImportInfo;
import org.teiid.designer.core.xmi.XMIHeader;
import org.teiid.designer.core.xmi.XMIHeaderReader;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.XmiVdb;

public class VdbResourceFinder {
    protected static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];
    private ContainerImpl container;
    private Vdb vdb;
    private IFile vdbFile;
    private Collection<Resource> vdbResourceFiles;

    public VdbResourceFinder(IFile vdbFile) throws CoreException {
        this.vdbFile = vdbFile;
        this.initialize();
    }

    private void initialize() throws CoreException {
        this.container = (ContainerImpl)ModelerCore.createContainer((String)"tempVdbModelContainer");
        ModelEditorImpl.setContainer((ContainerImpl)this.container);
        try {
            this.vdb = new XmiVdb(this.vdbFile, false);
        }
        catch (Exception ex) {
            throw ErrorHandler.toCoreException((Throwable)ex);
        }
        ArrayList<Resource> resourceFiles = new ArrayList<Resource>();
        Collection modelFiles = this.getVdb().getModelFiles();
        for (File modelFile : modelFiles) {
            Resource res = this.container.getResource(URI.createFileURI((String)modelFile.getPath()), true);
            resourceFiles.add(res);
        }
        Collection schemaFiles = this.getVdb().getSchemaFiles();
        for (File modelFile : schemaFiles) {
            Resource res = this.container.getResource(URI.createFileURI((String)modelFile.getPath()), true);
            resourceFiles.add(res);
        }
        this.vdbResourceFiles = resourceFiles;
    }

    public void dispose() {
        this.vdb = null;
        this.container = null;
        ModelEditorImpl.setContainer(null);
    }

    public ContainerImpl getContainer() {
        return this.container;
    }

    public Vdb getVdb() {
        return this.vdb;
    }

    public IFile getVdbFile() {
        return this.vdbFile;
    }

    public Collection<Resource> getWebServiceResources() throws CoreException {
        ArrayList<Resource> webServiceModels = new ArrayList<Resource>();
        Collection modelFiles = this.getVdb().getModelFiles();
        for (File modelFile : modelFiles) {
            boolean isVisible = true;
            Resource res = this.container.getResource(URI.createFileURI((String)modelFile.getPath()), true);
            if (!isVisible || !ModelUtil.isModelFile((Resource)res) || ModelUtil.isXsdFile((Resource)res)) continue;
            EObject firstEObj = (EObject)res.getContents().get(0);
            ModelAnnotation ma = ModelerCore.getModelEditor().getModelAnnotation(firstEObj);
            String mmURI = ma.getPrimaryMetamodelUri();
            if (!"http://www.metamatrix.com/metamodels/WebService".equalsIgnoreCase(mmURI)) continue;
            webServiceModels.add(res);
        }
        return webServiceModels;
    }

    public Resource[] getDependentResources(Resource resource) {
        if (resource == null || this.getWorkspace() == null) {
            return EMPTY_RESOURCE_ARRAY;
        }
        File theFile = new File(resource.getURI().toFileString());
        ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            XMIHeader header;
            if (ModelUtil.isXsdFile((Resource)resource)) {
                XsdHeader header2 = XsdHeaderReader.readHeader((File)theFile);
                if (header2 != null) {
                    String absolutePath;
                    Resource dependentResource;
                    String location;
                    String[] locations = header2.getImportSchemaLocations();
                    int i = 0;
                    while (i != locations.length) {
                        location = locations[i];
                        dependentResource = this.findResource(location);
                        if (dependentResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation((File)theFile, (String)location);
                            dependentResource = this.findResource(absolutePath);
                        }
                        if (dependentResource != null && !result.contains(dependentResource)) {
                            result.add(dependentResource);
                        }
                        ++i;
                    }
                    locations = header2.getIncludeSchemaLocations();
                    i = 0;
                    while (i != locations.length) {
                        location = locations[i];
                        dependentResource = this.findResource(location);
                        if (dependentResource == null) {
                            absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation((File)theFile, (String)location);
                            dependentResource = this.findResource(absolutePath);
                        }
                        if (dependentResource != null && !result.contains(dependentResource)) {
                            result.add(dependentResource);
                        }
                        ++i;
                    }
                }
            } else if (ModelUtil.isModelFile((Resource)resource) && (header = XMIHeaderReader.readHeader((File)theFile)) != null) {
                ModelImportInfo[] infos;
                String fullFilePath = resource.getURI().path();
                IPath fileLocationPath = new Path(fullFilePath).removeLastSegments(1);
                String fileLocation = fileLocationPath.toOSString();
                ModelImportInfo[] modelImportInfoArray = infos = header.getModelImportInfos();
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelImportInfo info = modelImportInfoArray[n2];
                    Resource dependentResource = null;
                    String location = info.getLocation();
                    if (!location.startsWith("http:")) {
                        String depPath;
                        String path = new Path(fileLocation).append(location).toOSString();
                        if (!CoreStringUtil.isEmpty((String)path)) {
                            dependentResource = this.findResource(path);
                        } else if (!CoreStringUtil.isEmpty((String)location) && !WorkspaceResourceFinderUtil.isGlobalResource((String)(depPath = fileLocation)) && (dependentResource = this.findResource(depPath)) == null) {
                            String absolutePath = WorkspaceResourceFinderUtil.getAbsoluteLocation((File)theFile, (String)location);
                            dependentResource = this.findResource(absolutePath);
                        }
                        if (dependentResource != null && !result.contains(dependentResource)) {
                            result.add(dependentResource);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception err) {
            Object[] params = new Object[]{resource.getURI()};
            String msg = ModelerCore.Util.getString("WorkspaceResourceFinderUtil.Error_getting_model_imports_from_resource", params);
            ModelerCore.Util.log(4, (Throwable)err, msg);
        }
        return result.toArray(new Resource[result.size()]);
    }

    private IWorkspace getWorkspace() {
        return ModelerCore.getWorkspace();
    }

    public Resource findResource(String workspaceUri) {
        if (!WorkspaceResourceFinderUtil.isValidWorkspaceUri((String)workspaceUri)) {
            return null;
        }
        String normalizedUriString = WorkspaceResourceFinderUtil.normalizeUriString((String)workspaceUri);
        File modelFile = new File(normalizedUriString);
        if (modelFile.exists()) {
            return this.getExistingVdbResource(modelFile);
        }
        Resource fileResource = null;
        Collection<Resource> fileResources = this.vdbResourceFiles;
        fileResource = this.getResourceStartsWithHttp(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = VdbResourceFinder.getResourceStartsWithPathSeparator(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        fileResource = VdbResourceFinder.getResourceByLocation(fileResources, normalizedUriString);
        if (fileResource != null) {
            return fileResource;
        }
        return null;
    }

    private Resource getExistingVdbResource(File file) {
        for (Resource modelFile : this.vdbResourceFiles) {
            String fileStr;
            String vdbFileStr;
            String prefix = vdbFileStr.substring(0, (vdbFileStr = WorkspaceResourceFinderUtil.normalizeUriString((String)modelFile.getURI().toFileString())).indexOf("\\") > -1 ? vdbFileStr.indexOf("\\") : 0);
            if (prefix.length() > 0 && prefix.contains(":")) {
                vdbFileStr = vdbFileStr.replace(prefix, "");
            }
            if (!vdbFileStr.equals(fileStr = file.getPath())) continue;
            return modelFile;
        }
        return null;
    }

    public void getAllDependentSchemas(Resource[] resources, ArrayList<Resource> dependentSchemas) {
        Resource resource;
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource = resourceArray[n2];
            if (ModelUtil.isXsdFile((Resource)resource) && this.shouldAddSchema(resource, dependentSchemas)) {
                dependentSchemas.add(resource);
            }
            ++n2;
        }
        resourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resourceArray[n2];
            Resource[] moreResources = this.getDependentResources(resource);
            if (moreResources.length > 0) {
                this.getAllDependentSchemas(moreResources, dependentSchemas);
            }
            ++n2;
        }
    }

    private boolean shouldAddSchema(Resource resource, ArrayList<Resource> dependentSchemas) {
        for (Resource schemaResource : dependentSchemas) {
            if (!resource.getURI().toFileString().equalsIgnoreCase(schemaResource.getURI().toFileString())) continue;
            return false;
        }
        return true;
    }

    private Resource getResourceStartsWithHttp(Collection<Resource> fileResources, String workspaceUri) {
        File file = null;
        if (workspaceUri.startsWith("http")) {
            for (Resource fileResource2 : fileResources) {
                File modelFile = new File(fileResource2.getURI().toFileString());
                file = modelFile;
                String targetNamespace = this.getXsdTargetNamespace(file);
                if (!workspaceUri.equals(targetNamespace)) continue;
                return fileResource2;
            }
        }
        return null;
    }

    private String getXsdTargetNamespace(File file) {
        if (ModelUtil.isXsdFile((File)file) && file.exists()) {
            try {
                XsdHeader header = XsdHeaderReader.readHeader((File)file);
                if (header != null) {
                    return header.getTargetNamespaceURI();
                }
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        return null;
    }

    private static Resource getResourceStartsWithPathSeparator(Collection<Resource> fileResources, String workspaceUri) {
        Resource fileResource = null;
        if (workspaceUri.charAt(0) == '/') {
            Path pathInWorkspace = new Path(workspaceUri);
            URI pathInWorkspaceURI = URI.createURI((String)pathInWorkspace.toString());
            for (Resource fileResource2 : fileResources) {
                fileResource = fileResource2;
                if (fileResource == null || !fileResource.getURI().equals(pathInWorkspaceURI)) continue;
                return fileResource;
            }
        }
        return null;
    }

    private static Resource getResourceByLocation(Collection<Resource> fileResources, String workspaceUri) {
        String resourceLocation;
        Resource fileResource = null;
        for (Resource fileResource2 : fileResources) {
            fileResource = fileResource2;
            resourceLocation = fileResource.getURI().toString();
            if (!workspaceUri.endsWith(resourceLocation)) continue;
            return fileResource;
        }
        for (Resource fileResource2 : fileResources) {
            fileResource = fileResource2;
            String fileNameSegment = fileResource.getURI().lastSegment();
            if (fileNameSegment == null || !fileNameSegment.equalsIgnoreCase(workspaceUri)) continue;
            return fileResource;
        }
        for (Resource fileResource2 : fileResources) {
            fileResource = fileResource2;
            Path resrcLocation = new Path(fileResource.getURI().toFileString());
            resourceLocation = resrcLocation.toOSString();
            if (resourceLocation.endsWith(workspaceUri)) {
                return fileResource;
            }
            resourceLocation = resrcLocation.toString();
            resourceLocation = resourceLocation.replaceAll("/", "\\\\");
            if (!(resourceLocation = resourceLocation.replaceAll(" ", "%20")).endsWith(workspaceUri)) continue;
            return fileResource;
        }
        return null;
    }
}

