/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.ui.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.teiid.designer.core.builder.AbstractTeiidProjectBuilder;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.ui.Messages;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class VdbBuilder
extends AbstractTeiidProjectBuilder {
    public static final String WRONG_PATH = "wrongPath";
    public static final String OUT_OF_SYNC = "outOfSync";
    public static final String NAME_CHANGED = "nameChanged";
    public static final String MISSING_UUID = "missingUuid";
    public static final String MISSING_MODEL = "missingModel";
    public static final String TOO_MANY_SOURCES = "tooManySources";
    public static final String NO_VALIDATION_VERSION = "noValidationVersion";
    public static final String DIFFERENT_VALIDATION_VERSION = "differentValidationVersion";
    public static final String VALIDATION_VERSION_NEWER_THAN_DESIGNER = "validationVersionNewerThanDesigner";
    public static final String MISSING_TRANSLATOR_TYPE = "missingTranslatorType";
    public static final String MISSING_JNDI_NAME = "missingJndiName";
    public static final String MODEL_WITH_ERRORS = "modelWithErrors";
    public static final String DUPLICATE_MODEL_NAMES = "duplicateModelNames";
    public static final String SINGLE_AUTHENTICATION_TYPE_IGNORED = "singleAuthenticationTypeIgnored";

    protected IProject[] buildInternal(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return null;
        }
        VdbVisitor visitor = new VdbVisitor();
        this.getProject().accept((IResourceVisitor)visitor);
        Collection<IFile> vdbFilesToBuild = visitor.getVdbFiles();
        monitor.beginTask(Messages.vdbBuildTaskName, vdbFilesToBuild.size() + vdbFilesToBuild.size());
        if (vdbFilesToBuild.isEmpty()) {
            return null;
        }
        MultiStatus status = new MultiStatus("org.teiid.designer.vdb.ui", 4, Messages.vdbFilesBuildProblemMsg, null);
        for (IFile vdbFile : vdbFilesToBuild) {
            monitor.subTask(NLS.bind((String)Messages.vdbBuildSubTaskName, (Object)vdbFile.getName()));
            try {
                try {
                    if (vdbFile.exists()) {
                        vdbFile.deleteMarkers("org.teiid.designer.vdb.ui.vdbMarker", true, 2);
                        this.refreshVdbFileMarkers(vdbFile);
                    }
                }
                catch (Exception e) {
                    Status vdbStatus = new Status(4, "org.teiid.designer.vdb.ui", NLS.bind((String)Messages.vdblFileBuildErrorMsg, (Object)vdbFile.getName()), (Throwable)e);
                    status.add((IStatus)vdbStatus);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(1);
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
                throw throwable;
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        if (!status.isOK()) {
            VdbUiConstants.Util.log((IStatus)status);
        }
        return null;
    }

    void refreshVdbFileMarkers(IFile vdbFile) throws Exception {
        MultiStatus status = VdbUtil.validateVdbModelsInWorkspace((IFile)vdbFile);
        if (status.getSeverity() > 1) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus iStatus = iStatusArray[n2];
                switch (iStatus.getSeverity()) {
                    case 2: {
                        if (iStatus.getMessage().indexOf("exists in your project") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.WRONG_PATH);
                        }
                        if (iStatus.getMessage().indexOf("is not synchronized") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.OUT_OF_SYNC);
                        }
                        if (iStatus.getMessage().indexOf("has different name than model") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.NAME_CHANGED);
                        }
                        if (iStatus.getMessage().indexOf("is missing its ID") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.MISSING_UUID);
                        }
                        if (iStatus.getMessage().indexOf("does not exist") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.MISSING_MODEL);
                        }
                        if (iStatus.getMessage().indexOf("multiple sources defined") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.TOO_MANY_SOURCES);
                        }
                        if (iStatus.getMessage().indexOf("Teiid validation version of the VDB could not be found") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.NO_VALIDATION_VERSION);
                        }
                        if (iStatus.getMessage().indexOf("different than the current default") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.DIFFERENT_VALIDATION_VERSION);
                        }
                        if (iStatus.getMessage().indexOf("no JNDI name defined") > 0) {
                            this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.MISSING_JNDI_NAME);
                        }
                        if (iStatus.getMessage().indexOf("single authentication type") <= 0) break;
                        this.createMarker(vdbFile, 1, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.SINGLE_AUTHENTICATION_TYPE_IGNORED);
                        break;
                    }
                    case 4: {
                        if (iStatus.getMessage().indexOf("VDB was created in a newer version of Designer") > 0) {
                            this.createMarker(vdbFile, 2, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.VALIDATION_VERSION_NEWER_THAN_DESIGNER);
                            break;
                        }
                        if (iStatus.getMessage().indexOf("no translator type defined") > 0) {
                            this.createMarker(vdbFile, 2, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.MISSING_TRANSLATOR_TYPE);
                            break;
                        }
                        if (iStatus.getMessage().indexOf("and will not be ACTIVE") > 0) {
                            this.createMarker(vdbFile, 2, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.MODEL_WITH_ERRORS);
                            break;
                        }
                        if (iStatus.getMessage().indexOf("VDB cannot contain models") > 0) {
                            this.createMarker(vdbFile, 2, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.DUPLICATE_MODEL_NAMES);
                            break;
                        }
                        this.createMarker(vdbFile, 2, iStatus.getMessage(), "org.teiid.designer.vdb.ui.vdbMarker", MarkerType.DEFAULT);
                    }
                }
                ++n2;
            }
        }
    }

    private void createMarker(IFile file, int severity, String message, String markerId, MarkerType markerType) {
        assert (file != null) : "file is null";
        assert (message != null && !message.isEmpty()) : "message is empty";
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("severity", severity);
        attributes.put("message", message);
        if (markerType == MarkerType.WRONG_PATH) {
            attributes.put(WRONG_PATH, true);
        } else if (markerType == MarkerType.OUT_OF_SYNC) {
            attributes.put(OUT_OF_SYNC, true);
        } else if (markerType == MarkerType.NAME_CHANGED) {
            attributes.put(NAME_CHANGED, true);
        } else if (markerType == MarkerType.MISSING_UUID) {
            attributes.put(MISSING_UUID, true);
        } else if (markerType == MarkerType.MISSING_MODEL) {
            attributes.put(MISSING_MODEL, true);
        } else if (markerType == MarkerType.NO_VALIDATION_VERSION) {
            attributes.put(NO_VALIDATION_VERSION, true);
        } else if (markerType == MarkerType.DIFFERENT_VALIDATION_VERSION) {
            attributes.put(DIFFERENT_VALIDATION_VERSION, true);
        } else if (markerType == MarkerType.VALIDATION_VERSION_NEWER_THAN_DESIGNER) {
            attributes.put(VALIDATION_VERSION_NEWER_THAN_DESIGNER, true);
        } else if (markerType == MarkerType.DUPLICATE_MODEL_NAMES) {
            attributes.put(DUPLICATE_MODEL_NAMES, true);
        }
        attributes.put("location", file.getName());
        try {
            MarkerUtilities.createMarker((IResource)file, attributes, (String)markerId);
        }
        catch (CoreException e) {
            VdbUiConstants.Util.log((Throwable)e);
        }
    }

    private static enum MarkerType {
        DEFAULT,
        WRONG_PATH,
        OUT_OF_SYNC,
        NAME_CHANGED,
        MISSING_UUID,
        MISSING_MODEL,
        TOO_MANY_SOURCES,
        NO_VALIDATION_VERSION,
        DIFFERENT_VALIDATION_VERSION,
        VALIDATION_VERSION_NEWER_THAN_DESIGNER,
        MISSING_TRANSLATOR_TYPE,
        MISSING_JNDI_NAME,
        MODEL_WITH_ERRORS,
        DUPLICATE_MODEL_NAMES,
        SINGLE_AUTHENTICATION_TYPE_IGNORED;

    }

    class VdbVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private Collection<IFile> vdbFiles = new ArrayList<IFile>();

        VdbVisitor() {
        }

        public Collection<IFile> getVdbFiles() {
            return this.vdbFiles;
        }

        private boolean isVdbFile(IResource resource) {
            boolean mightBeXmiVdb;
            boolean bl = mightBeXmiVdb = resource.getType() == 1 && "vdb".equals(resource.getFileExtension()) && resource.exists();
            if (mightBeXmiVdb) {
                return !VdbUtil.isDdlVdb((IFile)((IFile)resource));
            }
            return false;
        }

        public boolean visit(IResource resource) {
            if (this.isVdbFile(resource)) {
                this.vdbFiles.add((IFile)resource);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (this.isVdbFile(resource)) {
                this.vdbFiles.add((IFile)resource);
            }
            return true;
        }
    }
}

