/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic.ui.editor.panels;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.translators.SimpleProperty;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.dynamic.ui.editor.dialogs.AddGeneralPropertyDialog;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class UserDefinedPropertiesPanel {
    static final String PREFIX = I18nUtil.getPropertyPrefix(UserDefinedPropertiesPanel.class);
    Vdb vdb;
    TableViewerBuilder propertiesViewer;
    Button addPropertyButton;
    Button removePropertyButton;

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    static String prefixedI18n(String id) {
        return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + id, new Object[0]);
    }

    public UserDefinedPropertiesPanel(Composite parent, Vdb vdb) {
        this.vdb = vdb;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group pnlUserProperties = WidgetFactory.createGroup((Composite)parent, null, (int)4, (int)1, (int)1);
        pnlUserProperties.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesViewer = new TableViewerBuilder((Composite)pnlUserProperties, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer.getTableViewer());
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Properties props = UserDefinedPropertiesPanel.this.vdb.getProperties();
                if (props.isEmpty()) {
                    return new Object[0];
                }
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                for (Object key : props.keySet()) {
                    String keyStr = (String)key;
                    String value = props.getProperty(keyStr);
                    properties.add(new SimpleProperty(keyStr, value));
                }
                return properties.toArray(new SimpleProperty[0]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                SimpleProperty prop1 = (SimpleProperty)e1;
                SimpleProperty prop2 = (SimpleProperty)e2;
                return super.compare(viewer, (Object)prop1.getName(), (Object)prop2.getName());
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.propertiesViewer.getTableComposite());
        TableViewerColumn column = this.propertiesViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(String.valueOf(UserDefinedPropertiesPanel.prefixedI18n("name")) + "                                                ");
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(0));
        column = this.propertiesViewer.createColumn(16384, 50, 40, true);
        column.getColumn().setText(UserDefinedPropertiesPanel.prefixedI18n("value"));
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(1));
        column.setEditingSupport((EditingSupport)new PropertyNameEditingSupport((ColumnViewer)this.propertiesViewer.getTableViewer(), 1));
        this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UserDefinedPropertiesPanel.this.handlePropertySelected();
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)pnlUserProperties, (int)0, (int)2, (int)1, (int)2);
        this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addPropertyButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/add.png"));
        this.addPropertyButton.setToolTipText(UserDefinedPropertiesPanel.prefixedI18n("addNewPropertyButton.tooltip"));
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedPropertiesPanel.this.handleAddProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removePropertyButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/remove.png"));
        this.removePropertyButton.setToolTipText(UserDefinedPropertiesPanel.prefixedI18n("removePropertyButton.tooltip"));
        this.removePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UserDefinedPropertiesPanel.this.handleRemoveProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton.setEnabled(false);
        this.propertiesViewer.setInput((Object)this);
    }

    void handlePropertySelected() {
        boolean hasSelection = !this.propertiesViewer.getSelection().isEmpty();
        this.removePropertyButton.setEnabled(hasSelection);
    }

    private SimpleProperty getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (SimpleProperty)selection.getFirstElement();
    }

    void handleAddProperty() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        HashSet<String> existingPropNames = new HashSet<String>();
        for (Object key : this.vdb.getProperties().keySet()) {
            existingPropNames.add((String)key);
        }
        AddGeneralPropertyDialog dialog = new AddGeneralPropertyDialog(this.propertiesViewer.getControl().getShell(), existingPropNames);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String value = dialog.getValue();
            this.vdb.setProperty(name, value);
            this.propertiesViewer.refresh();
            SimpleProperty prop = null;
            TableItem[] tableItemArray = this.propertiesViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() instanceof SimpleProperty && ((SimpleProperty)item.getData()).getName().equals(name)) {
                    prop = (SimpleProperty)item.getData();
                    break;
                }
                ++n2;
            }
            if (prop != null) {
                this.propertiesViewer.setSelection((ISelection)new StructuredSelection(prop), true);
            }
        }
    }

    void handleRemoveProperty() {
        SimpleProperty selectedProperty = this.getSelectedProperty();
        assert (selectedProperty != null);
        this.vdb.removeProperty(selectedProperty.getName());
        this.propertiesViewer.refresh();
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PropertyLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return super.getText(element);
        }
    }

    class PropertyNameEditingSupport
    extends EditingSupport {
        int columnID;
        private TextCellEditor editor;

        public PropertyNameEditingSupport(ColumnViewer viewer, int columnID) {
            super(viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    String oldKey = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newKey = (String)value;
                    if (newKey != null && newKey.length() > 0 && !newKey.equalsIgnoreCase(oldKey)) {
                        UserDefinedPropertiesPanel.this.vdb.removeProperty(oldKey);
                        UserDefinedPropertiesPanel.this.vdb.setProperty(newKey, oldValue);
                        UserDefinedPropertiesPanel.this.propertiesViewer.refresh();
                    }
                } else if (this.columnID == 1) {
                    String key = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newValue = (String)value;
                    if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                        UserDefinedPropertiesPanel.this.vdb.setProperty(key, newValue);
                        UserDefinedPropertiesPanel.this.propertiesViewer.refresh();
                    }
                }
            }
        }
    }
}

