/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic.ui.editor;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.dynamic.DynamicModel;
import org.teiid.designer.vdb.dynamic.DynamicVdb;
import org.teiid.designer.vdb.dynamic.ui.editor.panels.DescriptionPanel;
import org.teiid.designer.vdb.dynamic.ui.editor.panels.ModelDetailsPanel;
import org.teiid.designer.vdb.dynamic.ui.editor.panels.PropertiesPanel;
import org.teiid.designer.vdb.dynamic.ui.editor.panels.TranslatorOverridesPanel;
import org.teiid.designer.vdb.dynamic.ui.editor.panels.UserDefinedPropertiesPanel;
import org.teiid.designer.vdb.ui.Messages;
import org.teiid.designer.vdb.ui.VdbUiConstants;
import org.teiid.designer.vdb.ui.VdbUiPlugin;

public class DynamicVdbEditor
extends EditorPart
implements IResourceChangeListener {
    static final String INVALID_INTEGER_INPUT_TITLE = DynamicVdbEditor.i18n("invalidVdbVersionValueTitle");
    static final String INVALID_INTEGER_INPUT_MESSAGE = DynamicVdbEditor.i18n("invalidVdbVersionValueMessage");
    static final int MODELS_PANEL_WIDTH_HINT = 300;
    static final int MODELS_PANEL_IMAGE_COL_WIDTH = 50;
    static final int MODELS_PANEL_MODELNAME_COL_WIDTH_MIN = 200;
    private DynamicVdb vdb;
    private IFile dynamicVdbFile;
    Exception vdbLoadingException = null;
    private Label validationDateTimeLabel;
    private Label validationVersionLabel;
    private PropertyChangeListener vdbListener;
    TranslatorOverridesPanel pnlTranslatorOverrides;
    private PropertiesPanel propertiesPanel;
    private UserDefinedPropertiesPanel userDefinedPropertiesPanel;
    DescriptionPanel descriptionPanel;
    ModelDetailsPanel modelDetailsPanel;
    ListViewer modelsViewer;
    List<String> models = new ArrayList<String>();
    Button addModelButton;
    Button removeModelButton;
    boolean disposed = false;

    static String i18n(String id) {
        return VdbUiConstants.Util.getString(id, new Object[0]);
    }

    public DynamicVdb getVdb() {
        return this.vdb;
    }

    public void resourceChanged(IResourceChangeEvent arg0) {
    }

    public void doSave(IProgressMonitor arg0) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        IFile theFile = ((IFileEditorInput)input).getFile();
        theFile.getFullPath().makeAbsolute();
        this.dynamicVdbFile = theFile;
        this.dynamicVdbFile.getRawLocation().makeAbsolute().toFile();
        try {
            ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem((IResource)theFile, false);
            IFile wsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(theFile.getFullPath());
            if (!VdbUtil.isDynamicVdb((IFile)this.dynamicVdbFile)) {
                throw new PartInitException("File " + this.dynamicVdbFile.getName() + " is not a dynamic VDB");
            }
            this.vdb = new DynamicVdb(wsFile);
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
            this.vdbLoadingException = ex;
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(this.dynamicVdbFile.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData());
        if (this.vdb == null) {
            this.createErrorPanel(parent);
            return;
        }
        Composite headerPanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)4, (int)1, (int)4);
        Label projectLabel = new Label(headerPanel, 0);
        projectLabel.setText(Messages.vdbEditor_location);
        Label project = new Label(headerPanel, 0);
        project.setText(this.dynamicVdbFile.getParent().getFullPath().toString());
        project.setForeground(GlobalUiColorManager.EMPHASIS_COLOR);
        Label vdbVersionLabel = WidgetFactory.createLabel((Composite)headerPanel, (String)"Version");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)vdbVersionLabel);
        final Text vdbVersionText = WidgetFactory.createTextField((Composite)headerPanel);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)vdbVersionText);
        ((GridData)vdbVersionText.getLayoutData()).widthHint = 30;
        vdbVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    int versionValue = Integer.parseInt(vdbVersionText.getText());
                    if (versionValue > -1) {
                        DynamicVdbEditor.this.getVdb().setVersion(versionValue);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)INVALID_INTEGER_INPUT_TITLE, (String)INVALID_INTEGER_INPUT_MESSAGE);
                    vdbVersionText.setText(Integer.toString(DynamicVdbEditor.this.getVdb().getVersion()));
                }
            }
        });
        vdbVersionText.setText(Integer.toString(this.getVdb().getVersion()));
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)parent);
        tabFolder.setTabPosition(1024);
        CTabItem leftTab = new CTabItem(tabFolder, 0);
        leftTab.setText(Messages.vdbEditor_content_tab_label);
        leftTab.setToolTipText(Messages.vdbEditor_content_tab_tooltip);
        Composite leftPanel = this.createEditorContentTab((Composite)tabFolder);
        leftTab.setControl((Control)leftPanel);
        CTabItem rightTab = new CTabItem(tabFolder, 0);
        rightTab.setText(Messages.vdbEditor_advanced_tab_label);
        rightTab.setToolTipText(Messages.vdbEditor_advanced_tab_tooltip);
        Composite rightPanel = this.createEditorAdancedTab((Composite)tabFolder);
        rightTab.setControl((Control)rightPanel);
        tabFolder.setSelection(0);
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private Composite createEditorContentTab(Composite parent) {
        Composite pnlTop = new Composite(parent, 2048);
        pnlTop.setLayout((Layout)new GridLayout());
        pnlTop.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)pnlTop);
        CTabItem modelsTab = new CTabItem(tabFolder, 0);
        modelsTab.setText(DynamicVdbEditor.i18n("modelsTab"));
        modelsTab.setToolTipText(DynamicVdbEditor.i18n("modelsTabToolTip"));
        Composite pnlModels = new Composite((Composite)tabFolder, 0);
        pnlModels.setLayout((Layout)new GridLayout(1, false));
        pnlModels.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm splitter = new SashForm(pnlModels, 256);
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite pnlModelsList = new Composite((Composite)splitter, 0);
        pnlModelsList.setLayout((Layout)new GridLayout());
        pnlModelsList.setLayoutData((Object)new GridData(4, 4, false, true));
        ((GridData)pnlModelsList.getLayoutData()).widthHint = 300;
        this.createModelsSection(pnlModelsList);
        this.modelDetailsPanel = new ModelDetailsPanel((Composite)splitter, (Vdb)this.getVdb());
        splitter.setWeights(new int[]{35, 65});
        modelsTab.setControl((Control)pnlModels);
        CTabItem descriptionTab = new CTabItem(tabFolder, 0);
        descriptionTab.setText(DynamicVdbEditor.i18n("descriptionTab"));
        descriptionTab.setToolTipText(DynamicVdbEditor.i18n("descriptionTabToolTip"));
        Composite pnlDescription = new Composite((Composite)tabFolder, 0);
        pnlDescription.setLayout((Layout)new GridLayout());
        pnlDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        descriptionTab.setControl((Control)pnlDescription);
        this.descriptionPanel = new DescriptionPanel(pnlDescription, (Vdb)this.getVdb());
        tabFolder.setSelection(0);
        return pnlTop;
    }

    private void createModelsSection(Composite parent) {
        Group languageGroup = WidgetFactory.createGroup((Composite)parent, (String)"Models", (int)4, (int)1, (int)1);
        GridData gd_2 = new GridData(1808);
        gd_2.widthHint = 220;
        languageGroup.setLayoutData((Object)gd_2);
        this.modelsViewer = new ListViewer((Composite)languageGroup, 2816);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.modelsViewer.getControl().setLayoutData((Object)data);
        this.modelsViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return DynamicVdbEditor.this.getVdb().getDynamicModels().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.modelsViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getText(Object element) {
                if (element instanceof DynamicModel) {
                    return ((DynamicModel)element).getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof DynamicModel) {
                    if (((DynamicModel)element).getModelType() == DynamicModel.Type.PHYSICAL) {
                        return ModelIdentifier.getImage((int)0);
                    }
                    return ModelIdentifier.getImage((int)4);
                }
                return null;
            }
        });
        this.modelsViewer.setInput((Object)this.vdb.getDynamicModels());
        this.modelsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DynamicVdbEditor.this.handleModelSelected();
            }
        });
        this.modelsViewer.refresh();
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)languageGroup, (int)0, (int)2, (int)1, (int)2);
        this.addModelButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addModelButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/add.png"));
        this.addModelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DynamicVdbEditor.this.handleAddModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeModelButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removeModelButton.setImage(VdbUiPlugin.singleton.getImage("icons/full/ctool16/remove.png"));
        this.removeModelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DynamicVdbEditor.this.handleRemoveModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeModelButton.setEnabled(false);
    }

    void handleModelSelected() {
        boolean hasSelection = !this.modelsViewer.getSelection().isEmpty();
        this.removeModelButton.setEnabled(hasSelection);
    }

    private DynamicModel getSelectedModel() {
        IStructuredSelection selection = (IStructuredSelection)this.modelsViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (DynamicModel)selection.getFirstElement();
    }

    void handleAddModel() {
        assert (!this.modelsViewer.getSelection().isEmpty());
    }

    void handleRemoveModel() {
        DynamicModel selectedModel = this.getSelectedModel();
        assert (selectedModel != null);
        this.vdb.removeDynamicModel(selectedModel.getName());
        this.modelsViewer.refresh();
    }

    private Composite createEditorAdancedTab(Composite parent) {
        Composite pnlBottom = new Composite(parent, 2048);
        pnlBottom.setLayout((Layout)new GridLayout());
        pnlBottom.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabFolder tabFolder = WidgetFactory.createTabFolder((Composite)pnlBottom);
        CTabItem propertiesTab = new CTabItem(tabFolder, 0);
        propertiesTab.setText(DynamicVdbEditor.i18n("propertiesTab"));
        propertiesTab.setToolTipText(DynamicVdbEditor.i18n("propertiesTabToolTip"));
        Composite pnlProperties = new Composite((Composite)tabFolder, 0);
        pnlProperties.setLayout((Layout)new GridLayout());
        pnlProperties.setLayoutData((Object)new GridData(4, 4, true, true));
        propertiesTab.setControl((Control)pnlProperties);
        this.propertiesPanel = new PropertiesPanel(pnlProperties, (Vdb)this.getVdb());
        CTabItem tab = new CTabItem(tabFolder, 0);
        tab.setText(DynamicVdbEditor.i18n("userDefinedPropertiesTab"));
        tab.setToolTipText(DynamicVdbEditor.i18n("userDefinedPropertiesTabToolTip"));
        pnlProperties = new Composite((Composite)tabFolder, 0);
        pnlProperties.setLayout((Layout)new GridLayout());
        pnlProperties.setLayoutData((Object)new GridData(4, 4, true, true));
        tab.setControl((Control)pnlProperties);
        this.userDefinedPropertiesPanel = new UserDefinedPropertiesPanel(pnlProperties, (Vdb)this.getVdb());
        tabFolder.setSelection(0);
        return pnlBottom;
    }

    private void createErrorPanel(Composite parent) {
        Color bgColour = parent.getDisplay().getSystemColor(25);
        parent.setBackground(bgColour);
        final Composite errorPanel = WidgetFactory.createPanel((Composite)parent, (int)0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)errorPanel);
        Composite imgMsgPanel = WidgetFactory.createPanel((Composite)errorPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(imgMsgPanel);
        Label imageLabel = WidgetFactory.createLabel((Composite)imgMsgPanel, (int)0);
        imageLabel.setBackground(bgColour);
        Image image = parent.getDisplay().getSystemImage(1);
        if (image != null) {
            image.setBackground(bgColour);
            imageLabel.setImage(image);
            GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)imageLabel);
        }
        Label errLabel = WidgetFactory.createLabel((Composite)imgMsgPanel, (String)Messages.vdbEditor_loadingErrMessage);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)errLabel);
        final Button detailsButton = WidgetFactory.createButton((Composite)errorPanel, (int)8);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)detailsButton);
        detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        detailsButton.setData((Object)Boolean.FALSE);
        final Composite detailsComposite = WidgetFactory.createPanel((Composite)errorPanel);
        GridDataFactory.defaultsFor((Control)detailsComposite).applyTo((Control)detailsComposite);
        GridLayoutFactory.fillDefaults().margins(25, 25).applyTo(detailsComposite);
        detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Boolean.TRUE.equals(detailsButton.getData())) {
                    Control[] controlArray = detailsComposite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                    detailsButton.setData((Object)Boolean.FALSE);
                } else {
                    String trace = CoreStringUtil.getStackTrace((Throwable)DynamicVdbEditor.this.vdbLoadingException);
                    Text exceptionText = WidgetFactory.createTextBox((Composite)detailsComposite, (int)8, (int)4, (int)1, (String)trace);
                    GridDataFactory.fillDefaults().grab(true, true).hint(200, 400).applyTo((Control)exceptionText);
                    detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                    detailsButton.setData((Object)Boolean.TRUE);
                }
                errorPanel.layout(true);
                errorPanel.getParent().layout(true);
            }
        });
        detailsButton.setVisible(this.vdbLoadingException != null);
    }

    public void setFocus() {
    }

    void vdbNotification(String property) {
        if ("closed".equals(property)) {
            return;
        }
        this.firePropertyChange(257);
    }
}

