/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.debug.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.HandlerUtil;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;

public class InjectHeaderHander
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object o = Selections.getFirstSelection((ISelection)sel);
        if (o instanceof CamelHeadersVariable) {
            CamelHeadersVariable var = (CamelHeadersVariable)o;
            NewMessageHeaderDialog dlg = new NewMessageHeaderDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (dlg.open() == 0) {
                String key = dlg.getHeaderKey();
                String val = dlg.getHeaderValue();
                var.addHeader(key, val);
            }
        }
        return null;
    }

    class NewMessageHeaderDialog
    extends TitleAreaDialog {
        private String headerKey;
        private String headerValue;
        private Label lbl_headerName;
        private Label lbl_headerValue;
        private Text txt_headerName;
        private Text txt_headerValue;

        public NewMessageHeaderDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Add new header...");
        }

        public void create() {
            super.create();
            this.setTitle("Add a new message header...");
            this.setMessage("Please enter a header name and value for the new message header...", 1);
        }

        protected Control createContents(Composite parent) {
            Control c = super.createContents(parent);
            this.validate();
            return c;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            container.setLayout((Layout)new GridLayout(3, true));
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            this.lbl_headerName = new Label(container, 0);
            this.lbl_headerName.setText("Name");
            this.lbl_headerName.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.txt_headerName = new Text(container, 2068);
            this.txt_headerName.setText(Strings.isBlank((String)this.headerKey) ? "" : this.headerKey);
            this.txt_headerName.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.txt_headerName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewMessageHeaderDialog.this.validate();
                }
            });
            this.lbl_headerValue = new Label(container, 0);
            this.lbl_headerValue.setText("Value");
            this.lbl_headerValue.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            this.txt_headerValue = new Text(container, 2068);
            this.txt_headerValue.setText(Strings.isBlank((String)this.headerValue) ? "" : this.headerValue);
            this.txt_headerValue.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.txt_headerValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewMessageHeaderDialog.this.validate();
                }
            });
            container.pack();
            return area;
        }

        protected void okPressed() {
            if (this.validate()) {
                this.saveInputs();
                super.okPressed();
            }
        }

        private void saveInputs() {
            this.headerKey = this.txt_headerName.getText();
            this.headerValue = this.txt_headerValue.getText();
        }

        private boolean validate() {
            if (Strings.isBlank((String)this.txt_headerName.getText().trim())) {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                this.setErrorMessage("You must enter a valid header name.");
                return false;
            }
            if (Strings.isBlank((String)this.txt_headerValue.getText().trim())) {
                if (this.getButton(0) != null) {
                    this.getButton(0).setEnabled(false);
                }
                this.setErrorMessage("You must enter a valid header value.");
                return false;
            }
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
            this.setErrorMessage(null);
            return true;
        }

        public String getHeaderKey() {
            return this.headerKey;
        }

        public void setHeaderKey(String headerKey) {
            this.headerKey = headerKey;
        }

        public String getHeaderValue() {
            return this.headerValue;
        }

        public void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }
    }
}

