/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDComplexTypeDefinitionImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.xml.BuildStatus;
import org.teiid.designer.metamodels.xml.ValueType;
import org.teiid.designer.metamodels.xml.XmlAll;
import org.teiid.designer.metamodels.xml.XmlAttribute;
import org.teiid.designer.metamodels.xml.XmlBaseElement;
import org.teiid.designer.metamodels.xml.XmlBuildable;
import org.teiid.designer.metamodels.xml.XmlChoice;
import org.teiid.designer.metamodels.xml.XmlContainerNode;
import org.teiid.designer.metamodels.xml.XmlDocumentBuilder;
import org.teiid.designer.metamodels.xml.XmlDocumentEntity;
import org.teiid.designer.metamodels.xml.XmlDocumentFactory;
import org.teiid.designer.metamodels.xml.XmlDocumentNode;
import org.teiid.designer.metamodels.xml.XmlDocumentPlugin;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlEntityHolder;
import org.teiid.designer.metamodels.xml.XmlFragment;
import org.teiid.designer.metamodels.xml.XmlFragmentUse;
import org.teiid.designer.metamodels.xml.XmlNamespace;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.metamodels.xml.XmlSequence;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;

public class XmlDocumentBuilderImpl
implements XmlDocumentBuilder {
    private static final String TASK_NAME = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.buildingXmlDocForRoot", new Object[0]);
    private static final String CALCULATING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Calculating_effort_to_build__1", new Object[0]);
    private static final String CALCULATING_MSG2 = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Calculating_effort_to_update__2", new Object[0]);
    private static final String BUILDING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Building_Document_node__3", new Object[0]);
    private static final String UPDATING_MSG = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Updating_Document_node__4", new Object[0]);
    private final Collection schemaUris = new ArrayList();
    private final Collection referencedSchemas = new ArrayList();
    private final HashMap updateDeleteMap = new HashMap();
    private final HashMap updateCurrentChildMap = new HashMap();
    private final HashMap fragmentMap = new HashMap();
    private final HashMap uriToNamespaceMap = new HashMap();
    private final StringNameValidator validator = new StringNameValidator();
    private final HashSet unhandledModelImports = new HashSet();
    private final Collection recursiveElementUUIDs = new HashSet();
    private int nodeCount;
    private int newCount;
    private int moveCount;
    private int factor;
    private int tempFactor;
    private Stack recursionStack;
    private int numberOfLevelsToBuild = -1;
    private XmlElement root;
    private IProgressMonitor monitor;
    private final XmlDocumentFactory docFactory = XmlDocumentFactory.eINSTANCE;
    private final ModelEditor me = ModelerCore.getModelEditor();
    private boolean useFragments;

    public XmlDocumentBuilderImpl() {
        this(-1);
    }

    public XmlDocumentBuilderImpl(int levels) {
        this.setNumberOfLevelsToBuild(levels);
    }

    private void addChildren(XmlDocumentEntity docParent, XSDComponent xsdComponent, String taskName) {
        XSDTypeDefinition typeEntity;
        XmlContainerNode temp;
        String newName;
        String name;
        boolean proceed;
        XSDFeature feature;
        XmlElement elem;
        XSDComponent parentXsdComp;
        if (docParent instanceof XmlElement && (parentXsdComp = (elem = (XmlElement)docParent).getXsdComponent()) instanceof XSDFeature && ((feature = (XSDFeature)parentXsdComp).isGlobal() || XSDForm.QUALIFIED_LITERAL.equals((Object)feature.getForm()))) {
            XmlNamespace ns;
            String uri = feature.getTargetNamespace();
            if (uri == null && xsdComponent != null && xsdComponent instanceof XSDComplexTypeDefinitionImpl) {
                uri = ((XSDComplexTypeDefinitionImpl)xsdComponent).getTargetNamespace();
            }
            if (uri != null && (ns = (XmlNamespace)this.uriToNamespaceMap.get(uri)) != null) {
                elem.setNamespace(ns);
            }
        }
        if (this.numberOfLevelsToBuild != -1 && !(proceed = this.checkDepth(docParent))) {
            this.setBuildStatusProperty((XmlBuildable)((Object)docParent), BuildStatus.INCOMPLETE_LITERAL);
            return;
        }
        if (this.monitor.isCanceled()) {
            return;
        }
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        if (this.useFragments) {
            XmlFragment fragment;
            XmlFragment xmlFragment = fragment = ref == null ? (XmlFragment)this.fragmentMap.get(xsdComponent) : (XmlFragment)this.fragmentMap.get(ref);
            if (fragment != null) {
                if (docParent instanceof XmlEntityHolder) {
                    XmlFragmentUse use = this.docFactory.createXmlFragmentUse();
                    use.setFragment(fragment);
                    use.setName(fragment.getName());
                    use.setXsdComponent(ref == null ? xsdComponent : ref);
                    use.setNamespace(fragment.getRoot() == null ? null : fragment.getRoot().getNamespace());
                    use.setParent((XmlEntityHolder)((Object)docParent));
                    return;
                }
                if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add docFragment to " + docParent.getClass().getName());
                }
            }
        }
        boolean isRecursive = false;
        if (ref != null) {
            isRecursive = this.isRecursive(ref);
            this.recursionStack.push(ref);
        } else {
            isRecursive = this.isRecursive(xsdComponent);
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = docParent;
        if (xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract()) {
            XmlElement element = this.docFactory.createXmlElement();
            element.setXsdComponent(xsdComponent);
            if (docParent instanceof XmlContainerNode) {
                this.addValueToList(docParent, element, ((XmlContainerNode)docParent).getEntities());
            } else if (ModelerCore.DEBUG_XML) {
                System.out.println("Can't add element to " + docParent.getClass().getName());
            }
            XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
            if (xsdElement.getLexicalValue() != null) {
                element.setValue(xsdElement.getLexicalValue());
                XSDConstraint constraint = xsdElement.getConstraint();
                if (XSDConstraint.DEFAULT_LITERAL.equals((Object)constraint)) {
                    element.setValueType(ValueType.DEFAULT_LITERAL);
                } else if (XSDConstraint.FIXED_LITERAL.equals((Object)constraint)) {
                    element.setValueType(ValueType.FIXED_LITERAL);
                }
            }
            documentChild = element;
            if (ref != null) {
                xsdComponent = ref;
            }
            name = ((XSDElementDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDElementDeclaration)ref).getName();
            }
            if ((newName = this.validator.createValidName(name)) != null) {
                name = newName;
            }
            element.setName(name);
            ++this.nodeCount;
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDModelGroupDefinition || xsdComponent instanceof XSDAttributeGroupDefinition) {
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDAttributeDeclaration) {
            boolean prohibited = this.isProhibited((XSDAttributeDeclaration)xsdComponent);
            if (prohibited) {
                this.removeChildrenOfSameName(docParent, XSDAttributeDeclaration.class, ((XSDAttributeDeclaration)xsdComponent).getName());
            } else {
                XmlAttribute attribute = this.docFactory.createXmlAttribute();
                attribute.setXsdComponent(xsdComponent);
                if (docParent instanceof XmlElement) {
                    this.addValueToList(docParent, attribute, ((XmlElement)docParent).getAttributes());
                } else if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add attribute to " + docParent.getClass().getName());
                }
                documentChild = attribute;
                if (ref != null) {
                    xsdComponent = ref;
                }
                name = ((XSDAttributeDeclaration)xsdComponent).getName();
                if (ref != null) {
                    name = ((XSDAttributeDeclaration)ref).getName();
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                attribute.setName(name);
                ++this.nodeCount;
                this.updateMonitor();
            }
        } else if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            for (Object sibling : docParent.eContents()) {
                if (!(sibling instanceof XmlAll)) continue;
                temp = (XmlAll)sibling;
                break;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlAll();
                this.addValueToList(docParent, temp, ((XmlEntityHolder)((Object)docParent)).getEntities());
                if (ref != null) {
                    xsdComponent = ref;
                }
                ++this.nodeCount;
                this.updateMonitor();
            }
            temp.setXsdComponent(xsdComponent);
            documentChild = temp;
        } else if (this.isChoiceCompositor(xsdComponent)) {
            XmlChoice choice = this.docFactory.createXmlChoice();
            choice.setXsdComponent(xsdComponent);
            this.addValueToList(docParent, choice, ((XmlEntityHolder)((Object)docParent)).getEntities());
            documentChild = choice;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            if (documentChild instanceof XmlSequence && this.isValidSequenceForReuse((EObject)((XmlSequence)documentChild).getXsdComponent(), (EObject)xsdComponent)) {
                temp = (XmlSequence)documentChild;
            }
            if (temp == null) {
                for (Object sibling : docParent.eContents()) {
                    if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)((XmlSequence)sibling).getXsdComponent(), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling;
                    documentChild = temp;
                    break;
                }
                if (temp == null) {
                    documentChild = this.docFactory.createXmlSequence();
                    this.addValueToList(docParent, documentChild, ((XmlEntityHolder)((Object)docParent)).getEntities());
                    ++this.nodeCount;
                    this.updateMonitor();
                }
                ((XmlSequence)documentChild).setXsdComponent(xsdComponent);
            }
        } else if (ModelerCore.DEBUG_XML) {
            System.out.println("Found  unexpected " + xsdComponent.getClass().getName());
        }
        ObjectID uuid = ModelerCore.getObjectId((EObject)documentChild);
        if (isRecursive) {
            if (documentChild instanceof XmlElement) {
                this.setRecursiveProperty((XmlElement)documentChild, true);
                this.setBuildStatusProperty((XmlElement)documentChild, BuildStatus.INCOMPLETE_LITERAL);
            }
            if (this.recursiveElementUUIDs.contains(uuid)) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(uuid);
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        if (documentChild != docParent) {
            this.updateSchemaUris(documentChild, xsdComponent);
            if (this.nodeCount % 10000 == 0) {
                System.gc();
                Thread.yield();
            }
        }
        if ((typeEntity = XmlDocumentUtil.findXSDType(xsdComponent)) != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent)) {
            this.addChildren(documentChild, (XSDComponent)typeEntity, taskName);
            if (xsdComponent instanceof XSDComplexTypeDefinition && this.isRecursive((XSDComponent)typeEntity)) {
                this.setRecursiveProperty((XmlElement)documentChild, false);
            }
        }
        if (!this.recursiveElementUUIDs.contains(uuid)) {
            for (Object child : xsdComponent.eContents()) {
                if (!(child instanceof XSDComponent)) continue;
                this.addChildren(documentChild, (XSDComponent)child, taskName);
            }
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void addRecursionParentTypes(XmlBaseElement node) {
        XSDComponent schemaComponent;
        XSDComponent ref;
        XmlEntityHolder parent = node.getParent();
        if (parent instanceof XmlContainerNode) {
            XmlEntityHolder nextParent = ((XmlContainerNode)parent).getParent();
            while (nextParent != null) {
                if (nextParent instanceof XmlElement) {
                    this.addRecursionParentTypes((XmlElement)nextParent);
                    break;
                }
                nextParent = ((XmlContainerNode)parent).getParent();
            }
        }
        if ((ref = this.resolveSchemaRef(schemaComponent = node.getXsdComponent())) != null) {
            this.recursionStack.push(ref);
        } else {
            this.recursionStack.push(schemaComponent);
        }
    }

    private void addValueToList(Object owner, Object value, EList feature) {
        try {
            ModelerCore.getModelEditor().addValue(owner, value, feature);
        }
        catch (ModelerCoreException err) {
            ModelerCore.Util.log(4, (Throwable)err, XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Error_adding_object", value));
        }
    }

    @Override
    public int buildDocument(XmlElement rootElement, IProgressMonitor progressMonitor) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)rootElement);
        this.root = rootElement;
        this.monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        this.referencedSchemas.clear();
        this.initializeSchemaUris(rootElement);
        boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Build_XML_Document_5", new Object[0]), (Object)this);
        boolean succeeded = false;
        try {
            XSDComponent schemaComponent;
            this.setBuildStatusProperty(rootElement, BuildStatus.COMPLETE_LITERAL);
            if (rootElement.isRecursive()) {
                this.setRecursiveProperty(rootElement, false);
            }
            if ((schemaComponent = this.root.getXsdComponent()) == null) {
                throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Schema_reference_not_set_on_root_element_1", new Object[0]));
            }
            XSDTypeDefinition typeDefn = XmlDocumentUtil.findXSDType(schemaComponent);
            if (typeDefn != null) {
                if (schemaComponent instanceof XSDNamedComponent) {
                    String newName;
                    XSDComponent ref;
                    String name = ((XSDNamedComponent)schemaComponent).getName();
                    if ((name == null || name.length() == 0) && (ref = this.resolveSchemaRef(schemaComponent)) != null && ref instanceof XSDNamedComponent) {
                        name = ((XSDNamedComponent)ref).getName();
                    }
                    if ((newName = this.validator.createValidName(name)) != null) {
                        name = newName;
                    }
                    this.root.setName(name);
                }
            } else {
                throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.No_type_element_found_for_root_document_element_2", new Object[0]));
            }
            this.monitor.beginTask(TASK_NAME, 5000);
            this.monitor.subTask(String.valueOf(CALCULATING_MSG) + this.root.getName());
            this.initializeRecursionStack(this.root);
            this.monitor.subTask(String.valueOf(BUILDING_MSG) + this.root.getName());
            this.nodeCount = 0;
            this.addChildren(this.root, (XSDComponent)typeDefn, String.valueOf(BUILDING_MSG) + this.root.getName());
            succeeded = true;
            int n = this.nodeCount;
            return n;
        }
        catch (ModelerCoreException e) {
            throw e;
        }
        catch (Throwable e) {
            ModelerCore.Util.log(4, e, e.getMessage());
        }
        finally {
            this.cleanup();
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
            System.gc();
            Thread.yield();
            this.monitor.worked(10);
        }
        return this.nodeCount;
    }

    @Override
    public Collection buildXmlFragments(XSDSchema schema) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)schema);
        ArrayList<XmlFragment> fragments = new ArrayList<XmlFragment>();
        Iterator iter = schema.getContents().iterator();
        while (iter.hasNext()) {
            if (this.monitor != null && this.monitor.isCanceled()) break;
            Object next = iter.next();
            if (!(next instanceof XSDElementDeclaration)) continue;
            XSDElementDeclaration child = (XSDElementDeclaration)next;
            XmlRoot root = this.docFactory.createXmlRoot();
            XmlDocumentBuilderImpl builder = new XmlDocumentBuilderImpl();
            root.setXsdComponent((XSDComponent)child);
            builder.buildDocument(root, null);
            XmlFragment fragment = this.docFactory.createXmlFragment();
            String name = root.getName();
            String newName = this.validator.createValidName(name);
            if (newName != null) {
                name = newName;
            }
            fragment.setName(name);
            fragment.setRoot(root);
            fragments.add(fragment);
        }
        return fragments;
    }

    private boolean checkDepth(EObject child) {
        boolean isCompositor;
        boolean bl = isCompositor = child instanceof XmlAll || child instanceof XmlChoice || child instanceof XmlSequence;
        if (isCompositor || child == this.root) {
            return true;
        }
        int depth = 1;
        EObject parent = child.eContainer();
        while (parent != null && parent != this.root) {
            parent = parent.eContainer();
            ++depth;
        }
        return depth < this.numberOfLevelsToBuild;
    }

    private void cleanup() {
        this.useFragments = false;
        this.numberOfLevelsToBuild = -1;
        this.numberOfLevelsToBuild = -1;
        this.root = null;
        if (this.recursionStack != null) {
            this.recursionStack.clear();
        }
        this.recursiveElementUUIDs.clear();
        this.updateDeleteMap.clear();
        this.updateCurrentChildMap.clear();
        this.uriToNamespaceMap.clear();
    }

    private XmlDocumentEntity findExistingDocumentChild(ArrayList documentChildren, XSDComponent xsdComponent) {
        if (documentChildren == null || documentChildren.isEmpty()) {
            return null;
        }
        for (XmlDocumentEntity next : documentChildren) {
            if (!xsdComponent.equals(this.findSchemaReference(next))) continue;
            return next;
        }
        if (this.isAllCompositor(xsdComponent) || this.isSequenceCompositor(xsdComponent)) {
            for (XmlDocumentEntity child : documentChildren) {
                XSDComponent schemaRef = this.findSchemaReference(child);
                if (schemaRef == null || !xsdComponent.eClass().equals(schemaRef.eClass())) continue;
                for (XmlDocumentEntity grandchild : child.eContents()) {
                    XSDComponent gcSchemaRef = this.findSchemaReference(grandchild);
                    if (!xsdComponent.eContents().contains((Object)gcSchemaRef)) continue;
                    return child;
                }
            }
        }
        return null;
    }

    private XSDComponent findSchemaReference(EObject child) {
        if (child instanceof XmlDocumentNode) {
            return ((XmlDocumentNode)child).getXsdComponent();
        }
        if (child instanceof XmlContainerNode) {
            return ((XmlContainerNode)child).getXsdComponent();
        }
        return null;
    }

    private int getIndexOfChild(EObject parent, EObject child) {
        if (child.eContainer() == null || !child.eContainer().equals(parent)) {
            return -1;
        }
        if (parent instanceof XSDParticle || parent instanceof XSDAttributeUse) {
            return this.getIndexOfChild(parent.eContainer(), parent);
        }
        EReference sf = child.eContainmentFeature();
        if (sf == null) {
            return -1;
        }
        Object result = parent.eGet((EStructuralFeature)sf);
        if (result == null || !(result instanceof EList)) {
            return -1;
        }
        return ((EList)result).indexOf((Object)child);
    }

    @Override
    public Collection getRecursiveElementObjectIDs() {
        return this.recursiveElementUUIDs;
    }

    public Collection getUnhandledModelImports() {
        return this.unhandledModelImports;
    }

    private void initializeRecursionStack(XmlElement root) {
        this.recursionStack = new Stack();
        this.addRecursionParentTypes(root);
    }

    private void initializeSchemaUris(XmlElement element) {
        XSDComponent xsdComp = element.getXsdComponent();
        if (xsdComp == null) {
            return;
        }
        XmlElement root = null;
        XmlElement node = element;
        while (root == null && node != null) {
            if (node instanceof XmlRoot) {
                root = node;
                continue;
            }
            node = node.eContainer();
        }
        if (root == null) {
            return;
        }
        for (EObject next : root.eContents()) {
            if (!(next instanceof XmlNamespace)) continue;
            this.schemaUris.add(((XmlNamespace)next).getUri());
        }
        this.updateSchemaUris(element, xsdComp);
    }

    private boolean isAllCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 0;
        }
        return false;
    }

    private boolean isChoiceCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 1;
        }
        return false;
    }

    private boolean isProhibited(XSDAttributeDeclaration attribute) {
        CoreArgCheck.isNotNull((Object)attribute);
        XSDAttributeUse attUse = (XSDAttributeUse)attribute.eContainer();
        if (attUse == null) {
            return false;
        }
        XSDAttributeUseCategory cat = attUse.getUse();
        if (cat == null) {
            return false;
        }
        int val = cat.getValue();
        return val == 1;
    }

    private boolean isRecursive(XSDComponent xsdComponent) {
        return this.recursionStack.contains(xsdComponent);
    }

    private boolean isSequenceCompositor(XSDComponent xsdComponent) {
        if (xsdComponent instanceof XSDModelGroup) {
            return ((XSDModelGroup)xsdComponent).getCompositor().getValue() == 2;
        }
        return false;
    }

    private boolean isValidSequenceForReuse(EObject sequence1, EObject sequence2) {
        if (sequence1 == null || sequence2 == null) {
            return false;
        }
        if (sequence1 instanceof XSDModelGroup && sequence2 instanceof XSDModelGroup) {
            EObject obj1 = sequence1.eContainer();
            EObject obj2 = sequence2.eContainer();
            boolean sameMult = false;
            if (obj1 instanceof XSDParticle && obj2 instanceof XSDParticle) {
                XSDParticle p1 = (XSDParticle)sequence1.eContainer();
                XSDParticle p2 = (XSDParticle)sequence2.eContainer();
                if (p1 != null && p2 != null) {
                    int max2;
                    int max1 = p1.getMaxOccurs();
                    boolean maxMatch = max1 == (max2 = p2.getMaxOccurs());
                    int min1 = p1.getMinOccurs();
                    int min2 = p2.getMinOccurs();
                    boolean minMatch = min1 == min2;
                    sameMult = minMatch && maxMatch;
                }
                boolean isChoice = false;
                if (sameMult) {
                    EObject parent2;
                    EObject parent1 = p1.eContainer();
                    if (parent1 == (parent2 = p2.eContainer()) && parent1 != null && parent1 instanceof XSDModelGroup) {
                        isChoice = ((XSDModelGroup)parent1).getCompositor().equals((Object)XSDCompositor.CHOICE_LITERAL);
                    }
                    if (isChoice) {
                        return false;
                    }
                }
                return sameMult;
            }
        }
        return false;
    }

    private boolean moveIfNotAtSameIndex(XmlDocumentEntity documentElement, XSDComponent xsdComponent) throws ModelerCoreException {
        boolean moved = false;
        XmlDocumentEntity docParent = (XmlDocumentEntity)documentElement.eContainer();
        XSDComponent schemaParent = (XSDComponent)xsdComponent.eContainer();
        int docIndex = this.getIndexOfChild(docParent, documentElement);
        int schemaIndex = this.getIndexOfChild((EObject)schemaParent, (EObject)xsdComponent);
        if (docIndex == -1) {
            throw new ModelerCoreException(String.valueOf(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_find_document_index_for_{0}_5", new Object[0])) + xsdComponent.toString());
        }
        if (schemaIndex == -1) {
            throw new ModelerCoreException(String.valueOf(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_find_schema_index_for_{0}_6", new Object[0])) + documentElement.toString());
        }
        if (docIndex == 0 && schemaIndex == 0) {
            return moved;
        }
        EList docList = (EList)docParent.eGet((EStructuralFeature)documentElement.eContainmentFeature());
        EList schemaList = null;
        schemaList = schemaParent instanceof XSDParticle || schemaParent instanceof XSDAttributeUse ? (EList)schemaParent.eContainer().eGet((EStructuralFeature)schemaParent.eContainmentFeature()) : (EList)schemaParent.eGet((EStructuralFeature)xsdComponent.eContainmentFeature());
        if (schemaIndex > 0 && docList.size() > 1) {
            EObject tempSchemaElement = (EObject)schemaList.get(schemaIndex - 1);
            Iterator docChildren = docList.iterator();
            boolean found = false;
            while (docChildren.hasNext() && !found) {
                EObject docChild = (EObject)docChildren.next();
                XSDComponent schemaRef = this.findSchemaReference(docChild);
                if (schemaRef == null || schemaRef != tempSchemaElement) continue;
                found = true;
                int temp = this.getIndexOfChild(docParent, docChild) + 1;
                if (temp == docIndex) continue;
                this.me.move((Object)docParent, (EObject)documentElement, temp);
                moved = true;
            }
        } else if (schemaIndex == 0 && docList.size() > 1) {
            int foundIndex = Integer.MAX_VALUE;
            for (EObject docChild : docList) {
                int temp;
                XSDComponent schemaRef = this.findSchemaReference(docChild);
                if (schemaRef == null || schemaRef == xsdComponent || !schemaList.contains((Object)schemaRef) || (temp = this.getIndexOfChild(docParent, docChild)) >= foundIndex) continue;
                foundIndex = temp;
            }
            if (foundIndex < Integer.MAX_VALUE && foundIndex != docIndex) {
                this.me.move((Object)docParent, (EObject)documentElement, foundIndex);
                moved = true;
            }
        }
        return moved;
    }

    private int performTreeUpdates() throws ModelerCoreException {
        int count = 0;
        for (EObject parent : this.updateDeleteMap.keySet()) {
            ArrayList children = (ArrayList)this.updateDeleteMap.get(parent);
            if (children == null) continue;
            for (EObject child : children) {
                this.me.delete(child);
                ++count;
            }
        }
        return count;
    }

    private void removeChildrenOfSameName(EObject parent, Class clazz, String name) {
        String newName = this.validator.createValidName(name);
        if (newName != null) {
            name = newName;
        }
        for (EObject next : parent.eContents()) {
            if (!clazz.isAssignableFrom(next.getClass())) continue;
            try {
                String name2 = ((XmlDocumentNode)next).getName();
                if (name == null && name2 == null) {
                    this.me.delete(next);
                    continue;
                }
                if (name == null || !name.equals(name2)) continue;
                this.me.delete(next);
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log(4, (Throwable)e, XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Error_removing_children_of_same_name_1", new Object[0]));
            }
        }
    }

    private XSDComponent resolveSchemaRef(XSDComponent schemaComponent) {
        XSDElementDeclaration ref = null;
        if (schemaComponent instanceof XSDElementDeclaration) {
            ref = ((XSDElementDeclaration)schemaComponent).getResolvedElementDeclaration();
        } else if (schemaComponent instanceof XSDModelGroupDefinition) {
            ref = ((XSDModelGroupDefinition)schemaComponent).getResolvedModelGroupDefinition();
        } else if (schemaComponent instanceof XSDAttributeDeclaration) {
            ref = ((XSDAttributeDeclaration)schemaComponent).getResolvedAttributeDeclaration();
        } else if (schemaComponent instanceof XSDAttributeGroupDefinition) {
            ref = ((XSDAttributeGroupDefinition)schemaComponent).getResolvedAttributeGroupDefinition();
        }
        if (ref == null || ref == schemaComponent) {
            return null;
        }
        return ref;
    }

    @Override
    public void setAddNamespaces(boolean addNamespaces) {
    }

    private void setBuildStatusProperty(XmlBuildable xb, BuildStatus status) {
        xb.setBuildState(status);
    }

    @Override
    public void setFragments(Collection xmlFragments) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)xmlFragments);
        for (Object next : xmlFragments) {
            XSDComponent xsdComponent;
            if (!(next instanceof XmlFragment)) {
                throw new ModelerCoreException(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.All_xml_fragments_must_be_an_instance_of_XmlFragment_1", new Object[0]));
            }
            XmlFragment fragment = (XmlFragment)next;
            XSDComponent xSDComponent = xsdComponent = fragment.getRoot() == null ? null : fragment.getRoot().getXsdComponent();
            if (xsdComponent == null) continue;
            XSDComponent ref = this.resolveSchemaRef(xsdComponent);
            if (ref != null) {
                xsdComponent = ref;
            }
            this.fragmentMap.put(xsdComponent, fragment);
        }
        this.useFragments = !this.fragmentMap.isEmpty();
    }

    @Override
    public void setNumberOfLevelsToBuild(int numberOfLevelsToBuild) {
        this.numberOfLevelsToBuild = numberOfLevelsToBuild;
    }

    private void setRecursiveProperty(XmlElement element, boolean recursive) {
        element.setRecursive(recursive);
        XSDComponent xsdComponent = element.getXsdComponent();
        EObject parent = element.eContainer();
        while (parent != null) {
            if (parent instanceof XmlElement && ((XmlElement)parent).getXsdComponent() == xsdComponent) {
                ((XmlElement)parent).setRecursive(recursive);
                return;
            }
            parent = parent.eContainer();
        }
    }

    private void updateAdd(XmlDocumentEntity documentElement, XSDComponent xsdComponent, String taskName) throws ModelerCoreException {
        XSDTypeDefinition typeEntity;
        XmlContainerNode temp;
        String newName;
        String name;
        if (this.monitor.isCanceled()) {
            return;
        }
        this.monitor.subTask(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.{0}_{1}_of_{2}", new Object[]{taskName, new Integer(this.nodeCount), new Integer(4500)}));
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        if (this.useFragments) {
            XmlFragment fragment;
            XmlFragment xmlFragment = fragment = ref == null ? (XmlFragment)this.fragmentMap.get(xsdComponent) : (XmlFragment)this.fragmentMap.get(ref);
            if (fragment != null) {
                if (documentElement instanceof XmlEntityHolder) {
                    XmlFragmentUse use = this.docFactory.createXmlFragmentUse();
                    use.setFragment(fragment);
                    use.setName(fragment.getName());
                    use.setXsdComponent(ref == null ? xsdComponent : ref);
                    use.setNamespace(fragment.getRoot() == null ? null : fragment.getRoot().getNamespace());
                    use.setParent((XmlEntityHolder)((Object)documentElement));
                    return;
                }
                if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add docFragment to " + documentElement.getClass().getName());
                }
            }
        }
        boolean checkRecursion = false;
        boolean isRecursive = false;
        boolean checkExisting = false;
        if (ref != null) {
            if (this.recursionStack.contains(ref)) {
                isRecursive = true;
            }
            this.recursionStack.push(ref);
        } else {
            if (this.recursionStack.contains(xsdComponent)) {
                isRecursive = true;
            }
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = documentElement;
        ArrayList docChildren = new ArrayList(documentChild.eContents());
        XmlDocumentEntity existingChild = this.findExistingDocumentChild(docChildren, xsdComponent);
        if (xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract()) {
            name = ((XSDElementDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDElementDeclaration)ref).getName();
            }
            if (existingChild == null) {
                XmlElement temp2 = this.docFactory.createXmlElement();
                temp2.setXsdComponent(xsdComponent);
                if (documentElement instanceof XmlContainerNode) {
                    this.addValueToList(documentElement, temp2, ((XmlContainerNode)documentElement).getEntities());
                } else if (ModelerCore.DEBUG_XML) {
                    System.out.println("Can't add element to " + documentElement.getClass().getName());
                }
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)xsdComponent;
                if (xsdElement.getLexicalValue() != null) {
                    temp2.setValue(xsdElement.getLexicalValue());
                    XSDConstraint constraint = xsdElement.getConstraint();
                    if (XSDConstraint.DEFAULT_LITERAL.equals((Object)constraint)) {
                        temp2.setValueType(ValueType.DEFAULT_LITERAL);
                    } else if (XSDConstraint.FIXED_LITERAL.equals((Object)constraint)) {
                        temp2.setValueType(ValueType.FIXED_LITERAL);
                    }
                }
                documentChild = temp2;
                ++this.newCount;
            } else {
                boolean moved = this.moveIfNotAtSameIndex(existingChild, xsdComponent);
                if (moved) {
                    ++this.moveCount;
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                if (!name.equals(((XmlElement)existingChild).getName())) {
                    ((XmlElement)existingChild).setName(name);
                }
                documentChild = existingChild;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkRecursion = true;
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDModelGroupDefinition) {
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
        } else if (xsdComponent instanceof XSDAttributeDeclaration) {
            name = ((XSDAttributeDeclaration)xsdComponent).getName();
            if (ref != null) {
                name = ((XSDAttributeDeclaration)ref).getName();
            }
            if (existingChild == null) {
                boolean prohibited = this.isProhibited((XSDAttributeDeclaration)xsdComponent);
                if (prohibited) {
                    this.removeChildrenOfSameName(documentElement, XSDAttributeDeclaration.class, ((XSDAttributeDeclaration)xsdComponent).getName());
                } else {
                    XmlAttribute attribute = this.docFactory.createXmlAttribute();
                    attribute.setXsdComponent(xsdComponent);
                    if (documentElement instanceof XmlElement) {
                        this.addValueToList(documentElement, attribute, ((XmlElement)documentElement).getAttributes());
                    } else if (ModelerCore.DEBUG_XML) {
                        System.out.println("Can't add attribute to " + documentElement.getClass().getName());
                    }
                    documentChild = attribute;
                    ++this.newCount;
                }
            } else {
                boolean moved = this.moveIfNotAtSameIndex(existingChild, xsdComponent);
                if (moved) {
                    ++this.moveCount;
                }
                if ((newName = this.validator.createValidName(name)) != null) {
                    name = newName;
                }
                if (!name.equals(((XmlAttribute)existingChild).getName())) {
                    ((XmlAttribute)existingChild).setName(name);
                }
                documentChild = existingChild;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            Iterator iter = documentElement.eContents().iterator();
            if (iter.hasNext()) {
                XmlAll sibling = (XmlAll)iter.next();
                temp = sibling;
                temp.setXsdComponent(xsdComponent);
                documentChild = sibling;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlAll();
                temp.setXsdComponent(xsdComponent);
                this.addValueToList(documentElement, temp, ((XmlEntityHolder)((Object)documentElement)).getEntities());
                documentChild = temp;
                ++this.newCount;
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            checkRecursion = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isChoiceCompositor(xsdComponent)) {
            if (existingChild == null) {
                temp = this.docFactory.createXmlChoice();
                temp.setXsdComponent(xsdComponent);
                this.addValueToList(documentElement, temp, ((XmlEntityHolder)((Object)documentElement)).getEntities());
                documentChild = temp;
                ++this.newCount;
            } else {
                documentChild = existingChild;
            }
            checkExisting = true;
            ++this.nodeCount;
            this.updateMonitor();
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            for (XmlAll sibling : documentElement.eContents()) {
                if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference(sibling), (EObject)xsdComponent)) continue;
                temp = (XmlSequence)((Object)sibling);
                documentChild = temp;
                break;
            }
            if (temp == null) {
                temp = this.docFactory.createXmlSequence();
                this.addValueToList(documentElement, temp, ((XmlEntityHolder)((Object)documentElement)).getEntities());
                documentChild = temp;
                ++this.newCount;
            }
            temp.setXsdComponent(xsdComponent);
            ++this.nodeCount;
            this.updateMonitor();
        }
        if (isRecursive && checkRecursion) {
            ObjectID uuid;
            if (documentChild instanceof XmlElement) {
                ((XmlElement)documentChild).setRecursive(true);
            }
            if (this.recursiveElementUUIDs.contains(uuid = ModelerCore.getObjectId((EObject)documentChild))) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(uuid);
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        if (documentChild != documentElement) {
            this.updateSchemaUris(documentChild, xsdComponent);
        }
        if ((typeEntity = XmlDocumentUtil.findXSDType(xsdComponent)) != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent)) {
            if (checkExisting && existingChild == null) {
                this.addChildren(documentChild, (XSDComponent)typeEntity, taskName);
            } else {
                this.updateAdd(documentChild, (XSDComponent)typeEntity, taskName);
            }
        }
        for (EObject schemaChild : xsdComponent.eContents()) {
            if (!(schemaChild instanceof XSDComponent)) continue;
            if (checkExisting && existingChild == null) {
                this.addChildren(documentChild, (XSDComponent)schemaChild, taskName);
                continue;
            }
            this.updateAdd(documentChild, (XSDComponent)schemaChild, taskName);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void updateDelete(XmlDocumentEntity documentElement, XSDComponent xsdComponent, String taskName) {
        ArrayList oldChildren;
        ArrayList currentChildren;
        XmlContainerNode temp;
        if (this.monitor.isCanceled()) {
            return;
        }
        this.monitor.subTask(XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.{0}_{1}_of_{2}", new Object[]{taskName, new Integer(this.nodeCount), new Integer(4500)}));
        XSDComponent ref = this.resolveSchemaRef(xsdComponent);
        boolean checkRecursion = false;
        boolean isRecursive = false;
        boolean checkExisting = false;
        if (ref != null) {
            if (this.recursionStack.contains(ref)) {
                isRecursive = true;
            }
            this.recursionStack.push(ref);
        } else {
            if (this.recursionStack.contains(xsdComponent)) {
                isRecursive = true;
            }
            this.recursionStack.push(xsdComponent);
        }
        XmlDocumentEntity documentChild = documentElement;
        this.updateDeleteMap(documentElement, null);
        XmlDocumentEntity existingChild = this.findExistingDocumentChild((ArrayList)this.updateDeleteMap.get(documentElement), xsdComponent);
        if (this.isAllCompositor(xsdComponent)) {
            temp = null;
            currentChildren = (ArrayList)this.updateCurrentChildMap.get(documentElement);
            if (currentChildren != null) {
                for (Object sibling : currentChildren) {
                    if (!(sibling instanceof XmlAll)) continue;
                    temp = (XmlAll)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp == null && (oldChildren = (ArrayList)this.updateDeleteMap.get(documentElement)) != null) {
                for (Object sibling : oldChildren) {
                    if (!(sibling instanceof XmlAll)) continue;
                    temp = (XmlAll)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp != null) {
                this.updateDeleteMap(documentElement, documentChild);
            }
            if (ref != null) {
                xsdComponent = ref;
            }
            this.updateMonitor();
            checkRecursion = true;
        } else if (this.isSequenceCompositor(xsdComponent)) {
            temp = null;
            currentChildren = (ArrayList)this.updateCurrentChildMap.get(documentElement);
            if (currentChildren != null) {
                for (Object sibling : currentChildren) {
                    if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference((EObject)sibling), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp == null && (oldChildren = (ArrayList)this.updateDeleteMap.get(documentElement)) != null) {
                for (Object sibling : oldChildren) {
                    if (!(sibling instanceof XmlSequence) || !this.isValidSequenceForReuse((EObject)this.findSchemaReference((EObject)sibling), (EObject)xsdComponent)) continue;
                    temp = (XmlSequence)sibling;
                    documentChild = temp;
                    break;
                }
            }
            if (temp != null) {
                this.updateDeleteMap(documentElement, documentChild);
            }
            this.updateMonitor();
        } else if (existingChild != null) {
            documentChild = existingChild;
            this.updateDeleteMap(documentElement, documentChild);
            ++this.nodeCount;
            this.updateMonitor();
            checkExisting = true;
            checkRecursion = xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract();
        } else {
            boolean bl = checkRecursion = xsdComponent instanceof XSDElementDeclaration && !((XSDElementDeclaration)xsdComponent).isAbstract();
        }
        if (isRecursive && checkRecursion) {
            ObjectID uuid = ModelerCore.getObjectId((EObject)documentChild);
            if (this.recursiveElementUUIDs.contains(uuid)) {
                if (!this.recursionStack.isEmpty()) {
                    this.recursionStack.pop();
                }
                return;
            }
            this.recursiveElementUUIDs.add(uuid);
            if (!this.recursionStack.isEmpty()) {
                this.recursionStack.pop();
            }
            return;
        }
        XSDTypeDefinition typeEntity = XmlDocumentUtil.findXSDType(xsdComponent);
        if (typeEntity != null && typeEntity.eContainer() != null && !typeEntity.eContainer().equals(xsdComponent) && (!checkExisting || checkExisting && existingChild != null)) {
            this.updateDelete(documentChild, (XSDComponent)typeEntity, taskName);
        }
        for (EObject schemaChild : xsdComponent.eContents()) {
            if (checkExisting && (!checkExisting || existingChild == null) || !(schemaChild instanceof XSDComponent)) continue;
            this.updateDelete(documentChild, (XSDComponent)schemaChild, taskName);
        }
        if (!this.recursionStack.isEmpty()) {
            this.recursionStack.pop();
        }
    }

    private void updateDeleteMap(XmlDocumentEntity documentEntity, XmlDocumentEntity child) {
        if (child == null) {
            if (this.updateDeleteMap.get(documentEntity) == null) {
                ArrayList children = new ArrayList(documentEntity.eContents());
                this.updateDeleteMap.put(documentEntity, children);
            }
            return;
        }
        ArrayList<XmlDocumentEntity> children = (ArrayList<XmlDocumentEntity>)this.updateDeleteMap.get(documentEntity);
        if (children != null) {
            children.remove(child);
            this.updateDeleteMap.put(documentEntity, children);
        }
        if ((children = (ArrayList)this.updateCurrentChildMap.get(documentEntity)) == null) {
            children = new ArrayList<XmlDocumentEntity>();
        }
        children.add(child);
        this.updateCurrentChildMap.put(documentEntity, children);
    }

    private void updateFromSchema(XmlElement rootElement, boolean doAdds) throws ModelerCoreException {
        this.root = rootElement;
        this.newCount = 0;
        XSDComponent schemaComponent = this.root.getXsdComponent();
        XSDTypeDefinition typeDefn = XmlDocumentUtil.findXSDType(schemaComponent);
        if (typeDefn != null) {
            this.nodeCount = 1;
            this.monitor.beginTask(String.valueOf(CALCULATING_MSG2) + this.root, 5000);
            this.initializeRecursionStack(this.root);
            this.monitor.worked(500);
            this.monitor.subTask(String.valueOf(UPDATING_MSG) + this.root);
            double temp = 4500.0 / (double)this.nodeCount;
            this.factor = temp > 0.0 ? 4500 / this.nodeCount : new Double(-2.0444444444444443).intValue();
            this.initializeRecursionStack(this.root);
            this.nodeCount = 0;
            if (doAdds) {
                this.updateAdd(this.root, (XSDComponent)typeDefn, String.valueOf(UPDATING_MSG) + this.root);
            } else {
                this.updateDelete(this.root, (XSDComponent)typeDefn, String.valueOf(UPDATING_MSG) + this.root);
            }
        }
    }

    @Override
    public int updateFromSchema(XmlElement rootElement, IProgressMonitor progressMonitor) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)rootElement);
        this.root = rootElement;
        int count = 0;
        this.monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        boolean startedTxn = ModelerCore.startTxn((boolean)true, (boolean)true, (String)XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Update_XML_Document_from_Schema_6", new Object[0]), (Object)this);
        boolean succeeded = false;
        try {
            this.updateFromSchema(this.root, false);
            count = this.performTreeUpdates();
            this.referencedSchemas.clear();
            this.initializeSchemaUris(rootElement);
            this.updateFromSchema(this.root, true);
            count = count + this.newCount + this.moveCount;
            succeeded = true;
        }
        finally {
            this.cleanup();
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return count;
    }

    private void updateMonitor() {
        if (this.factor > 0) {
            this.monitor.worked(this.factor);
            return;
        }
        --this.tempFactor;
        if (this.tempFactor == this.factor) {
            this.monitor.worked(1);
            this.tempFactor = 0;
        }
    }

    private void updateSchemaUris(EObject docNode, XSDComponent xsdComp) {
        if (xsdComp == null || docNode == null) {
            return;
        }
        XSDSchema schema = xsdComp.getSchema();
        if (schema == null) {
            String msg = null;
            if (xsdComp instanceof XSDNamedComponent) {
                XSDNamedComponent namedComp = (XSDNamedComponent)xsdComp;
                Object[] params = new Object[]{namedComp.getName()};
                msg = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_resolve_XSD_reference_to", params);
            } else {
                IPath path = ModelerCore.getModelEditor().getModelRelativePath(docNode);
                Object[] params = new Object[]{path};
                msg = XmlDocumentPlugin.Util.getString("XmlDocumentBuilderImpl.Unable_to_resolve_XSD_reference_for", params);
            }
            XmlDocumentPlugin.Util.log(4, msg);
            return;
        }
        if (this.referencedSchemas.contains(schema)) {
            return;
        }
        this.referencedSchemas.add(schema);
        XmlElement root = null;
        EObject node = docNode;
        while (root == null && node != null) {
            if (node instanceof XmlRoot) {
                root = (XmlElement)node;
                continue;
            }
            node = node.eContainer();
        }
        Map qNameMap = schema.getQNamePrefixToNamespaceMap();
        if (qNameMap != null) {
            for (Map.Entry next : qNameMap.entrySet()) {
                String prefix = (String)next.getKey();
                String uri = (String)next.getValue();
                XmlNamespace ns = this.docFactory.createXmlNamespace();
                if ("this".equals(prefix) || prefix == null || prefix.trim().length() == 0) {
                    ns.setPrefix(XmlDocumentUtil.createXmlPrefixFromUri(uri));
                } else {
                    ns.setPrefix(prefix);
                }
                ns.setUri(uri);
                ns.setElement(root);
                if (this.schemaUris.contains(uri)) continue;
                this.schemaUris.add(uri);
                this.uriToNamespaceMap.put(uri, ns);
            }
        }
    }
}

