/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.ide.fabric8.core.dto.LogEventDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;

public class LogResultsDTO {
    private static final String PROPERTY_VALUE_UNDEFINED = "?";
    private static final String PROPERTY_LOGRESULTS_HOST = "host";
    private static final String PROPERTY_LOGRESULTS_FROM = "fromTimestamp";
    private static final String PROPERTY_LOGRESULTS_TO = "toTimestamp";
    private static final String PROPERTY_LOGRESULTS_EVENTS = "events";
    private String host;
    private Long from;
    private Long to;
    private List<LogEventDTO> logEvents;

    public LogResultsDTO() {
        this(null, null, null, new ArrayList<LogEventDTO>());
    }

    public LogResultsDTO(String host, Long from, Long to, List<LogEventDTO> events) {
        this.host = host;
        this.from = from;
        this.to = to;
        this.logEvents = events;
    }

    public Long getFrom() {
        return this.from;
    }

    public String getHost() {
        return this.host;
    }

    public List<LogEventDTO> getLogEvents() {
        return this.logEvents;
    }

    public Long getTo() {
        return this.to;
    }

    public void setFrom(Long from) {
        this.from = from;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setLogEvents(List<LogEventDTO> logEvents) {
        this.logEvents = logEvents;
    }

    public void setTo(Long to) {
        this.to = to;
    }

    public static LogResultsDTO fromJson(ModelNode rootNode) throws Exception {
        String host = JsonHelper.getAsString(rootNode, PROPERTY_LOGRESULTS_HOST);
        Long from = JsonHelper.getAsLong(rootNode, PROPERTY_LOGRESULTS_FROM);
        Long to = JsonHelper.getAsLong(rootNode, PROPERTY_LOGRESULTS_TO);
        LogResultsDTO res = new LogResultsDTO();
        res.setHost(host);
        res.setFrom(from);
        res.setTo(to);
        List<ModelNode> events = JsonHelper.getAsList(rootNode, PROPERTY_LOGRESULTS_EVENTS);
        for (ModelNode ev : events) {
            res.getLogEvents().add(LogEventDTO.fromJson(res, ev));
        }
        return res;
    }
}

