/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import io.fabric8.api.SshHostConfiguration;
import java.io.File;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileRequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.SshConfigurationDTO;

public class CreateSshContainerOptionsDTO
extends CreateContainerOptionsDTO<CreateSshContainerOptionsDTO> {
    public static final String DEFAULT_PRIVATE_KEY_FILE = String.valueOf(System.getProperty("user.home")) + File.separatorChar + ".ssh" + File.separatorChar + "id_rsa";
    static final int DEFAULT_SSH_RETRIES = 1;
    static final int DEFAULT_SSH_PORT = 22;
    public static final String DEFAULT_PATH = "~/containers/";
    public static final String DEFAULT_USERNAME = "root";
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final int sshRetries;
    private final int retryDelay;
    private final String privateKeyFile;
    private final String passPhrase;
    private final String path;
    private final Map<String, String> environmentalVariables;
    private final List<String> fallbackRepositories;
    private final Boolean uploadDistribution;

    public CreateSshContainerOptionsDTO(String bindAddress, String resolver, String globalResolver, String manualIp, BigInteger minimumPort, BigInteger maximumPort, Set<String> profiles, String version, Map<String, String> dataStoreProperties, BigInteger zooKeeperServerPort, BigInteger zooKeeperServerConnectionPort, String zookeeperPassword, Boolean ensembleStart, Boolean agentEnabled, Boolean autoImportEnabled, String importPath, Map<String, String> users, String name, String parent, String providerType, Boolean ensembleServer, String preferredAddress, Map<String, Properties> systemProperties, Integer number, URI proxyUri, String zookeeperUrl, String jvmOpts, Boolean adminAccess, Boolean clean, String username, String password, String host, int port, int sshRetries, int retryDelay, String privateKeyFile, String passPhrase, String path, Map<String, String> environmentalVariables, List<String> fallbackRepositories, Boolean uploadDistribution, String jmxUser, String jmxPassword) {
        super(bindAddress, resolver, globalResolver, manualIp, minimumPort, maximumPort, profiles, version, dataStoreProperties, zooKeeperServerPort, zooKeeperServerConnectionPort, zookeeperPassword, ensembleStart, agentEnabled, false, 0L, autoImportEnabled, importPath, users, name, parent, providerType, ensembleServer, preferredAddress, systemProperties, number, proxyUri, zookeeperUrl, jvmOpts, adminAccess, clean, jmxUser, jmxPassword);
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.sshRetries = sshRetries;
        this.retryDelay = retryDelay;
        this.privateKeyFile = privateKeyFile;
        this.passPhrase = passPhrase;
        this.path = path;
        this.fallbackRepositories = fallbackRepositories;
        this.uploadDistribution = uploadDistribution;
        this.environmentalVariables = Collections.unmodifiableMap(new HashMap<String, String>(environmentalVariables));
    }

    @Override
    public CreateContainerOptionsDTO updateCredentials(String newUser, String newPassword) {
        return new CreateSshContainerOptionsDTO(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.getEnsembleStart(), this.getAgentEnabled(), this.getAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "ssh", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), this.getClean(), newUser != null ? newUser : this.username, newPassword != null ? newPassword : this.password, this.host, this.port, this.sshRetries, this.retryDelay, this.privateKeyFile, this.passPhrase, this.path, this.environmentalVariables, this.fallbackRepositories, this.uploadDistribution, this.getJmxUser(), this.getJmxPassword());
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getSshRetries() {
        return this.sshRetries;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getEnvironmentalVariables() {
        return this.environmentalVariables;
    }

    public Boolean doUploadDistribution() {
        return this.uploadDistribution;
    }

    public String getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public String getHostNameContext() {
        return "none";
    }

    public List<String> getFallbackRepositories() {
        return this.fallbackRepositories;
    }

    public CreateSshContainerOptionsDTO clone() throws CloneNotSupportedException {
        return (CreateSshContainerOptionsDTO)super.clone();
    }

    public String toString() {
        return "createSshContainer(" + this.getUsername() + "@" + this.getHost() + ":" + this.getPort() + " " + this.getPath() + ")";
    }

    public static /* bridge */ /* synthetic */ CreateContainerOptionsDTO.Builder builder() {
        return CreateSshContainerOptionsDTO.builder();
    }

    public static class Builder
    extends CreateContainerOptionsDTO.Builder<Builder> {
        private String username;
        private String password;
        private String host;
        private int port = 22;
        private int sshRetries = 1;
        private int retryDelay = 1;
        private String privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
        private String passPhrase;
        private String path = "~/containers/";
        private Map<String, String> environmentalVariables = new HashMap<String, String>();
        private List<String> fallbackRepositories = new ArrayList<String>();
        private Boolean uploadDistribution = true;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder environmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
            return this;
        }

        public Builder environmentalVariable(String key, String value) {
            this.environmentalVariables.put(key, value);
            return this;
        }

        public Builder environmentalVariable(String entry) {
            if (entry.contains("=")) {
                String key = entry.substring(0, entry.indexOf("="));
                String value = entry.substring(entry.indexOf("=") + 1);
                this.environmentalVariable(key, value);
            }
            return this;
        }

        public Builder environmentalVariable(List<String> entries) {
            if (entries != null) {
                for (String entry : entries) {
                    this.environmentalVariable(entry);
                }
            }
            return this;
        }

        public Builder sshRetries(int sshRetries) {
            this.sshRetries = sshRetries;
            return this;
        }

        public Builder retryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder privateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
            return this;
        }

        public Builder passPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
            return this;
        }

        public Builder fallbackRepositories(List<String> fallbackRepositories) {
            this.fallbackRepositories = fallbackRepositories;
            return this;
        }

        public Builder uploadDistribution(Boolean uploadDistribution) {
            this.uploadDistribution = uploadDistribution;
            return this;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getSshRetries() {
            return this.sshRetries;
        }

        public void setSshRetries(int sshRetries) {
            this.sshRetries = sshRetries;
        }

        public int getRetryDelay() {
            return this.retryDelay;
        }

        public void setRetryDelay(int retryDelay) {
            this.retryDelay = retryDelay;
        }

        public String getPrivateKeyFile() {
            return this.privateKeyFile;
        }

        public void setPrivateKeyFile(String privateKeyFile) {
            this.privateKeyFile = privateKeyFile;
        }

        public String getPassPhrase() {
            return this.passPhrase;
        }

        public void setPassPhrase(String passPhrase) {
            this.passPhrase = passPhrase;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setEnvironmentalVariables(Map<String, String> environmentalVariables) {
            this.environmentalVariables = environmentalVariables;
        }

        public List<String> getFallbackRepositories() {
            return this.fallbackRepositories;
        }

        public void setFallbackRepositories(List<String> fallbackRepositories) {
            this.fallbackRepositories = fallbackRepositories;
        }

        public Boolean getUploadDistribution() {
            return this.uploadDistribution;
        }

        public void setUploadDistribution(Boolean uploadDistribution) {
            this.uploadDistribution = uploadDistribution;
        }

        @Override
        public CreateSshContainerOptionsDTO build() {
            return new CreateSshContainerOptionsDTO(this.getBindAddress(), this.getResolver(), this.getGlobalResolver(), this.getManualIp(), this.getMinimumPort(), this.getMaximumPort(), this.getProfiles(), this.getVersion(), this.getDataStoreProperties(), this.getZooKeeperServerPort(), this.getZooKeeperServerConnectionPort(), this.getZookeeperPassword(), this.getEnsembleStart(), this.getAgentEnabled(), this.getAutoImportEnabled(), this.getImportPath(), this.getUsers(), this.getName(), this.getParent(), "ssh", this.isEnsembleServer(), this.getPreferredAddress(), this.getSystemProperties(), this.getNumber(), this.getProxyUri(), this.getZookeeperUrl(), this.getJvmOpts(), this.isAdminAccess(), false, this.username, this.password, this.host, this.port, this.sshRetries, this.retryDelay, this.privateKeyFile, this.passPhrase, this.path, this.environmentalVariables, this.fallbackRepositories, this.uploadDistribution, this.getJmxUser(), this.getJmxPassword());
        }

        public void configure(SshHostConfiguration sshHostConfig, RequirementsDTO requirements, ProfileRequirementsDTO profileRequirements) {
            Integer portValue;
            SshConfigurationDTO sshHosts = requirements.getSshConfiguration();
            this.host = sshHostConfig.getHostName();
            if (Strings.isBlank((String)this.host)) {
                throw new IllegalArgumentException("Missing host property in the ssh configuration: " + sshHostConfig);
            }
            String preferredAddress = this.getPreferredAddress();
            if (Strings.isBlank((String)preferredAddress)) {
                preferredAddress = sshHostConfig.getPreferredAddress();
                if (Strings.isBlank((String)preferredAddress)) {
                    preferredAddress = this.host;
                }
                this.preferredAddress(preferredAddress);
            }
            this.path = sshHostConfig.getPath();
            if (Strings.isBlank((String)this.path)) {
                if (sshHosts != null) {
                    this.path = sshHosts.getDefaultPath();
                }
                if (Strings.isBlank((String)this.path)) {
                    this.path = CreateSshContainerOptionsDTO.DEFAULT_PATH;
                }
            }
            if ((portValue = sshHostConfig.getPort()) == null && sshHosts != null) {
                portValue = sshHosts.getDefaultPort();
            }
            this.port = portValue != null ? portValue : 22;
            this.username = sshHostConfig.getUsername();
            if (Strings.isBlank((String)this.username)) {
                if (sshHosts != null) {
                    this.username = sshHosts.getDefaultUsername();
                }
                if (Strings.isBlank((String)this.username)) {
                    this.username = CreateSshContainerOptionsDTO.DEFAULT_USERNAME;
                }
            }
            this.password = sshHostConfig.getPassword();
            if (Strings.isBlank((String)this.password) && sshHosts != null) {
                this.password = sshHosts.getDefaultPassword();
            }
            if (sshHosts != null) {
                this.fallbackRepositories = sshHosts.getFallbackRepositories();
            }
            this.passPhrase = sshHostConfig.getPassPhrase();
            if (Strings.isBlank((String)this.passPhrase) && sshHosts != null) {
                this.passPhrase = sshHosts.getDefaultPassPhrase();
            }
            this.privateKeyFile = sshHostConfig.getPrivateKeyFile();
            if (Strings.isBlank((String)this.privateKeyFile)) {
                if (sshHosts != null) {
                    this.privateKeyFile = sshHosts.getDefaultPrivateKeyFile();
                }
                if (Strings.isBlank((String)this.privateKeyFile)) {
                    this.privateKeyFile = DEFAULT_PRIVATE_KEY_FILE;
                }
            }
        }
    }
}

