/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.connector.JolokiaHelpers;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;

public class ContainerDTO
extends BaseDTO {
    private static final String JSON_FIELD_ROOT = "root";
    private static final String JSON_FIELD_PROVISION_STATUS = "provisionStatus";
    private static final String JSON_FIELD_PARENT_ID = "parentId";
    private static final String JSON_FIELD_CHILDREN_IDS = "childrenIds";
    private static final String JSON_FIELD_PROCESS_ID = "processId";
    private static final String JSON_FIELD_VERSION_ID = "versionId";
    private static final String JSON_FIELD_PROFILE_IDS = "profileIds";
    private static final String JSON_FIELD_ENSEMBLE_SERVER = "ensembleServer";
    private static final String JSON_FIELD_JMX_URL = "jmxUrl";
    private static final String JSON_FIELD_HTTP_URL = "httpUrl";
    private static final String JSON_FIELD_DEBUG_PORT = "debugPort";
    private static final String JSON_FIELD_MANAGED = "managed";
    private static final String JSON_FIELD_TYPE = "type";
    private static final String JSON_FIELD_ALIVE = "alive";
    private static final String JSON_FIELD_SSH_URL = "sshUrl";
    private static final String JSON_FIELD_JOLOKIA_URL = "jolokiaUrl";
    private static final String JSON_FIELD_PROVISIONING_COMPLETE = "provisioningComplete";
    private static final String JSON_FIELD_JMX_DOMAINS = "jmxDomains";
    private static final String JSON_FIELD_LOCATION = "location";
    private static final String JSON_FIELD_PROVISIONING_PENDING = "provisioningPending";
    private static final String JSON_FIELD_PROFILES = "profiles";
    private static final String JSON_FIELD_CHILDREN = "children";
    private static final String JSON_FIELD_PROVISION_CHECKSUMS = "provisionChecksums";
    private static final String JSON_FIELD_LOCAL_HOSTNAME = "localHostname";
    private static final String JSON_FIELD_GEO_LOCATION = "geoLocation";
    private static final String JSON_FIELD_VERSION = "version";
    private static final String JSON_FIELD_ALIVE_AND_OK = "aliveAndOK";
    private static final String JSON_FIELD_RESOLVER = "resolver";
    private static final String JSON_FIELD_PROVISION_EXCEPTION = "provisionException";
    private static final String JSON_FIELD_PROVISION_LIST = "provisionList";
    private static final String JSON_FIELD_LOCAL_IP = "localIp";
    private static final String JSON_FIELD_METADATA = "metadata";
    private static final String JSON_FIELD_PROVISION_STATUS_MAP = "provisionStatusMap";
    private static final String JSON_FIELD_MAX_PORT = "maximumPort";
    private static final String JSON_FIELD_PARENT = "parent";
    private static final String JSON_FIELD_MANUAL_IP = "manualIp";
    private static final String JSON_FIELD_PUBLIC_IP = "publicIp";
    private static final String JSON_FIELD_PUBLIC_HOSTNAME = "publicHostname";
    private static final String JSON_FIELD_IP = "ip";
    private static final String JSON_FIELD_OVERLAY_PROFILE = "overlayProfile";
    private static final String JSON_FIELD_MIN_PORT = "minimumPort";
    private static final String JSON_FIELD_PROVISION_RESULT = "provisionResult";

    public ContainerDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    public Boolean isProvisioningPending() {
        return (Boolean)this.getFieldValue(JSON_FIELD_PROVISIONING_PENDING);
    }

    public String getLocation() {
        return (String)this.getFieldValue(JSON_FIELD_LOCATION);
    }

    public void setLocation(String newLocation) {
        this.setFieldValue(JSON_FIELD_LOCATION, newLocation);
    }

    public List<String> getJmxDomains() {
        return (List)this.getFieldValue(JSON_FIELD_JMX_DOMAINS);
    }

    public Boolean isProvisioningComplete() {
        return (Boolean)this.getFieldValue(JSON_FIELD_PROVISIONING_COMPLETE);
    }

    public Boolean isRoot() {
        return (Boolean)this.getFieldValue(JSON_FIELD_ROOT);
    }

    public String getProvisionStatus() {
        return (String)this.getFieldValue(JSON_FIELD_PROVISION_STATUS);
    }

    public String getParentId() {
        return (String)this.getFieldValue(JSON_FIELD_PARENT_ID);
    }

    public ContainerDTO getParent() {
        return this.fabric8.getContainer(this.getParentId());
    }

    public List<String> getChildrenIds() {
        return (List)this.getFieldValue(JSON_FIELD_CHILDREN_IDS);
    }

    public List<ContainerDTO> getChildren() {
        ArrayList<ContainerDTO> children = new ArrayList<ContainerDTO>();
        for (String cid : this.getChildrenIds()) {
            ContainerDTO child = this.fabric8.getContainer(cid);
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    public Long getProcessId() {
        return (Long)this.getFieldValue(JSON_FIELD_PROCESS_ID);
    }

    public String getVersionId() {
        return (String)this.getFieldValue(JSON_FIELD_VERSION_ID);
    }

    public VersionDTO getVersion() {
        for (VersionDTO version : this.fabric8.getVersions()) {
            if (!version.getId().equals(this.getVersionId())) continue;
            return version;
        }
        return null;
    }

    public List<String> getProfileIDs() {
        return (List)this.getFieldValue(JSON_FIELD_PROFILE_IDS);
    }

    public List<ProfileDTO> getProfiles() {
        ArrayList<ProfileDTO> profiles = new ArrayList<ProfileDTO>();
        for (String pid : this.getProfileIDs()) {
            ProfileDTO prof = this.fabric8.getProfile(this.getVersionId(), pid);
            if (prof == null) continue;
            profiles.add(prof);
        }
        return profiles;
    }

    public Boolean isEnsembleServer() {
        return (Boolean)this.getFieldValue(JSON_FIELD_ENSEMBLE_SERVER);
    }

    public String getJMXUrl() {
        return (String)this.getFieldValue(JSON_FIELD_JMX_URL);
    }

    public String getContainerWebURL() {
        return (String)this.getFieldValue(JSON_FIELD_HTTP_URL);
    }

    public Integer getDebugPort() {
        return (Integer)this.getFieldValue(JSON_FIELD_DEBUG_PORT);
    }

    public Boolean isManaged() {
        return (Boolean)this.getFieldValue(JSON_FIELD_MANAGED);
    }

    public String getType() {
        return (String)this.getFieldValue(JSON_FIELD_TYPE);
    }

    public Boolean isAlive() {
        return (Boolean)this.getFieldValue(JSON_FIELD_ALIVE);
    }

    public String getSshUrl() {
        return (String)this.getFieldValue(JSON_FIELD_SSH_URL);
    }

    public String getJolokiaUrl() {
        return (String)this.getFieldValue(JSON_FIELD_JOLOKIA_URL);
    }

    public void setVersion(VersionDTO version) {
        this.setVersion(version.getId());
    }

    public void setVersion(String versionId) {
        this.setFieldValue(JSON_FIELD_VERSION_ID, versionId);
        this.fabric8.setVersionForContainer(this.getId(), versionId);
    }

    public void setProfileDTOs(List<ProfileDTO> profiles) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ProfileDTO p : profiles) {
            ids.add(p.getId());
        }
        this.setProfiles(ids);
    }

    public void setProfiles(List<String> profileIds) {
        this.setFieldValue(JSON_FIELD_PROFILE_IDS, profileIds);
        this.fabric8.setProfilesForContainer(this.getId(), this.getVersionId(), profileIds);
    }

    public void addProfiles(String ... profileIds) {
        List ids = (List)this.getFieldValue(JSON_FIELD_PROFILE_IDS);
        String[] stringArray = profileIds;
        int n = profileIds.length;
        int n2 = 0;
        while (n2 < n) {
            String pId = stringArray[n2];
            if (!ids.contains(pId)) {
                ids.add(pId);
            }
            ++n2;
        }
        this.setFieldValue(JSON_FIELD_PROFILE_IDS, ids);
        this.fabric8.addProfilesToContainer(this.getId(), profileIds);
    }

    public void removeProfiles(String ... profileIds) {
        List ids = (List)this.getFieldValue(JSON_FIELD_PROFILE_IDS);
        ids.removeAll(JolokiaHelpers.toList(profileIds));
        this.setFieldValue(JSON_FIELD_PROFILE_IDS, ids);
        this.fabric8.removeProfiles(this.getId(), profileIds);
    }

    public void start() {
        this.fabric8.startContainer(this);
    }

    public void stop() {
        this.fabric8.stopContainer(this);
    }

    public void destroy() {
        this.fabric8.destroyContainer(this);
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void update() {
    }
}

