/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.security.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;

public class EquinoxSecureStorageProvider
implements ISecureStorageProvider {
    private static EquinoxSecureStorageProvider instance;

    private EquinoxSecureStorageProvider() {
    }

    public static EquinoxSecureStorageProvider getInstance() {
        if (instance == null) {
            instance = new EquinoxSecureStorageProvider();
        }
        return instance;
    }

    public boolean existsInSecureStorage(String nodeKey, String key) throws Exception {
        String encoded;
        ISecurePreferences root = this.getRoot();
        if (!root.nodeExists(encoded = this.encode(nodeKey))) {
            return false;
        }
        ISecurePreferences node = root.node(encoded);
        String[] keys = node.keys();
        if (keys == null) {
            return false;
        }
        List<String> keyList = Arrays.asList(keys);
        return keyList.contains(key);
    }

    public String getFromSecureStorage(String nodeKey, String key) throws Exception {
        ISecurePreferences node = this.getNode(nodeKey);
        String val = node.get(key, null);
        if (val == null) {
            return null;
        }
        return new String(EncodingUtils.decodeBase64((String)val));
    }

    public void storeInSecureStorage(String nodeKey, String key, String value) throws Exception {
        ISecurePreferences node = this.getNode(nodeKey);
        if (value == null) {
            node.put(key, value, true);
        } else {
            node.put(key, EncodingUtils.encodeBase64((byte[])value.getBytes()), true);
        }
    }

    private ISecurePreferences getRoot() {
        return SecurePreferencesFactory.getDefault();
    }

    private String encode(String nodeKey) throws UnsupportedEncodingException {
        String encoded = URLEncoder.encode(nodeKey, "UTF-8");
        return encoded;
    }

    private ISecurePreferences getNode(String nodeKey) throws Exception {
        ISecurePreferences root = this.getRoot();
        String encoded = this.encode(nodeKey);
        return root.node(encoded);
    }
}

