/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;

public class RelationalPrimaryKey
extends RelationalReference {
    private Collection<RelationalColumn> columns;

    public RelationalPrimaryKey() {
        this.setType(8);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalPrimaryKey(String name) {
        super(name);
        this.setType(8);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public Collection<RelationalColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<RelationalColumn> columns) {
        this.columns = columns;
        this.handleInfoChanged();
    }

    public void addColumn(RelationalColumn column) {
        if (this.columns.add(column)) {
            this.handleInfoChanged();
        }
    }

    public RelationalTable getTable() {
        if (this.getParent() != null) {
            return (RelationalTable)this.getParent();
        }
        return null;
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (!keyStr.equalsIgnoreCase("DESCRIPTION")) continue;
            this.setDescription(value);
        }
        this.handleInfoChanged();
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.getColumns().isEmpty()) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_pkNoColumnsDefined, (Object)this.getName())));
            return;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        if (!this.getColumns().isEmpty()) {
            sb.append("\n\t").append(this.getColumns().size()).append(" columns");
            for (RelationalColumn col : this.getColumns()) {
                sb.append("\n\tcol = ").append(col);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalPrimaryKey other = (RelationalPrimaryKey)object;
        Collection<RelationalColumn> thisColumns = this.getColumns();
        Collection<RelationalColumn> thatColumns = other.getColumns();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        return thisColumns.isEmpty() || thisColumns.equals(thatColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        Collection<RelationalColumn> cols = this.getColumns();
        for (RelationalColumn col : cols) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{col});
        }
        return result;
    }
}

