/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.MultiplicityKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.ProcedureUpdateCount;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.RelationalPlugin;
import org.teiid.designer.relational.model.DatatypeProcessor;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;

public class RelationalModelFactory
implements RelationalConstants {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory FACTORY = RelationalFactory.eINSTANCE;
    public static RelationalModelFactory INSTANCE = new RelationalModelFactory();
    private DatatypeProcessor datatypeProcessor;
    private Map<RelationalForeignKey, BaseTable> fkTableMap = new HashMap<RelationalForeignKey, BaseTable>();
    private Collection<RelationalIndex> indexes = new ArrayList<RelationalIndex>();
    private Map<String, Collection<ModelObjectExtensionAssistant>> classNameToMedAssistantsMap = new HashMap<String, Collection<ModelObjectExtensionAssistant>>();

    public RelationalModelFactory() {
        this.datatypeProcessor = new DatatypeProcessor();
    }

    protected RelationalModelExtensionAssistant getExtensionAssistant() {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
        return assistant;
    }

    public ModelResource createRelationalModel(IPath location, String modelName) throws ModelWorkspaceException {
        ModelResource resrc = ModelerCore.createModelResource((IPath)location, (String)modelName);
        resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
        resrc.getModelAnnotation().setModelType(ModelType.PHYSICAL_LITERAL);
        ModelerCore.getModelEditor().getAllContainers(resrc.getEmfResource());
        return resrc;
    }

    public ModelResource createRelationalModel(IContainer container, String modelName) throws ModelWorkspaceException {
        IProject project = container.getProject();
        String actualModelName = modelName;
        if (!modelName.toLowerCase().endsWith(".xmi")) {
            actualModelName = String.valueOf(modelName) + ".xmi";
        }
        IPath relativeModelPath = container.getFullPath().removeFirstSegments(1).append(actualModelName);
        IFile modelFile = project.getFile(relativeModelPath);
        ModelResource resrc = ModelerCore.create((IFile)modelFile);
        resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
        resrc.getModelAnnotation().setModelType(ModelType.PHYSICAL_LITERAL);
        ModelerCore.getModelEditor().getAllContainers(resrc.getEmfResource());
        return resrc;
    }

    public void build(ModelResource modelResource, RelationalModel model, IProgressMonitor progressMonitor) {
        try {
            RelationalModelFactory builder = new RelationalModelFactory();
            RelationalModelExtensionAssistant assistant = this.getExtensionAssistant();
            try {
                assistant.applyMedIfNecessary(modelResource.getUnderlyingResource());
            }
            catch (Exception e) {
                RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
            builder.buildFullModel(model, modelResource, progressMonitor);
            modelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (ModelerCoreException e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public void buildFullModel(RelationalModel model, ModelResource modelResource, IProgressMonitor progressMonitor) throws ModelerCoreException {
        progressMonitor.setTaskName(Messages.relationalModelFactory_creatingModelChildren);
        for (RelationalReference child : model.getChildren()) {
            int processType = child.getProcessType();
            switch (processType) {
                case -1: {
                    break;
                }
                case 0: {
                    this.buildObject(child, modelResource, progressMonitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.deleteChildWithName(modelResource, child, progressMonitor);
                    this.buildObject(child, modelResource, progressMonitor);
                }
            }
            progressMonitor.worked(1);
        }
        progressMonitor.setTaskName(Messages.relationalModelFactory_creatingForeigneKeys);
        progressMonitor.worked(1);
        for (RelationalForeignKey fkRef : this.fkTableMap.keySet()) {
            this.createForeignKey(fkRef, this.fkTableMap.get(fkRef), modelResource);
        }
        progressMonitor.setTaskName(Messages.relationalModelFactory_creatingIndexes);
        progressMonitor.worked(1);
        for (RelationalIndex indexRef : this.indexes) {
            this.createIndex(indexRef, modelResource);
        }
    }

    private void deleteChildWithName(ModelResource targetResource, RelationalReference ref, IProgressMonitor progressMonitor) throws ModelerCoreException {
        progressMonitor.setTaskName(NLS.bind((String)Messages.relationalModelFactory_replacingModelObject, (Object)ref.getName()));
        EList existingChildren = targetResource.getEmfResource().getContents();
        EObject childToDelete = null;
        for (EObject child : existingChildren) {
            String name = ModelerCore.getModelEditor().getName(child);
            if (name == null || !name.equalsIgnoreCase(ref.getName())) continue;
            childToDelete = child;
            break;
        }
        if (childToDelete != null) {
            ModelerCore.getModelEditor().delete(childToDelete);
        }
    }

    public EObject buildObject(RelationalReference relationalRef, ModelResource modelResource, IProgressMonitor progressMonitor) throws ModelWorkspaceException {
        EObject newEObject = null;
        progressMonitor.setTaskName(NLS.bind((String)Messages.relationalModelFactory_creatingModelChild, (Object)relationalRef.getName()));
        switch (relationalRef.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                newEObject = this.createBaseTable(relationalRef, modelResource);
                for (RelationalIndex index : ((RelationalTable)relationalRef).getIndexes()) {
                    this.createIndex(index, modelResource);
                }
                break;
            }
            case 4: {
                newEObject = this.createView(relationalRef, modelResource);
                break;
            }
            case 5: {
                newEObject = this.createProcedure(relationalRef, modelResource);
                break;
            }
            case 13: {
                this.indexes.add((RelationalIndex)relationalRef);
                break;
            }
            default: {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.relationalModelFactory_unknown_object_type_0_cannot_be_processed, (Object)relationalRef.getName()));
            }
        }
        return newEObject;
    }

    public EObject createBaseTable(RelationalReference ref, ModelResource modelResource) throws ModelWorkspaceException {
        Collection<RelationalUniqueConstraint> uniqueConstraints;
        CoreArgCheck.isInstanceOf(RelationalTable.class, (Object)ref);
        RelationalTable tableRef = (RelationalTable)ref;
        BaseTable baseTable = FACTORY.createBaseTable();
        baseTable.setName(tableRef.getName());
        baseTable.setSupportsUpdate(tableRef.getSupportsUpdate());
        baseTable.setMaterialized(tableRef.isMaterialized());
        baseTable.setNameInSource(tableRef.getNameInSource());
        baseTable.setSystem(tableRef.isSystem());
        baseTable.setCardinality(tableRef.getCardinality());
        modelResource.getEmfResource().getContents().add((Object)baseTable);
        if (tableRef.getDescription() != null) {
            this.createAnnotation((EObject)baseTable, tableRef.getDescription(), modelResource);
        }
        for (RelationalColumn column : tableRef.getColumns()) {
            this.createColumn((RelationalReference)column, (Table)baseTable, modelResource);
        }
        RelationalPrimaryKey pk = tableRef.getPrimaryKey();
        if (pk != null) {
            this.createPrimaryKey(pk, baseTable, modelResource);
        }
        if ((uniqueConstraints = tableRef.getUniqueConstraints()) != null) {
            for (RelationalUniqueConstraint uc : uniqueConstraints) {
                this.createUniqueConstraint(uc, baseTable, modelResource);
            }
        }
        for (RelationalAccessPattern ap : tableRef.getAccessPatterns()) {
            this.createAccessPattern(ap, (Table)baseTable, modelResource);
        }
        for (RelationalForeignKey fk : tableRef.getForeignKeys()) {
            this.fkTableMap.put(fk, baseTable);
        }
        this.processExtensionProperties(modelResource, tableRef, (EObject)baseTable);
        return baseTable;
    }

    public EObject createView(RelationalReference ref, ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isInstanceOf(RelationalView.class, (Object)ref);
        RelationalView viewRef = (RelationalView)ref;
        View view = FACTORY.createView();
        view.setName(viewRef.getName());
        view.setSupportsUpdate(viewRef.getSupportsUpdate());
        view.setMaterialized(viewRef.isMaterialized());
        view.setNameInSource(viewRef.getNameInSource());
        view.setSystem(viewRef.isSystem());
        modelResource.getEmfResource().getContents().add((Object)view);
        if (viewRef.getDescription() != null) {
            this.createAnnotation((EObject)view, viewRef.getDescription(), modelResource);
        }
        for (RelationalColumn column : viewRef.getColumns()) {
            this.createColumn((RelationalReference)column, (Table)view, modelResource);
        }
        for (RelationalAccessPattern uc : viewRef.getAccessPatterns()) {
            this.createAccessPattern(uc, (Table)view, modelResource);
        }
        this.processExtensionProperties(modelResource, viewRef, (EObject)view);
        return view;
    }

    public EObject createColumn(RelationalReference ref, Table baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalColumn.class, (Object)ref);
        RelationalColumn columnRef = (RelationalColumn)ref;
        Column column = FACTORY.createColumn();
        column.setOwner((ColumnSet)baseTable);
        column.setName(columnRef.getName());
        column.setNameInSource(columnRef.getNameInSource());
        column.setAutoIncremented(columnRef.isAutoIncremented());
        column.setCaseSensitive(columnRef.isCaseSensitive());
        column.setCharacterSetName(columnRef.getCharacterSetName());
        column.setCollationName(columnRef.getCollationName());
        column.setCurrency(columnRef.isCurrency());
        column.setDefaultValue(columnRef.getDefaultValue());
        column.setDistinctValueCount(columnRef.getDistinctValueCount());
        column.setFixedLength(columnRef.isLengthFixed());
        column.setFormat(columnRef.getFormat());
        column.setLength(columnRef.getLength());
        column.setMaximumValue(columnRef.getMaximumValue());
        column.setMinimumValue(columnRef.getMinimumValue());
        column.setNativeType(columnRef.getNativeType());
        column.setNullable(this.getNullableType(columnRef.getNullable()));
        column.setNullValueCount(columnRef.getNullValueCount());
        column.setPrecision(columnRef.getPrecision());
        column.setRadix(columnRef.getRadix());
        column.setScale(columnRef.getScale());
        column.setSearchability(this.getSearchabilityType(columnRef.getSearchability()));
        column.setSelectable(columnRef.isSelectable());
        column.setSigned(columnRef.isSigned());
        column.setUpdateable(columnRef.isUpdateable());
        EObject datatype = this.datatypeProcessor.findDatatype(columnRef.getDatatype());
        if (datatype != null) {
            column.setType(datatype);
        }
        if (columnRef.getDescription() != null) {
            this.createAnnotation((EObject)column, columnRef.getDescription(), modelResource);
        }
        this.processExtensionProperties(modelResource, columnRef, (EObject)column);
        return column;
    }

    public EObject createColumn(RelationalReference ref, ProcedureResult procedureResult, ModelResource modelResource) {
        EObject datatype;
        CoreArgCheck.isInstanceOf(RelationalColumn.class, (Object)ref);
        RelationalColumn columnRef = (RelationalColumn)ref;
        Column column = FACTORY.createColumn();
        column.setOwner((ColumnSet)procedureResult);
        column.setName(columnRef.getName());
        column.setNameInSource(columnRef.getNameInSource());
        column.setAutoIncremented(columnRef.isAutoIncremented());
        column.setCaseSensitive(columnRef.isCaseSensitive());
        column.setCharacterSetName(columnRef.getCharacterSetName());
        column.setCollationName(columnRef.getCollationName());
        column.setCurrency(columnRef.isCurrency());
        column.setDefaultValue(columnRef.getDefaultValue());
        column.setDistinctValueCount(columnRef.getDistinctValueCount());
        column.setFixedLength(columnRef.isLengthFixed());
        column.setFormat(columnRef.getFormat());
        column.setLength(columnRef.getLength());
        column.setMaximumValue(columnRef.getMaximumValue());
        column.setMinimumValue(columnRef.getMinimumValue());
        column.setNativeType(columnRef.getNativeType());
        column.setNullable(this.getNullableType(columnRef.getNullable()));
        column.setNullValueCount(columnRef.getNullValueCount());
        column.setPrecision(columnRef.getPrecision());
        column.setRadix(columnRef.getRadix());
        column.setScale(columnRef.getScale());
        column.setSearchability(this.getSearchabilityType(columnRef.getSearchability()));
        column.setSelectable(columnRef.isSelectable());
        column.setSigned(columnRef.isSigned());
        column.setUpdateable(columnRef.isUpdateable());
        String dType = columnRef.getDatatype();
        if (dType == null || dType.length() == 0) {
            dType = "string";
        }
        if ((datatype = this.datatypeProcessor.findDatatype(dType)) != null) {
            column.setType(datatype);
            String dTypeName = ModelerCore.getModelEditor().getName(datatype);
            int datatypeLength = columnRef.getLength();
            if (datatypeLength == 0 && "string".equalsIgnoreCase(dTypeName)) {
                columnRef.setLength(255);
            } else {
                columnRef.setLength(datatypeLength);
            }
        }
        if (columnRef.getDescription() != null) {
            this.createAnnotation((EObject)column, columnRef.getDescription(), modelResource);
        }
        this.processExtensionProperties(modelResource, columnRef, (EObject)column);
        return column;
    }

    private NullableType getNullableType(String value) {
        if ("NULLABLE".equalsIgnoreCase(value)) {
            return NullableType.NULLABLE_LITERAL;
        }
        if ("NO_NULLS".equalsIgnoreCase(value)) {
            return NullableType.NO_NULLS_LITERAL;
        }
        return NullableType.NULLABLE_UNKNOWN_LITERAL;
    }

    private SearchabilityType getSearchabilityType(String value) {
        if ("UNSEARCHABLE".equalsIgnoreCase(value)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        if ("ALL_EXCEPT_LIKE".equalsIgnoreCase(value)) {
            return SearchabilityType.ALL_EXCEPT_LIKE_LITERAL;
        }
        if ("LIKE_ONLY".equalsIgnoreCase(value)) {
            return SearchabilityType.LIKE_ONLY_LITERAL;
        }
        return SearchabilityType.SEARCHABLE_LITERAL;
    }

    private void createPrimaryKey(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalPrimaryKey.class, (Object)ref);
        RelationalPrimaryKey pkRef = (RelationalPrimaryKey)ref;
        PrimaryKey primaryKey = FACTORY.createPrimaryKey();
        primaryKey.setTable(baseTable);
        primaryKey.setName(pkRef.getName());
        primaryKey.setNameInSource(pkRef.getNameInSource());
        EList keyColumns = primaryKey.getColumns();
        for (RelationalColumn relColumn : pkRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.processExtensionProperties(modelResource, pkRef, (EObject)primaryKey);
    }

    public void createForeignKey(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalForeignKey.class, (Object)ref);
        RelationalForeignKey fkRef = (RelationalForeignKey)ref;
        ForeignKey foreignKey = FACTORY.createForeignKey();
        foreignKey.setTable(baseTable);
        foreignKey.setName(fkRef.getName());
        foreignKey.setNameInSource(fkRef.getNameInSource());
        foreignKey.setForeignKeyMultiplicity(this.getMultiplictyKind(fkRef.getForeignKeyMultiplicity()));
        foreignKey.setPrimaryKeyMultiplicity(this.getMultiplictyKind(fkRef.getPrimaryKeyMultiplicity()));
        EList keyColumns = foreignKey.getColumns();
        for (RelationalColumn relColumn : fkRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        BaseTable fkTable = this.getTable(fkRef.getUniqueKeyTableName(), modelResource);
        String ukRefName = fkRef.getUniqueKeyName();
        if (fkTable != null && ukRefName != null) {
            if (fkTable.getPrimaryKey() != null && fkTable.getPrimaryKey().getName().equalsIgnoreCase(ukRefName)) {
                foreignKey.setUniqueKey((UniqueKey)fkTable.getPrimaryKey());
            } else if (fkTable.getUniqueConstraints().isEmpty()) {
                for (Object key : fkTable.getUniqueConstraints()) {
                    String keyName = ModelerCore.getModelEditor().getName((EObject)((UniqueKey)key));
                    if (!keyName.equalsIgnoreCase(ukRefName)) continue;
                    foreignKey.setUniqueKey((UniqueKey)key);
                }
            }
        }
        this.processExtensionProperties(modelResource, fkRef, (EObject)foreignKey);
    }

    private void createAccessPattern(RelationalReference ref, Table baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalAccessPattern.class, (Object)ref);
        RelationalAccessPattern apRef = (RelationalAccessPattern)ref;
        AccessPattern accessPattern = FACTORY.createAccessPattern();
        accessPattern.setTable(baseTable);
        accessPattern.setName(apRef.getName());
        accessPattern.setNameInSource(apRef.getNameInSource());
        EList keyColumns = accessPattern.getColumns();
        for (RelationalColumn relColumn : apRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.processExtensionProperties(modelResource, apRef, (EObject)accessPattern);
    }

    private void createUniqueConstraint(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalUniqueConstraint.class, (Object)ref);
        RelationalUniqueConstraint ucRef = (RelationalUniqueConstraint)ref;
        UniqueConstraint uniqueConstraint = FACTORY.createUniqueConstraint();
        uniqueConstraint.setTable(baseTable);
        uniqueConstraint.setName(ucRef.getName());
        uniqueConstraint.setNameInSource(ucRef.getNameInSource());
        EList keyColumns = uniqueConstraint.getColumns();
        for (RelationalColumn relColumn : ucRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.processExtensionProperties(modelResource, ucRef, (EObject)uniqueConstraint);
    }

    private Column getColumn(String name, Table baseTable) {
        for (Object column : baseTable.getColumns()) {
            if (!(column instanceof Column) || !((Column)column).getName().equalsIgnoreCase(name)) continue;
            return (Column)column;
        }
        return null;
    }

    private BaseTable getTable(String tableName, ModelResource modelResource) {
        try {
            for (EObject eObj : modelResource.getEmfResource().getContents()) {
                String eObjName = ModelerCore.getModelEditor().getName(eObj);
                if (!(eObj instanceof BaseTable) || eObjName == null || !eObjName.equalsIgnoreCase(tableName)) continue;
                return (BaseTable)eObj;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            RelationalPlugin.Util.log(4, NLS.bind((String)Messages.relationalModelFactory_error_finding_table_named, (Object)tableName));
        }
        return null;
    }

    public EObject createProcedure(RelationalReference ref, ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isInstanceOf(RelationalProcedure.class, (Object)ref);
        RelationalProcedure procedureRef = (RelationalProcedure)ref;
        Procedure procedure = FACTORY.createProcedure();
        procedure.setName(procedureRef.getName());
        procedure.setNameInSource(procedureRef.getNameInSource());
        procedure.setFunction(procedureRef.isFunction());
        procedure.setUpdateCount(this.getUpdateCount(procedureRef.getUpdateCount()));
        modelResource.getEmfResource().getContents().add((Object)procedure);
        if (procedureRef.getDescription() != null) {
            this.createAnnotation((EObject)procedure, procedureRef.getDescription(), modelResource);
        }
        for (RelationalParameter paramRef : procedureRef.getParameters()) {
            this.createParameter(paramRef, procedure, modelResource);
        }
        if (procedureRef.getResultSet() != null) {
            this.createResultSet(procedureRef.getResultSet(), procedure, modelResource);
        }
        this.processExtensionProperties(modelResource, procedureRef, (EObject)procedure);
        return procedure;
    }

    public EObject createParameter(RelationalReference ref, Procedure procedure, ModelResource modelResource) {
        EObject datatype;
        CoreArgCheck.isInstanceOf(RelationalParameter.class, (Object)ref);
        RelationalParameter parameterRef = (RelationalParameter)ref;
        ProcedureParameter parameter = FACTORY.createProcedureParameter();
        parameter.setProcedure(procedure);
        parameter.setName(parameterRef.getName());
        parameter.setNameInSource(parameterRef.getNameInSource());
        parameter.setDefaultValue(parameterRef.getDefaultValue());
        parameter.setDirection(this.getDirectionKind(parameterRef.getDirection()));
        parameter.setNativeType(parameterRef.getNativeType());
        parameter.setNullable(this.getNullableType(parameterRef.getNullable()));
        parameter.setPrecision(parameterRef.getPrecision());
        parameter.setRadix(parameterRef.getRadix());
        parameter.setScale(parameterRef.getScale());
        String dType = parameterRef.getDatatype();
        if (dType == null || dType.length() == 0) {
            dType = "string";
        }
        if ((datatype = this.datatypeProcessor.findDatatype(dType)) != null) {
            parameter.setType(datatype);
            String dTypeName = ModelerCore.getModelEditor().getName(datatype);
            int datatypeLength = parameterRef.getLength();
            if (datatypeLength == 0 && "string".equalsIgnoreCase(dTypeName)) {
                parameter.setLength(255);
            } else {
                parameter.setLength(datatypeLength);
            }
        }
        this.processExtensionProperties(modelResource, parameterRef, (EObject)parameter);
        return parameter;
    }

    protected void applyTableExtensionProperties(RelationalTable tableRef, BaseTable baseTable, boolean isVirtual) {
        if (isVirtual) {
            return;
        }
        RelationalModelExtensionAssistant assistant = this.getExtensionAssistant();
        if (assistant != null) {
            try {
                assistant.setPropertyValue((Object)baseTable, "relational:native-query", tableRef.getNativeQuery());
            }
            catch (Exception ex) {
                RelationalPlugin.Util.log(4, (Throwable)ex, NLS.bind((String)Messages.relationalModelFactory_error_setting_extension_props_on_0, (Object)tableRef.getName()));
            }
        }
    }

    protected void applyProcedureExtensionProperties(RelationalProcedure procedureRef, Procedure procedure) {
        RelationalModelExtensionAssistant assistant = this.getExtensionAssistant();
        if (assistant != null) {
            try {
                Collection extProps = assistant.getPropertyDefinitions((Object)procedure);
                for (ModelExtensionPropertyDefinition propDefn : extProps) {
                    String id = propDefn.getId();
                    if ("relational:non-prepared".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:non-prepared", Boolean.toString(procedureRef.isNonPrepared()));
                        continue;
                    }
                    if ("relational:native-query".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:native-query", procedureRef.getNativeQuery());
                        continue;
                    }
                    if ("relational:deterministic".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:deterministic", Boolean.toString(procedureRef.isDeterministic()));
                        continue;
                    }
                    if ("relational:null-on-null".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:null-on-null", Boolean.toString(procedureRef.isReturnsNullOnNull()));
                        continue;
                    }
                    if ("relational:varargs".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:varargs", Boolean.toString(procedureRef.isVariableArguments()));
                        continue;
                    }
                    if ("relational:aggregate".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:aggregate", Boolean.toString(procedureRef.isAggregate()));
                        continue;
                    }
                    if ("relational:allows-distinct".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:allows-distinct", Boolean.toString(procedureRef.isAllowsDistinct()));
                        continue;
                    }
                    if ("relational:allows-orderby".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:allows-orderby", Boolean.toString(procedureRef.isAllowsOrderBy()));
                        continue;
                    }
                    if ("relational:analytic".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:analytic", Boolean.toString(procedureRef.isAnalytic()));
                        continue;
                    }
                    if ("relational:decomposable".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:decomposable", Boolean.toString(procedureRef.isDecomposable()));
                        continue;
                    }
                    if ("relational:java-class".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:java-class", procedureRef.getJavaClassName());
                        continue;
                    }
                    if ("relational:uses-distinct-rows".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:uses-distinct-rows", Boolean.toString(procedureRef.isUseDistinctRows()));
                        continue;
                    }
                    if ("relational:java-method".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:java-method", procedureRef.getJavaMethodName());
                        continue;
                    }
                    if ("relational:udfJarPath".equals(id)) {
                        assistant.setPropertyValue((Object)procedure, "relational:udfJarPath", procedureRef.getUdfJarPath());
                        continue;
                    }
                    if (!"relational:function-category".equals(id)) continue;
                    assistant.setPropertyValue((Object)procedure, "relational:function-category", procedureRef.getFunctionCategory());
                }
            }
            catch (Exception ex) {
                RelationalPlugin.Util.log(4, (Throwable)ex, NLS.bind((String)Messages.relationalModelFactory_error_setting_extension_props_on_0, (Object)procedureRef.getName()));
            }
        }
    }

    public EObject createResultSet(RelationalReference ref, Procedure procedure, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalProcedureResultSet.class, (Object)ref);
        RelationalProcedureResultSet resultSetRef = (RelationalProcedureResultSet)ref;
        ProcedureResult result = FACTORY.createProcedureResult();
        result.setProcedure(procedure);
        result.setName(resultSetRef.getName());
        result.setNameInSource(resultSetRef.getNameInSource());
        if (resultSetRef.getDescription() != null) {
            this.createAnnotation((EObject)result, resultSetRef.getDescription(), modelResource);
        }
        for (RelationalColumn colRef : resultSetRef.getColumns()) {
            this.createColumn((RelationalReference)colRef, result, modelResource);
        }
        this.processExtensionProperties(modelResource, resultSetRef, (EObject)result);
        return result;
    }

    public EObject createIndex(RelationalReference ref, ModelResource modelResource) throws ModelWorkspaceException {
        CoreArgCheck.isInstanceOf(RelationalIndex.class, (Object)ref);
        RelationalIndex indexRef = (RelationalIndex)ref;
        Index index = FACTORY.createIndex();
        index.setName(indexRef.getName());
        index.setNameInSource(index.getNameInSource());
        index.setFilterCondition(indexRef.getFilterCondition());
        index.setAutoUpdate(indexRef.isAutoUpdate());
        index.setNullable(indexRef.isNullable());
        index.setUnique(indexRef.isUnique());
        modelResource.getEmfResource().getContents().add((Object)index);
        if (indexRef.getDescription() != null) {
            this.createAnnotation((EObject)index, indexRef.getDescription(), modelResource);
        }
        EList indexColumns = index.getColumns();
        for (RelationalColumn relColumn : indexRef.getColumns()) {
            BaseTable baseTable = this.getTable(relColumn.getParent().getName(), modelResource);
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            indexColumns.add(column);
        }
        this.processExtensionProperties(modelResource, indexRef, (EObject)index);
        return index;
    }

    private DirectionKind getDirectionKind(String value) {
        if ("IN".equalsIgnoreCase(value)) {
            return DirectionKind.IN_LITERAL;
        }
        if ("IN_OUT".equalsIgnoreCase(value)) {
            return DirectionKind.INOUT_LITERAL;
        }
        if ("OUT".equalsIgnoreCase(value)) {
            return DirectionKind.OUT_LITERAL;
        }
        if ("RETURN".equalsIgnoreCase(value)) {
            return DirectionKind.RETURN_LITERAL;
        }
        return DirectionKind.UNKNOWN_LITERAL;
    }

    private ProcedureUpdateCount getUpdateCount(String value) {
        if (ProcedureUpdateCount.AUTO_LITERAL.getName().equalsIgnoreCase(value)) {
            return ProcedureUpdateCount.AUTO_LITERAL;
        }
        if (ProcedureUpdateCount.ONE_LITERAL.getName().equalsIgnoreCase(value)) {
            return ProcedureUpdateCount.ONE_LITERAL;
        }
        if (ProcedureUpdateCount.MULTIPLE_LITERAL.getName().equalsIgnoreCase(value)) {
            return ProcedureUpdateCount.MULTIPLE_LITERAL;
        }
        if (ProcedureUpdateCount.ZERO_LITERAL.getName().equalsIgnoreCase(value)) {
            return ProcedureUpdateCount.ZERO_LITERAL;
        }
        return ProcedureUpdateCount.AUTO_LITERAL;
    }

    private MultiplicityKind getMultiplictyKind(String value) {
        if (MultiplicityKind.MANY_LITERAL.getName().equalsIgnoreCase(value)) {
            return MultiplicityKind.MANY_LITERAL;
        }
        if (MultiplicityKind.ONE_LITERAL.getName().equalsIgnoreCase(value)) {
            return MultiplicityKind.ONE_LITERAL;
        }
        if (MultiplicityKind.ZERO_TO_ONE_LITERAL.getName().equalsIgnoreCase(value)) {
            return MultiplicityKind.ZERO_TO_ONE_LITERAL;
        }
        if (MultiplicityKind.ZERO_TO_MANY_LITERAL.getName().equalsIgnoreCase(value)) {
            return MultiplicityKind.ZERO_TO_MANY_LITERAL;
        }
        return MultiplicityKind.UNSPECIFIED_LITERAL;
    }

    public void createAnnotation(EObject eObject, String description, ModelResource modelResource) {
        if (description != null && description.trim().length() > 0) {
            try {
                Annotation annotation;
                AnnotationContainer annotations = null;
                for (Object next : modelResource.getEmfResource().getContents()) {
                    if (!(next instanceof AnnotationContainer)) continue;
                    annotations = (AnnotationContainer)next;
                    break;
                }
                if (annotations == null) {
                    annotations = CoreFactory.eINSTANCE.createAnnotationContainer();
                    modelResource.getEmfResource().getContents().add((Object)annotations);
                }
                if ((annotation = annotations.findAnnotation(eObject)) == null) {
                    annotation = CoreFactory.eINSTANCE.createAnnotation();
                    annotations.getAnnotations().add((Object)annotation);
                    annotation.setAnnotatedObject(eObject);
                }
                annotation.setDescription(description);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                RelationalPlugin.Util.log(4, NLS.bind((String)Messages.relationalModelFactory_error_adding_desciption_to_0, (Object)eObject));
            }
        }
    }

    public RelationalReference getRelationalObject(EObject eObject) {
        if (eObject instanceof BaseTable) {
            BaseTable theTable = (BaseTable)eObject;
            String name = ModelerCore.getModelEditor().getName(eObject);
            RelationalTable relTable = new RelationalTable(name);
            relTable.setSupportsUpdate(theTable.isSupportsUpdate());
            relTable.setMaterialized(theTable.isMaterialized());
            relTable.setNameInSource(theTable.getNameInSource());
            relTable.setSystem(theTable.isSystem());
            relTable.setCardinality(theTable.getCardinality());
            EList tableColumns = theTable.getColumns();
            for (EObject column : tableColumns) {
                relTable.addColumn((RelationalColumn)this.getRelationalObject(column));
            }
            this.transferDescription((EObject)theTable, relTable);
            return relTable;
        }
        if (!(eObject instanceof View) && !(eObject instanceof Procedure)) {
            if (eObject instanceof Index) {
                Index theIndex = (Index)eObject;
                String name = ModelerCore.getModelEditor().getName(eObject);
                RelationalIndex relIndex = new RelationalIndex(name);
                relIndex.setNameInSource(theIndex.getNameInSource());
                relIndex.setFilterCondition(theIndex.getFilterCondition());
                relIndex.setAutoUpdate(theIndex.isAutoUpdate());
                relIndex.setNullable(theIndex.isNullable());
                relIndex.setUnique(theIndex.isUnique());
                this.transferDescription((EObject)theIndex, relIndex);
                EList indexColumns = theIndex.getColumns();
                for (EObject column : indexColumns) {
                    relIndex.addColumn((RelationalColumn)this.getRelationalObject(column));
                }
                return relIndex;
            }
            if (eObject instanceof Column) {
                Column theColumn = (Column)eObject;
                String name = ModelerCore.getModelEditor().getName((EObject)theColumn);
                RelationalColumn relColumn = new RelationalColumn(name);
                this.transferDescription((EObject)theColumn, relColumn);
                return relColumn;
            }
        }
        return null;
    }

    private void transferDescription(EObject eObject, RelationalReference relationalRef) {
        try {
            String desc = ModelerCore.getModelEditor().getDescription(eObject);
            if (desc != null) {
                relationalRef.setDescription(desc);
            }
        }
        catch (ModelerCoreException ex) {
            ex.printStackTrace();
        }
    }

    private void processExtensionProperties(ModelResource modelResource, RelationalReference relationalEntity, EObject eObject) {
        Properties extensionProperties = relationalEntity.getExtensionProperties();
        for (String string : extensionProperties.keySet()) {
            String propValue = extensionProperties.getProperty(string);
            ModelObjectExtensionAssistant assistant = this.getModelExtensionAssistant(eObject.getClass().getName(), string);
            if (assistant == null) continue;
            try {
                this.applyMedIfNecessary(modelResource, assistant);
            }
            catch (Exception exception) {}
            String namespacedId = null;
            try {
                namespacedId = String.valueOf(assistant.getNamespacePrefix()) + ':' + string;
                assistant.setPropertyValue((Object)eObject, namespacedId, propValue);
            }
            catch (Exception exception) {}
        }
    }

    private void applyMedIfNecessary(ModelResource modelResource, ModelObjectExtensionAssistant assistant) throws Exception {
        if (modelResource != null && !modelResource.isReadOnly() && !assistant.supportsMyNamespace((Object)modelResource)) {
            assistant.saveModelExtensionDefinition((Object)modelResource);
        }
    }

    private ModelObjectExtensionAssistant getModelExtensionAssistant(String eObjectClassName, String propId) {
        Collection<ModelObjectExtensionAssistant> assistants = null;
        if (this.classNameToMedAssistantsMap.containsKey(eObjectClassName)) {
            assistants = this.classNameToMedAssistantsMap.get(eObjectClassName);
        } else {
            Collection collection = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistants(eObjectClassName);
            assistants = new ArrayList<ModelObjectExtensionAssistant>();
            for (ModelExtensionAssistant medAssistant : collection) {
                if (!(medAssistant instanceof ModelObjectExtensionAssistant)) continue;
                assistants.add((ModelObjectExtensionAssistant)medAssistant);
            }
            this.classNameToMedAssistantsMap.put(eObjectClassName, assistants);
        }
        if (assistants.isEmpty()) {
            return null;
        }
        for (ModelExtensionAssistant modelExtensionAssistant : assistants) {
            String namespacedId = String.valueOf(modelExtensionAssistant.getNamespacePrefix()) + ':' + propId;
            if (!this.hasMatchingPropertyName(modelExtensionAssistant.getModelExtensionDefinition(), eObjectClassName, namespacedId)) continue;
            return modelExtensionAssistant instanceof ModelObjectExtensionAssistant ? (ModelObjectExtensionAssistant)modelExtensionAssistant : null;
        }
        return null;
    }

    private boolean hasMatchingPropertyName(ModelExtensionDefinition med, String metaclassName, String propId) {
        ModelExtensionPropertyDefinition propDefn = med.getPropertyDefinition(metaclassName, propId);
        return propDefn != null;
    }
}

