/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview.jobs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.WorkspacePreviewVdbJob;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.XmiVdb;

public final class UpdatePreviewVdbJob
extends WorkspacePreviewVdbJob {
    private final IFile model;
    private final ITeiidServer previewServer;
    private final IFile pvdbFile;

    public UpdatePreviewVdbJob(IFile changedModel, ITeiidServer previewServer, PreviewContext context) throws Exception {
        super(NLS.bind((String)Messages.UpdatePreviewVdbJob, (Object)changedModel.getFullPath().removeFileExtension()), context);
        this.model = changedModel;
        this.previewServer = previewServer;
        this.pvdbFile = this.getContext().getPreviewVdb((IResource)this.model);
        ISchedulingRule[] rules = new ISchedulingRule[]{this.getSchedulingRuleFactory().modifyRule((IResource)this.pvdbFile), this.getSchedulingRuleFactory().buildRule()};
        this.setRule(MultiRule.combine((ISchedulingRule[])rules));
    }

    public IFile getModel() {
        return this.model;
    }

    @Override
    public IFile getPreviewVdb() {
        return this.pvdbFile;
    }

    public ITeiidServer getPreviewServer() {
        return this.previewServer;
    }

    @Override
    protected IStatus runImpl(IProgressMonitor monitor) throws Exception {
        Status status = null;
        XmiVdb pvdb = new XmiVdb(this.pvdbFile, true);
        if (this.previewServer == null || !this.previewServer.isConnected()) {
            return Status.OK_STATUS;
        }
        try {
            this.getContext().ensureConnectionInfoIsValid((Vdb)pvdb, this.previewServer);
        }
        catch (Exception e) {
            status = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.UpdatePreviewVdbJobError, (Object)this.model.getFullPath()), (Throwable)e);
        }
        try {
            if (!pvdb.isSynchronized()) {
                pvdb.synchronize();
                pvdb.save();
            } else if (pvdb.isModified()) {
                pvdb.save();
            }
            if (status == null) {
                status = new Status(0, "org.teiid.designer.dqp", NLS.bind((String)Messages.UpdatePreviewVdbJobSuccessfullyCompleted, (Object)this.pvdbFile.getFullPath()));
            }
        }
        catch (Exception e) {
            Status syncStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.UpdatePreviewVdbJobError, (Object)this.model.getFullPath()), (Throwable)e);
            if (status == null) {
                status = syncStatus;
            }
            IStatus[] statuses = new IStatus[]{status, syncStatus};
            status = new MultiStatus("org.teiid.designer.dqp", 4, statuses, NLS.bind((String)Messages.UpdatePreviewVdbJobError, (Object)this.model.getFullPath()), null);
        }
        return status;
    }
}

