/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.preview;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.util.CoreModelObjectNotificationHelper;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.datatools.JdbcTranslatorHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidDataSourceFactory;
import org.teiid.designer.runtime.preview.Messages;
import org.teiid.designer.runtime.preview.PreviewContext;
import org.teiid.designer.runtime.preview.jobs.CompositePreviewJob;
import org.teiid.designer.runtime.preview.jobs.CreatePreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.DeleteDeployedPreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.DeletePreviewVdbJob;
import org.teiid.designer.runtime.preview.jobs.ModelChangedJob;
import org.teiid.designer.runtime.preview.jobs.ModelProjectOpenedJob;
import org.teiid.designer.runtime.preview.jobs.UpdatePreviewVdbJob;
import org.teiid.designer.runtime.spi.ExecutionConfigurationEvent;
import org.teiid.designer.runtime.spi.FailedTeiidDataSource;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidVdb;
import org.teiid.designer.runtime.spi.TeiidExecutionException;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.VdbSourceInfo;
import org.teiid.designer.vdb.VdbUtil;
import org.teiid.designer.vdb.XmiVdb;

@ThreadSafe
public final class PreviewManager
extends JobChangeAdapter
implements IExecutionConfigurationListener,
IEclipsePreferences.IPreferenceChangeListener,
IResourceChangeListener,
INotifyChangedListener,
PreviewContext {
    private static final String PROJECT_VDB_SUFFIX = "_project";
    String projectPreviewVdbName = null;
    private boolean previewEnabled = true;
    private volatile AtomicReference<ITeiidServer> previewServer = new AtomicReference();
    @GuardedBy(value="statusLock")
    private Map<IPath, Set<PreviewVdbStatus>> deploymentStatusMap = new HashMap<IPath, Set<PreviewVdbStatus>>();
    private final ReadWriteLock statusLock = new ReentrantReadWriteLock();
    private boolean retryOnNextRefreshOfServer;
    private static PreviewManager instance;

    public void addPreviewVdbImports(Vdb targetVdb, List<IFile> modelPreviewVdbs) throws Exception {
        for (IFile previewVdbFile : modelPreviewVdbs) {
            if (targetVdb.getSourceFile().equals((Object)previewVdbFile)) continue;
            String modelPreviewVdbName = previewVdbFile.getFullPath().removeFileExtension().lastSegment().toString();
            targetVdb.addImport(modelPreviewVdbName);
        }
    }

    public void addPreviewSourceVdbImports(Vdb vdb, IProject currentModelProject) throws Exception {
        List<IResource> filesInProject = this.getVdbSourceResourcesForProject(currentModelProject);
        for (IResource fileInProject : filesInProject) {
            ModelResource mr = ModelUtil.getModelResource((IFile)((IFile)fileInProject), (boolean)true);
            if (mr == null || !ModelUtil.isVdbSourceObject((Object)fileInProject)) continue;
            String vdbName = this.getVdbSourceModelVdbName(mr);
            vdb.addImport(vdbName);
        }
    }

    private boolean dependsOn(IFile modelFile, IFile pvdbFile) throws Exception {
        assert (ModelUtil.isVdbArchiveFile((IResource)pvdbFile)) : "IFile is not a VDB";
        XmiVdb pvdb = new XmiVdb(pvdbFile);
        Set models = pvdb.getModelEntries();
        if (!models.isEmpty()) {
            IFile file = ((VdbModelEntry)models.iterator().next()).findFileInWorkspace();
            for (IResource dependency : WorkspaceResourceFinderUtil.getDependentResources((IResource)modelFile)) {
                if (!dependency.equals((Object)file)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPreviewProjectVdbName(IProject project) {
        assert (project != null) : "Project is null";
        StringBuilder name = new StringBuilder(XmiVdb.getPreviewVdbPrefix((IResource)project));
        String vdbName = name.append(project.getName()).append(PROJECT_VDB_SUFFIX).toString();
        if (vdbName.contains(" ")) {
            vdbName = vdbName.replaceAll(" ", "_");
        }
        return vdbName;
    }

    public static int getPreviewVdbVersion(IFile pvdbFile) throws Exception {
        assert (pvdbFile != null) : "PVDB is null";
        assert (ModelUtil.isVdbArchiveFile((IResource)pvdbFile)) : "IFile is not a VDB";
        return VdbUtil.getVdbVersion((IFile)pvdbFile);
    }

    public static boolean isPreviewableResource(IFile file) {
        if (ModelUtil.isModelFile((IResource)file)) {
            if (ModelUtil.isXsdFile((IResource)file)) {
                return true;
            }
            String metamodelUri = null;
            File modelFile = file.getFullPath().toFile();
            if (modelFile.exists()) {
                XMIHeader header = ModelFileUtil.getXmiHeader((File)modelFile);
                metamodelUri = header.getPrimaryMetamodelURI();
            } else {
                MetamodelDescriptor descriptor;
                block9: {
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)file, (boolean)true);
                        assert (modelResource != null);
                        descriptor = ModelerCore.getModelEditor().getPrimaryMetamodelDescriptor(modelResource);
                        if (descriptor != null) break block9;
                        return false;
                    }
                    catch (ModelWorkspaceException e) {
                        DqpPlugin.Util.log((Throwable)e);
                        return false;
                    }
                }
                metamodelUri = descriptor.getNamespaceURI();
            }
            if ("http://www.metamatrix.com/metamodels/Relational".equals(metamodelUri) || "http://www.metamatrix.com/metamodels/WebService".equals(metamodelUri) || "http://www.metamatrix.com/metamodels/XmlDocument".equals(metamodelUri) || "http://www.metamatrix.com/metamodels/MetaMatrixFunction".equals(metamodelUri)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isProjectPreviewVdb(IFile pvdbFile) throws Exception {
        if (PreviewManager.isPreviewVdb((IResource)pvdbFile)) {
            return pvdbFile.getFullPath().removeFileExtension().toString().endsWith("tion");
        }
        return false;
    }

    private static boolean isPreviewVdb(IResource resource) throws Exception {
        if (ModelUtil.isVdbArchiveFile((IResource)resource)) {
            return VdbUtil.isPreviewVdb((IFile)((IFile)resource));
        }
        return false;
    }

    public static PreviewManager getInstance() {
        if (instance == null) {
            instance = new PreviewManager();
        }
        return instance;
    }

    private PreviewManager() {
        this.startup();
    }

    private void addWorkspacePvdb(IFile pvdb) {
        IPath projectPath = pvdb.getProject().getFullPath();
        try {
            this.statusLock.writeLock().lock();
            Set<PreviewVdbStatus> statuses = this.deploymentStatusMap.get(projectPath);
            if (statuses == null) {
                statuses = new HashSet<PreviewVdbStatus>();
                this.deploymentStatusMap.put(projectPath, statuses);
            }
            statuses.add(new PreviewVdbStatus(pvdb));
        }
        finally {
            this.statusLock.writeLock().unlock();
        }
    }

    IStatus checkPreviewVdbForErrors(Vdb pvdb) {
        Set modelEntries = pvdb.getModelEntries();
        if (!modelEntries.isEmpty()) {
            try {
                IFile modelFile = ((VdbModelEntry)modelEntries.iterator().next()).findFileInWorkspace();
                IMarker[] iMarkerArray = modelFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int severity;
                    IMarker marker = iMarkerArray[n2];
                    Object attr = marker.getAttribute("severity");
                    if (attr != null && (severity = ((Integer)attr).intValue()) == 2) {
                        return new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ModelErrorMarkerExists, (Object)marker.getAttribute("message", "")));
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                return new Status(4, "org.teiid.designer.dqp", Messages.UnexpectedErrorGettingVdbMarkers, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public void configurationChanged(ExecutionConfigurationEvent event) {
        if (event.getEventType().equals((Object)ExecutionConfigurationEvent.EventType.DEFAULT) && event.getTargetType().equals((Object)ExecutionConfigurationEvent.TargetType.SERVER)) {
            this.setPreviewServer(event.getUpdatedServer());
        } else if (event.getEventType().equals((Object)ExecutionConfigurationEvent.EventType.REFRESH) && this.retryOnNextRefreshOfServer) {
            try {
                this.startup();
            }
            catch (Exception exception) {}
        } else if (event.getEventType().equals((Object)ExecutionConfigurationEvent.EventType.REMOVE) && event.getTargetType().equals((Object)ExecutionConfigurationEvent.TargetType.VDB)) {
            this.resetAllDeployedStatuses();
        } else if (event.getEventType().equals((Object)ExecutionConfigurationEvent.EventType.CONNECTED)) {
            try {
                this.cleanServer((IProgressMonitor)new NullProgressMonitor(), event.getServer());
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
            }
        }
    }

    private Job createDeleteDeployedPreviewVdbJob(IPath pvdbPath) {
        this.getFile(pvdbPath);
        String jndiName = this.getPreviewVdbJndiName(pvdbPath);
        DeleteDeployedPreviewVdbJob job = new DeleteDeployedPreviewVdbJob(this.getPreviewVdbDeployedName(pvdbPath), jndiName, this, this.getPreviewServer());
        return job;
    }

    private void deleteWorkspacePvdb(IPath pvdbPath) {
        IPath projectPath = this.getProjectPath(pvdbPath);
        try {
            this.statusLock.writeLock().lock();
            Collection statuses = this.deploymentStatusMap.get(projectPath);
            for (PreviewVdbStatus status : statuses) {
                if (!status.getPath().equals((Object)pvdbPath)) continue;
                statuses.remove(status);
                break;
            }
        }
        finally {
            this.statusLock.writeLock().unlock();
        }
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        job.removeJobChangeListener((IJobChangeListener)this);
        IStatus status = job.getResult();
        if (status == null || status.getSeverity() == 8) {
            return;
        }
        if (status.getSeverity() == 4) {
            DqpPlugin.Util.log(job.getResult());
        } else {
            if (job instanceof CreatePreviewVdbJob) {
                this.handlePreviewVdbCreated((CreatePreviewVdbJob)job);
            } else if (job instanceof DeletePreviewVdbJob) {
                this.handlePreviewVdbDeleted((DeletePreviewVdbJob)job);
            } else if (job instanceof UpdatePreviewVdbJob) {
                this.handlePreviewVdbUpdated((UpdatePreviewVdbJob)job);
            } else if (job instanceof ModelProjectOpenedJob) {
                this.handleModelProjectOpened((ModelProjectOpenedJob)job);
            }
            if (status.getSeverity() != 0) {
                DqpPlugin.Util.log(job.getResult());
            }
        }
    }

    @Override
    public IStatus ensureConnectionInfoIsValid(Vdb previewVdb, ITeiidServer previewServer) throws Exception {
        boolean resourceHasLoopback;
        boolean isSourceModel;
        assert (previewServer != null) : "Preview server is null";
        if (previewVdb.getModelEntries().isEmpty()) {
            return Status.OK_STATUS;
        }
        VdbModelEntry modelEntry = (VdbModelEntry)previewVdb.getModelEntries().iterator().next();
        IFile model = modelEntry.findFileInWorkspace();
        ModelResource modelResource = ModelUtil.getModelResource((IFile)model, (boolean)true);
        boolean bl = isSourceModel = modelResource.getModelType() == ModelType.PHYSICAL_LITERAL;
        if (!isSourceModel) {
            return Status.OK_STATUS;
        }
        Status connectionInfoError = null;
        ConnectionInfoHelper helper = new ConnectionInfoHelper();
        if (helper.hasConnectionInfo(modelResource)) {
            String srcJndiName = helper.getJndiProperty(modelResource);
            String translatorName = helper.getTranslatorName(modelResource);
            if (!"loopback".equals(translatorName)) {
                if (!CoreStringUtil.isEmpty((String)srcJndiName)) {
                    modelEntry.setJndiName(0, srcJndiName);
                } else {
                    String jndiName = this.getPreviewVdbJndiName(previewVdb.getSourceFile().getFullPath());
                    if (!previewServer.dataSourceExists(jndiName)) {
                        TeiidDataSourceFactory factory = new TeiidDataSourceFactory();
                        ITeiidDataSource theDataSource = null;
                        try {
                            theDataSource = factory.createDataSource(previewServer, model, jndiName, true);
                        }
                        catch (TeiidExecutionException ex) {
                            switch (ex.getCode()) {
                                case 101: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", ex.getMessage(), null);
                                    break;
                                }
                                case 102: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", ex.getMessage(), null);
                                    break;
                                }
                                case 103: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", ex.getMessage(), null);
                                    break;
                                }
                            }
                        }
                        if (theDataSource instanceof FailedTeiidDataSource) {
                            FailedTeiidDataSource fds = (FailedTeiidDataSource)theDataSource;
                            switch (fds.getReasonCode()) {
                                case 104: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", "No connection provider associated with model: '" + fds.getModelName() + "'. Could not create data source", null);
                                    break;
                                }
                                case 105: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", "No connection profile associated with model: '" + fds.getModelName() + "'. Could not create data source", null);
                                    break;
                                }
                                case 106: {
                                    connectionInfoError = new Status(4, "org.teiid.designer.dqp", "No Teiid connection properties associated with model: '" + fds.getModelName() + "'. Could not create data source", null);
                                }
                            }
                        }
                    }
                    if (!jndiName.equals(this.getSourceJndiName(modelEntry))) {
                        modelEntry.setJndiName(0, jndiName);
                    }
                }
            }
        } else {
            connectionInfoError = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ModelDoesNotHaveConnectionInfoError, (Object)model.getFullPath()), null);
        }
        String vdbSrcTranslatorName = this.getSourceTranslatorName(modelEntry);
        String resourceTranslatorName = helper.getTranslatorName(modelResource);
        boolean modelEntryHasLoopback = CoreStringUtil.isEmpty((String)vdbSrcTranslatorName) || vdbSrcTranslatorName.equalsIgnoreCase("loopback");
        boolean bl2 = resourceHasLoopback = !CoreStringUtil.isEmpty((String)resourceTranslatorName) && resourceTranslatorName.equalsIgnoreCase("loopback");
        if (modelEntryHasLoopback && !resourceHasLoopback) {
            IConnectionProfile connectionProfile = helper.getConnectionProfile(modelResource);
            if (connectionProfile == null) {
                modelEntry.setTranslatorName(0, "loopback");
            } else {
                modelEntry.setTranslatorName(0, JdbcTranslatorHelper.getTranslator((IConnectionProfile)connectionProfile));
            }
        }
        return connectionInfoError == null ? Status.OK_STATUS : connectionInfoError;
    }

    private void fileDeleted(IFile file) {
        if (ModelUtil.isModelFile((IPath)file.getFullPath())) {
            try {
                IFile pvdbFile = this.getPreviewVdb((IResource)file);
                if (pvdbFile != null && pvdbFile.exists()) {
                    DeletePreviewVdbJob job = new DeletePreviewVdbJob(this, file);
                    job.addJobChangeListener((IJobChangeListener)this);
                    job.schedule();
                } else {
                    DeleteDeployedPreviewVdbJob job = new DeleteDeployedPreviewVdbJob(this.getPreviewVdbDeployedName(pvdbFile), this.getPreviewVdbJndiName(pvdbFile), this, this.getPreviewServer());
                    job.schedule();
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log(4, (Throwable)e, NLS.bind((String)Messages.DeletedModelProcessingError, (Object)file.getFullPath()));
            }
        }
    }

    List<IFile> findProjectPvdbs(IProject project, boolean onlyThoseNeedingToBeDeployed) {
        ArrayList<IFile> pvdbsToDeploy = new ArrayList<IFile>();
        Collection statuses = null;
        try {
            this.statusLock.readLock().lock();
            statuses = (ArrayList)((Object)this.deploymentStatusMap.get(project.getFullPath()));
            if (statuses != null && !statuses.isEmpty()) {
                statuses = new ArrayList(statuses);
            }
        }
        finally {
            this.statusLock.readLock().unlock();
        }
        if (statuses != null && !statuses.isEmpty()) {
            ArrayList<PreviewVdbStatus> missingPvdbs = new ArrayList<PreviewVdbStatus>();
            for (PreviewVdbStatus status : statuses) {
                IFile pvdbFile = status.getFile();
                if (pvdbFile.exists()) {
                    if (!onlyThoseNeedingToBeDeployed) {
                        pvdbsToDeploy.add(this.getPreviewVdb((IResource)status.getFile()));
                        continue;
                    }
                    if (!this.needsToBeDeployed(pvdbFile)) continue;
                    pvdbsToDeploy.add(this.getPreviewVdb((IResource)pvdbFile));
                    continue;
                }
                missingPvdbs.add(status);
            }
            if (!missingPvdbs.isEmpty()) {
                DqpPlugin.Util.log((Object)Messages.DeployStatusCacheError);
                try {
                    this.statusLock.writeLock().lock();
                    statuses = this.deploymentStatusMap.get(project.getFullPath());
                    for (PreviewVdbStatus status : missingPvdbs) {
                        statuses.remove(status);
                    }
                }
                finally {
                    this.statusLock.writeLock().unlock();
                }
            }
        }
        return pvdbsToDeploy;
    }

    private void findPvdbs(IContainer container, List<IPath> pvdbPaths) throws Exception {
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return;
        }
        IResource[] iResourceArray = container.members(8);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IContainer) {
                this.findPvdbs((IContainer)resource, pvdbPaths);
            } else if (PreviewManager.isPreviewVdb(resource)) {
                pvdbPaths.add(resource.getFullPath());
            }
            ++n2;
        }
    }

    private IFile getFile(IPath path) {
        return ModelerCore.getWorkspace().getRoot().getFile(path);
    }

    private String getFullDeployedVdbName(ITeiidVdb deployedVdb) {
        String fullVdbName = deployedVdb.getDeployedName();
        if (!fullVdbName.endsWith(".vdb")) {
            fullVdbName = String.valueOf(fullVdbName) + ".vdb";
        }
        return fullVdbName;
    }

    ITeiidServer getPreviewServer() {
        return this.previewServer.get();
    }

    @Override
    public IFile getPreviewVdb(IResource projectOrModel) {
        IFile pvdb = null;
        IPath pathToPvdb = null;
        String pvdbName = this.getPreviewVdbName(projectOrModel);
        if (projectOrModel instanceof IProject) {
            pathToPvdb = projectOrModel.getFullPath().append(pvdbName);
        } else {
            assert (projectOrModel instanceof IFile) : "Resource is not a file:" + projectOrModel.getFullPath();
            pathToPvdb = projectOrModel.getParent().getFullPath().append(pvdbName);
        }
        pvdb = this.getFile(pathToPvdb);
        return pvdb;
    }

    private String getPreviewVdbDeployedName(IFile pvdb) {
        return this.getPreviewVdbDeployedName(pvdb.getFullPath());
    }

    @Override
    public String getPreviewVdbDeployedName(IPath pvdbPath) {
        return pvdbPath.removeFileExtension().lastSegment();
    }

    private String getPreviewVdbJndiName(IFile pvdb) {
        return this.getPreviewVdbJndiName(pvdb.getFullPath());
    }

    @Override
    public String getPreviewVdbJndiName(IPath pvdbPath) {
        return this.getPreviewVdbDeployedName(pvdbPath);
    }

    private String getPreviewVdbJndiName(String pvdbName) {
        int index = pvdbName.lastIndexOf(46);
        if (index == -1) {
            return pvdbName;
        }
        String jndiName = pvdbName.substring(0, index);
        if (jndiName.contains(" ")) {
            jndiName = jndiName.replaceAll(" ", "_");
        }
        return jndiName;
    }

    private String getResourceNameForPreviewVdb(IFile pvdbFile) {
        String prefix;
        if (pvdbFile.getFullPath().removeFileExtension().lastSegment().endsWith(PROJECT_VDB_SUFFIX)) {
            String projectVdbName = pvdbFile.getProject().getName();
            if (projectVdbName.contains(" ")) {
                projectVdbName = projectVdbName.replaceAll(" ", "_");
            }
            return projectVdbName;
        }
        String name = FileUtils.getNameWithoutExtension((IResource)pvdbFile);
        int index = name.indexOf(prefix = XmiVdb.getPreviewVdbPrefix((IResource)pvdbFile));
        if (index == -1) {
            return name;
        }
        return name.substring(index + prefix.length());
    }

    private String getPreviewVdbName(IResource projectOrModel) {
        StringBuilder name = null;
        if (projectOrModel instanceof IProject) {
            name = new StringBuilder(PreviewManager.getPreviewProjectVdbName((IProject)projectOrModel));
        } else {
            String vdbName;
            assert (projectOrModel instanceof IFile) : "IResource is not an IFile";
            String prefix = XmiVdb.getPreviewVdbPrefix((IResource)projectOrModel);
            if (projectOrModel.getFileExtension().equalsIgnoreCase("vdb") && (vdbName = FileUtils.getNameWithoutExtension((IResource)projectOrModel)).startsWith(prefix)) {
                return projectOrModel.getFullPath().lastSegment();
            }
            name = new StringBuilder(prefix);
            name.append(projectOrModel.getFullPath().removeFileExtension().lastSegment());
        }
        name.append(".vdb");
        return name.toString();
    }

    private IPath getProjectPath(IPath pvdbPath) {
        return pvdbPath.uptoSegment(1);
    }

    private List<IResource> getVdbSourceResourcesForProject(IProject project) throws Exception {
        ModelResource[] mrs = ModelWorkspaceManager.getModelWorkspaceManager().getModelWorkspace().getModelResources();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ModelResource[] modelResourceArray = mrs;
        int n = mrs.length;
        int n2 = 0;
        while (n2 < n) {
            ModelResource mr = modelResourceArray[n2];
            if (mr.getModelProject().getProject().equals((Object)project) && ModelUtil.isVdbSourceObject((Object)mr)) {
                resources.add(mr.getCorrespondingResource());
            }
            ++n2;
        }
        return resources;
    }

    private PreviewVdbStatus getStatus(IPath pvdbPath) {
        ArrayList statuses = null;
        try {
            this.statusLock.readLock().lock();
            statuses = (ArrayList)((Object)this.deploymentStatusMap.get(this.getProjectPath(pvdbPath)));
            if (statuses != null && !statuses.isEmpty()) {
                statuses = new ArrayList(statuses);
            }
        }
        finally {
            this.statusLock.readLock().unlock();
        }
        if (statuses == null) {
            return null;
        }
        for (PreviewVdbStatus status : statuses) {
            if (!status.getPath().equals((Object)pvdbPath)) continue;
            return status;
        }
        return null;
    }

    private String getVdbSourceModelVdbName(ModelResource modelResource) throws Exception {
        if (modelResource.getModelAnnotation() != null) {
            return ModelUtil.getVdbName((ModelResource)modelResource);
        }
        return null;
    }

    private void handleFileChanged(IResourceDelta fileDelta) {
        assert (fileDelta != null) : "fileDelta is null";
        assert (fileDelta.getResource() instanceof IFile) : "fileDelta resource=" + fileDelta.getResource();
        IFile file = (IFile)fileDelta.getResource();
        if (ResourceChangeUtilities.isChanged((IResourceDelta)fileDelta) && ResourceChangeUtilities.isContentChanged((IResourceDelta)fileDelta) && PreviewManager.isPreviewableResource(file)) {
            this.modelChanged(file);
        } else if (ResourceChangeUtilities.isRemoved((IResourceDelta)fileDelta)) {
            this.fileDeleted(file);
        } else if (ResourceChangeUtilities.isAdded((IResourceDelta)fileDelta) && PreviewManager.isPreviewableResource(file)) {
            this.modelChanged(file);
        }
    }

    private void handleFolderChanged(IResourceDelta folderDelta) {
        assert (folderDelta != null) : "folderDelta is null";
        assert (folderDelta.getResource() instanceof IFolder) : "folderDelta resource=" + folderDelta.getResource();
        IResourceDelta[] iResourceDeltaArray = folderDelta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource instanceof IFolder) {
                this.handleFolderChanged(delta);
            } else if (resource instanceof IFile) {
                this.handleFileChanged(delta);
            }
            ++n2;
        }
    }

    private void handleModelProjectOpened(ModelProjectOpenedJob job) {
        block11: {
            IProject project = job.getProject();
            ArrayList<IPath> pvdbPaths = new ArrayList<IPath>();
            try {
                this.findPvdbs((IContainer)project, pvdbPaths);
                if (pvdbPaths.isEmpty()) break block11;
                CompositePreviewJob batchJob = new CompositePreviewJob(NLS.bind((String)Messages.DeleteOrphanedPreviewVdbsJob, (Object)project.getName()), this, this.getPreviewServer());
                ArrayList statuses = null;
                try {
                    this.statusLock.readLock().lock();
                    statuses = (ArrayList)((Object)this.deploymentStatusMap.get(project.getFullPath()));
                    if (statuses == null) {
                        statuses = new ArrayList(0);
                    } else if (!statuses.isEmpty()) {
                        statuses = new ArrayList(statuses);
                    }
                }
                finally {
                    this.statusLock.readLock().unlock();
                }
                for (IPath pvdbPath : pvdbPaths) {
                    boolean delete = true;
                    for (PreviewVdbStatus status : statuses) {
                        if (!status.getPath().equals((Object)pvdbPath)) continue;
                        delete = false;
                        break;
                    }
                    IPath path = pvdbPath.removeFirstSegments(1);
                    IFile modelFile = project.getFile(path);
                    if (delete) {
                        DeletePreviewVdbJob deletePvdbJob = new DeletePreviewVdbJob(modelFile, (PreviewContext)this);
                        batchJob.add(deletePvdbJob);
                        continue;
                    }
                    UpdatePreviewVdbJob updatePvdbJob = new UpdatePreviewVdbJob(modelFile, this.getPreviewServer(), this);
                    updatePvdbJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            if (!(event.getResult().isOK() || PreviewManager.this.getPreviewServer() != null && PreviewManager.this.getPreviewServer().isConnected())) {
                                PreviewManager.this.retryOnNextRefreshOfServer = true;
                            } else {
                                PreviewManager.this.retryOnNextRefreshOfServer = false;
                            }
                            event.getJob().removeJobChangeListener((IJobChangeListener)this);
                        }
                    });
                    batchJob.add(updatePvdbJob);
                }
                batchJob.schedule();
            }
            catch (Exception e) {
                DqpPlugin.Util.log(4, (Throwable)e, NLS.bind((String)Messages.DeleteOrphanedPreviewVdbsJobError, (Object)project.getName()));
            }
        }
    }

    private void handlePreviewVdbCreated(CreatePreviewVdbJob job) {
        IFile pvdb = job.getPreviewVdb();
        if (pvdb != null) {
            this.addWorkspacePvdb(pvdb);
        }
    }

    private void handlePreviewVdbDeleted(DeletePreviewVdbJob job) {
        assert (job.completedSuccessfully()) : "Delete Preview VDB job did not complete successfully";
        this.previewVdbDeletedPostProcessing(job.getPreviewVdb().getFullPath());
    }

    private void handlePreviewVdbUpdated(UpdatePreviewVdbJob job) {
        IFile changedModel = job.getModel();
        IFile pvdbFile = this.getPreviewVdb((IResource)changedModel);
        if (job.getPreviewServer() != null && !this.needsToBeDeployed(pvdbFile)) {
            this.setNeedsToBeDeployedStatus(pvdbFile, true);
        }
    }

    private boolean hasDeploymentStatus(IProject project) {
        assert (project != null) : "project is null";
        try {
            this.statusLock.readLock().lock();
            boolean bl = this.deploymentStatusMap.containsKey(project.getFullPath());
            return bl;
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    private void modelChanged(IFile model) {
        assert (model != null) : "model is null";
        assert (PreviewManager.isPreviewableResource(model)) : "model is not previewable: " + model;
        try {
            ModelChangedJob job = new ModelChangedJob(model, (PreviewContext)this, this.getPreviewServer());
            job.addChildJobChangeListener((IJobChangeListener)this);
            job.schedule(500L);
        }
        catch (Exception e) {
            DqpPlugin.Util.log(4, (Throwable)e, NLS.bind((String)Messages.ModelChangedJobError, (Object)model.getFullPath()));
        }
    }

    private void modelProjectChanged(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta fileDelta = iResourceDeltaArray[n2];
            if (fileDelta.getResource() instanceof IFile) {
                this.handleFileChanged(fileDelta);
            } else if (fileDelta.getResource() instanceof IFolder) {
                this.handleFolderChanged(fileDelta);
            }
            ++n2;
        }
    }

    private void modelProjectClosed(IProject project) {
        this.modelProjectDeleted(project);
    }

    private void modelProjectDeleted(IProject project) {
        assert (project != null) : "project is null";
        Collection statuses = null;
        try {
            this.statusLock.writeLock().lock();
            statuses = this.deploymentStatusMap.remove(project.getFullPath());
        }
        finally {
            this.statusLock.writeLock().unlock();
        }
        if (statuses != null) {
            try {
                for (PreviewVdbStatus status : statuses) {
                    Job job = this.createDeleteDeployedPreviewVdbJob(status.getPath());
                    job.schedule();
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log(4, (Throwable)e, NLS.bind((String)Messages.PreviewVdbDeletedPostProcessingError, (Object)project.getName()));
            }
        }
    }

    private void modelProjectOpened(IProject project) {
        try {
            ModelProjectOpenedJob job = new ModelProjectOpenedJob(project, this);
            job.addChildJobChangeListener((IJobChangeListener)this);
            job.addJobChangeListener((IJobChangeListener)this);
            job.schedule(1000L);
        }
        catch (Exception e) {
            DqpPlugin.Util.log(4, (Throwable)e, NLS.bind((String)Messages.ModelProjectOpenedJobError, (Object)project.getName()));
        }
    }

    boolean needsToBeDeployed(IFile pvdbFile) {
        PreviewVdbStatus status = this.getStatus(pvdbFile.getFullPath());
        assert (status != null) : "PVDB status not found in status map:" + pvdbFile.getFullPath();
        if (status == null) {
            return false;
        }
        boolean deploy = status.shouldDeploy();
        if (!deploy && this.getPreviewServer() != null) {
            try {
                String vdbName = this.getPreviewVdbDeployedName(pvdbFile);
                if (this.getPreviewServer().hasVdb(vdbName)) {
                    this.setNeedsToBeDeployedStatus(pvdbFile, true);
                }
            }
            catch (Exception e) {
                DqpPlugin.Util.log((Throwable)e);
            }
        }
        return deploy;
    }

    public void notifyChanged(Notification notification) {
        if (!this.isPreviewEnabled()) {
            return;
        }
        CoreModelObjectNotificationHelper notificationHelper = new CoreModelObjectNotificationHelper(notification);
        if (notificationHelper.getModifiedResources().size() == 1) {
            IFile changedRes = (IFile)notificationHelper.getModifiedResources().get(0);
            for (Object obj : notificationHelper.getAddOrRemoveTargets()) {
                if (!(obj instanceof Annotation) || !(((Annotation)obj).getAnnotatedObject() instanceof ModelAnnotation)) continue;
                Job job = this.createDeleteDeployedPreviewVdbJob(this.getPreviewVdb((IResource)changedRes).getFullPath());
                job.schedule();
            }
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.teiid.designer.dqp.preferences.PreviewEnabled")) {
            this.previewEnabled = Boolean.parseBoolean(event.getNewValue().toString());
            if (this.previewEnabled) {
                this.synchronizeWorkspace();
            } else {
                this.resetAllDeployedStatuses();
            }
        }
    }

    public void previewSetup(Object objectToPreview, IProgressMonitor monitor) throws Exception {
        assert (this.isPreviewEnabled()) : "previewSetup should not be called if preview is disabled";
        ITeiidServer previewServer = this.getPreviewServer();
        assert (previewServer != null) : "Should not be called when preview server is null";
        ModelResource model = ModelUtil.getModel((Object)objectToPreview);
        IFile modelToPreview = (IFile)model.getCorrespondingResource();
        IProject currentModelProject = modelToPreview.getProject();
        IFile pvdbFile = this.getPreviewVdb((IResource)modelToPreview);
        XmiVdb pvdb = new XmiVdb(pvdbFile, true);
        this.projectPreviewVdbName = PreviewManager.getPreviewProjectVdbName(currentModelProject);
        List<IFile> projectPvdbsToDeploy = this.findProjectPvdbs(currentModelProject, true);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.beginTask(Messages.PreviewSetupTask, 3 + 2 * projectPvdbsToDeploy.size());
        monitor.subTask(NLS.bind((String)Messages.PreviewSetupValidationCheckTask, (Object)model.getItemName()));
        IStatus status = this.checkPreviewVdbForErrors((Vdb)pvdb);
        if (status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        HashSet<IContainer> parents = new HashSet<IContainer>();
        if (model.getModelType() == ModelType.PHYSICAL_LITERAL) {
            monitor.subTask(NLS.bind((String)Messages.PreviewSetupConnectionInfoTask, (Object)model.getItemName()));
            this.ensureConnectionInfoIsValid((Vdb)pvdb, previewServer);
            if (pvdb.isModified()) {
                pvdb.save();
            }
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (this.needsToBeDeployed(pvdbFile)) {
            IContainer parent = pvdbFile.getParent();
            monitor.subTask(NLS.bind((String)Messages.PreviewSetupRefreshWorkspaceTask, (Object)parent.getFullPath()));
            if (!parents.contains(parent)) {
                this.refreshLocal(parent);
                parents.add(parent);
            }
            monitor.subTask(NLS.bind((String)Messages.PreviewSetupDeployTask, (Object)model.getItemName()));
            this.getPreviewServer().deployVdb(pvdbFile);
            this.setNeedsToBeDeployedStatus(pvdbFile, false);
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        ArrayList<IFile> affectedPreviewVDBs = new ArrayList<IFile>(projectPvdbsToDeploy.size());
        for (IFile projectPvdbFile : projectPvdbsToDeploy) {
            if (pvdbFile.equals((Object)projectPvdbFile)) {
                monitor.worked(1);
                continue;
            }
            XmiVdb projectModelPvdb = new XmiVdb(projectPvdbFile, true);
            Iterator name = this.getResourceNameForPreviewVdb(projectPvdbFile);
            monitor.subTask(NLS.bind((String)Messages.PreviewSetupValidationCheckTask, (Object)name));
            IStatus status2 = this.checkPreviewVdbForErrors((Vdb)projectModelPvdb);
            boolean error = false;
            if (status2.getSeverity() == 4) {
                error = true;
                if (this.dependsOn(modelToPreview, projectPvdbFile)) {
                    throw new CoreException(status2);
                }
                affectedPreviewVDBs.add(projectPvdbFile);
            }
            if (!error) {
                monitor.subTask(NLS.bind((String)Messages.PreviewSetupConnectionInfoTask, name));
                status2 = this.ensureConnectionInfoIsValid((Vdb)projectModelPvdb, previewServer);
                boolean wasSaved = false;
                if (projectModelPvdb.isModified()) {
                    wasSaved = true;
                    projectModelPvdb.save();
                }
                IContainer parent = projectPvdbFile.getParent();
                monitor.subTask(NLS.bind((String)Messages.PreviewSetupRefreshWorkspaceTask, (Object)parent.getFullPath()));
                if (!(parent instanceof IWorkspaceRoot || !wasSaved && parents.contains(parent))) {
                    this.refreshLocal(parent);
                    parents.add(parent);
                }
                monitor.subTask(NLS.bind((String)Messages.PreviewSetupDeployTask, name));
                try {
                    this.getPreviewServer().deployVdb(projectPvdbFile);
                    this.setNeedsToBeDeployedStatus(projectPvdbFile, false);
                }
                catch (Exception e) {
                    if (this.dependsOn(modelToPreview, projectPvdbFile) || PreviewManager.isProjectPreviewVdb(projectPvdbFile)) {
                        String modelName = this.getResourceNameForPreviewVdb(projectPvdbFile);
                        status2 = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.DeployPreviewVdbDependencyError, (Object)modelName), (Throwable)e);
                        throw new CoreException(status2);
                    }
                    affectedPreviewVDBs.remove(projectPvdbFile);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            monitor.worked(1);
        }
        IFile projectVdbIFile = null;
        List<IFile> localPreviewVdbs = this.findProjectPvdbs(currentModelProject, false);
        for (IFile projectVdb : localPreviewVdbs) {
            if (!this.isProjectLevelPreviewVdb(projectVdb)) continue;
            projectVdbIFile = projectVdb;
            break;
        }
        localPreviewVdbs.removeAll(affectedPreviewVDBs);
        monitor.subTask(NLS.bind((String)Messages.PreviewSetupMergeTask, (Object)this.projectPreviewVdbName));
        if (this.getPreviewServer().getServerVersion().isSevenServer()) {
            affectedPreviewVDBs.add(pvdbFile);
            for (IFile pvdbToMerge : affectedPreviewVDBs) {
                String name = this.getResourceNameForPreviewVdb(pvdbToMerge);
                monitor.subTask(NLS.bind((String)Messages.PreviewSetupMergeTask, (Object)name));
                String sourceVdbName = pvdbToMerge.getFullPath().removeFileExtension().lastSegment().toString();
                String projectPreviewVdbName = PreviewManager.getPreviewProjectVdbName(modelToPreview.getProject());
                if (!sourceVdbName.equals(projectPreviewVdbName)) {
                    this.getPreviewServer().mergeVdbs(sourceVdbName, PreviewManager.getPreviewVdbVersion(pvdbToMerge), projectPreviewVdbName, 1);
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        } else if (projectVdbIFile != null) {
            ITeiidVdb deployedProjectVdb = this.getPreviewServer().getVdb(this.projectPreviewVdbName);
            XmiVdb localProjectVdb = new XmiVdb(projectVdbIFile);
            localProjectVdb.removeAllImports();
            this.addPreviewVdbImports((Vdb)localProjectVdb, localPreviewVdbs);
            this.addPreviewSourceVdbImports((Vdb)localProjectVdb, currentModelProject);
            if (deployedProjectVdb != null) {
                String fullProjectVdbName = this.getFullDeployedVdbName(deployedProjectVdb);
                this.getPreviewServer().undeployVdb(fullProjectVdbName);
            }
            localProjectVdb.save();
            localProjectVdb.getSourceFile().refreshLocal(2, null);
            this.getPreviewServer().deployVdb(localProjectVdb.getSourceFile());
        }
        monitor.worked(1);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        monitor.done();
    }

    private boolean isProjectLevelPreviewVdb(IFile pvdbFile) {
        return pvdbFile.getFullPath().toString().contains(this.projectPreviewVdbName);
    }

    private void previewVdbDeletedPostProcessing(IPath pvdbPath) {
        this.deleteWorkspacePvdb(pvdbPath);
        Job job = this.createDeleteDeployedPreviewVdbJob(pvdbPath);
        job.schedule();
    }

    private void refreshLocal(IContainer parent) throws CoreException {
        parent.refreshLocal(2, null);
    }

    private void resetAllDeployedStatuses() {
        try {
            this.statusLock.readLock().lock();
            for (Map.Entry<IPath, Set<PreviewVdbStatus>> entry : this.deploymentStatusMap.entrySet()) {
                for (PreviewVdbStatus status : entry.getValue()) {
                    status.setDeploy(true);
                }
            }
        }
        finally {
            this.statusLock.readLock().unlock();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        IResource deltaResource;
        if (!this.isPreviewEnabled()) {
            return;
        }
        if (ResourceChangeUtilities.isPreClose((IResourceChangeEvent)event)) {
            IProject project = (IProject)event.getResource();
            if (ModelerCore.hasModelNature((IProject)project)) {
                this.modelProjectClosed(project);
            }
        } else if (ResourceChangeUtilities.isPreDelete((IResourceChangeEvent)event)) {
            IProject project = (IProject)event.getResource();
            if (this.hasDeploymentStatus(project)) {
                this.modelProjectDeleted(project);
            }
        } else if (event.getResource() == null && (deltaResource = (delta = event.getDelta()).getResource()) instanceof IWorkspaceRoot) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                IResourceDelta kidDelta = iResourceDeltaArray[n2];
                IResource kidResource = kidDelta.getResource();
                if (kidResource instanceof IProject && ModelerCore.hasModelNature((IProject)(project = (IProject)kidResource)) && project.isOpen()) {
                    if (ResourceChangeUtilities.isOpened((IResourceDelta)kidDelta) || ResourceChangeUtilities.isDescriptionChanged((IResourceDelta)kidDelta)) {
                        this.modelProjectOpened(project);
                    } else if (ResourceChangeUtilities.isChanged((IResourceDelta)kidDelta)) {
                        this.modelProjectChanged(kidDelta);
                    }
                }
                ++n2;
            }
        }
    }

    private void setNeedsToBeDeployedStatus(IFile pvdb, boolean deploy) {
        assert (pvdb != null) : "PVDB is null";
        this.setNeedsToBeDeployedStatus(pvdb.getFullPath(), deploy);
    }

    private void setNeedsToBeDeployedStatus(IPath pvdbPath, boolean deploy) {
        PreviewVdbStatus status = this.getStatus(pvdbPath);
        if (status != null) {
            status.setDeploy(deploy);
        }
    }

    private Collection<Job> rebuildPreviewVdbs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (IProject project : DotProjectUtils.getOpenModelProjects()) {
            ArrayList<IPath> pvdbPaths = new ArrayList<IPath>();
            try {
                if (project.isOpen() && ModelerCore.hasModelNature((IProject)project)) {
                    this.findPvdbs((IContainer)project, pvdbPaths);
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
            }
            boolean previewVdbsDeleted = false;
            for (IPath pvdbPath : pvdbPaths) {
                IPath path = pvdbPath.removeFirstSegments(1);
                IFile modelFile = project.getFile(path);
                try {
                    DeletePreviewVdbJob deletePvdbJob = new DeletePreviewVdbJob(modelFile, (PreviewContext)this);
                    jobs.add((Job)deletePvdbJob);
                    previewVdbsDeleted = true;
                }
                catch (Exception ex) {
                    DqpPlugin.Util.log((Throwable)ex);
                }
            }
            if (!previewVdbsDeleted) continue;
            try {
                ModelProjectOpenedJob job = new ModelProjectOpenedJob(project, this);
                jobs.add(job);
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
            }
        }
        return jobs;
    }

    private void setPreviewServer(ITeiidServer teiidServer) {
        ITeiidServer oldServer = this.getPreviewServer();
        ITeiidServerVersion oldServerVersion = oldServer == null ? null : oldServer.getServerVersion();
        this.previewServer.set(teiidServer);
        boolean serverDeleted = teiidServer == null;
        this.resetAllDeployedStatuses();
        ArrayList<Job> jobs = new ArrayList<Job>();
        if (oldServer != null && oldServer.isConnected()) {
            for (IProject project : DotProjectUtils.getOpenModelProjects()) {
                for (IFile pvdbFile : this.findProjectPvdbs(project, false)) {
                    DeleteDeployedPreviewVdbJob deleteDeployedPvdbJob = new DeleteDeployedPreviewVdbJob(this.getPreviewVdbDeployedName(pvdbFile), this.getPreviewVdbJndiName(pvdbFile), this, oldServer);
                    jobs.add(deleteDeployedPvdbJob);
                }
            }
        }
        if (teiidServer == null || !teiidServer.getServerVersion().equals(oldServerVersion)) {
            jobs.addAll(this.rebuildPreviewVdbs());
        }
        if (!jobs.isEmpty()) {
            try {
                CountDownLatch latch = new CountDownLatch(jobs.size());
                ServerDeleteJobListener shutdownJobListener = new ServerDeleteJobListener(latch, oldServer, serverDeleted);
                for (Job job : jobs) {
                    job.addJobChangeListener((IJobChangeListener)shutdownJobListener);
                    job.schedule();
                }
                latch.await(10 + (int)((double)jobs.size() / 4.0), TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                DqpPlugin.Util.log((Throwable)e);
            }
        }
    }

    private void cleanServer(IProgressMonitor monitor, ITeiidServer instance) throws CoreException, Exception, InterruptedException {
        IEclipsePreferences prefs = DqpPlugin.getInstance().getPreferences();
        if (instance == null) {
            return;
        }
        if (!instance.isConnected()) {
            return;
        }
        if (!prefs.getBoolean("org.teiid.designer.dqp.preferences.PreviewTeiidCleanupEnabled", true)) {
            return;
        }
        ArrayList<DeleteDeployedPreviewVdbJob> jobs = new ArrayList<DeleteDeployedPreviewVdbJob>();
        for (ITeiidVdb vdb : instance.getVdbs()) {
            if (!vdb.isPreviewVdb() || !vdb.getName().contains(ModelerCore.workspaceUuid().toString())) continue;
            DeleteDeployedPreviewVdbJob job = new DeleteDeployedPreviewVdbJob(vdb.getName(), this.getPreviewVdbJndiName(vdb.getName()), this, instance);
            jobs.add(job);
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (jobs.isEmpty()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(jobs.size());
        ShutdownJobListener shutdownJobListener = new ShutdownJobListener(latch, monitor);
        for (DeleteDeployedPreviewVdbJob job : jobs) {
            job.addJobChangeListener((IJobChangeListener)shutdownJobListener);
            job.schedule();
            if (monitor.isCanceled()) break;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        monitor.subTask(NLS.bind((String)Messages.PreviewShutdownTeiidCleanupTask, (Object)jobs.size()));
        latch.await();
    }

    public void shutdown(IProgressMonitor monitor) throws Exception {
        try {
            ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            ModelerCore.getModelContainer().getChangeNotifier().removeListener((INotifyChangedListener)this);
            IEclipsePreferences prefs = DqpPlugin.getInstance().getPreferences();
            prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            if (this.isPreviewEnabled()) {
                this.cleanServer(monitor, this.getPreviewServer());
            }
        }
        finally {
            this.previewEnabled = false;
            this.previewServer.set(null);
        }
    }

    private void startup() {
        try {
            ModelerCore.getModelContainer().getChangeNotifier().addListener((INotifyChangedListener)this);
        }
        catch (Exception e) {
            DqpPlugin.Util.log(4, (Throwable)e, DqpPlugin.Util.getString("serverManagerErrorConstructingPreviewManager", new Object[0]));
        }
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        IEclipsePreferences prefs = DqpPlugin.getInstance().getPreferences();
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.previewEnabled = prefs.getBoolean("org.teiid.designer.dqp.preferences.PreviewEnabled", true);
        if (this.previewEnabled) {
            for (IProject project : DotProjectUtils.getOpenModelProjects()) {
                if (!project.isOpen() || !ModelerCore.hasModelNature((IProject)project)) continue;
                this.modelProjectOpened(project);
            }
        }
    }

    private void synchronizeWorkspace() {
        for (IProject project : DotProjectUtils.getOpenModelProjects()) {
            this.modelProjectOpened(project);
        }
    }

    private String getSourceJndiName(VdbModelEntry entry) {
        VdbSourceInfo info = entry.getSourceInfo();
        if (!info.isMultiSource() && info.getSourceCount() == 1) {
            VdbSource source = (VdbSource)entry.getSourceInfo().getSources().iterator().next();
            return source.getJndiName();
        }
        throw new ModelerCoreRuntimeException("Invalid VDB Source info for VDB model entry" + entry.getName());
    }

    private String getSourceTranslatorName(VdbModelEntry entry) {
        VdbSourceInfo info = entry.getSourceInfo();
        if (!info.isMultiSource() && info.getSourceCount() == 1) {
            VdbSource source = (VdbSource)entry.getSourceInfo().getSources().iterator().next();
            return source.getTranslatorName();
        }
        throw new ModelerCoreRuntimeException("Invalid VDB Source info for VDB model entry" + entry.getName());
    }

    class PreviewVdbStatus {
        private boolean deploy = true;
        private final IFile pvdb;

        public PreviewVdbStatus(IFile pvdb) {
            this.pvdb = pvdb;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof PreviewVdbStatus) {
                PreviewVdbStatus other = (PreviewVdbStatus)obj;
                return this.getPath().equals((Object)other.getPath());
            }
            return false;
        }

        public IFile getFile() {
            return this.pvdb;
        }

        public IPath getPath() {
            return this.pvdb.getFullPath();
        }

        public int hashCode() {
            return this.getPath().hashCode();
        }

        public void setDeploy(boolean deploy) {
            this.deploy = deploy;
        }

        public boolean shouldDeploy() {
            return this.deploy;
        }

        public String toString() {
            return this.getPath().toString();
        }
    }

    class ServerDeleteJobListener
    extends JobChangeAdapter {
        private final CountDownLatch latch;
        private final ITeiidServer teiidServer;
        private boolean serverDeleted = false;

        public ServerDeleteJobListener(CountDownLatch latch, ITeiidServer teiidServer, boolean serverDeleted) {
            this.latch = latch;
            this.teiidServer = teiidServer;
            this.serverDeleted = serverDeleted;
        }

        public void done(IJobChangeEvent event) {
            this.latch.countDown();
            if (this.latch.getCount() == 0L && this.serverDeleted && this.teiidServer != null) {
                this.teiidServer.disconnect();
            }
        }
    }

    class ShutdownJobListener
    extends JobChangeAdapter {
        private final CountDownLatch latch;
        private final IProgressMonitor monitor;

        public ShutdownJobListener(CountDownLatch latch, IProgressMonitor monitor) {
            this.latch = latch;
            this.monitor = monitor;
        }

        public void done(IJobChangeEvent event) {
            this.latch.countDown();
            if (this.monitor != null) {
                this.monitor.subTask(NLS.bind((String)Messages.PreviewShutdownTeiidCleanupTask, (Object)this.latch.getCount()));
            }
        }
    }
}

