/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidServerFactory;
import org.teiid.designer.runtime.adapter.TeiidServerAdapterFactory;
import org.teiid.designer.runtime.spi.ITeiidConnectionInfo;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;

public class TeiidParentServerListener
implements IServerLifecycleListener,
IServerListener {
    private static TeiidParentServerListener instance;
    private static String JBAS013493_CODE;
    private TeiidServerAdapterFactory factory = new TeiidServerAdapterFactory();
    private boolean sleep;
    private Thread startTeiidServerThread = null;

    static {
        JBAS013493_CODE = "JBAS013493";
    }

    public static TeiidParentServerListener getInstance() {
        if (instance == null) {
            instance = new TeiidParentServerListener();
        }
        return instance;
    }

    private TeiidParentServerListener() {
    }

    public void serverAdded(IServer server) {
        if (this.sleep) {
            return;
        }
        DqpPlugin.getInstance().getServerManager();
        server.addServerListener((IServerListener)this);
        try {
            this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY);
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    public void serverChanged(IServer server) {
        if (this.sleep) {
            return;
        }
        ITeiidServerManager serverManager = DqpPlugin.getInstance().getServerManager();
        try {
            for (ITeiidServer teiidServer : serverManager.getServers()) {
                String portNumber;
                if (!server.equals(teiidServer.getParent())) continue;
                ITeiidServer newTeiidServer = this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY, TeiidServerFactory.ServerOptions.NO_CHECK_CONNECTION);
                if (teiidServer.getServerVersion().isGreaterThan(TeiidServerVersion.Version.TEIID_7_7.get())) {
                    teiidServer.getTeiidAdminInfo().setAll((ITeiidConnectionInfo)newTeiidServer.getTeiidAdminInfo());
                }
                if (StringUtilities.isEmpty((String)(portNumber = serverManager.getJdbcPort(teiidServer, true)))) {
                    teiidServer.getTeiidJdbcInfo().setPort(newTeiidServer.getTeiidJdbcInfo().getPort());
                }
                teiidServer.notifyRefresh();
                return;
            }
            this.factory.adaptServer(server, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY);
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    public void serverRemoved(IServer server) {
        if (this.sleep) {
            return;
        }
        server.removeServerListener((IServerListener)this);
        ITeiidServerManager serverManager = DqpPlugin.getInstance().getServerManager();
        for (ITeiidServer teiidServer : serverManager.getServers()) {
            if (!server.equals(teiidServer.getParent())) continue;
            serverManager.removeServer(teiidServer);
            break;
        }
    }

    public void serverChanged(ServerEvent event) {
        if (this.sleep) {
            return;
        }
        if (event == null) {
            return;
        }
        int eventKind = event.getKind();
        if ((eventKind & 0x10) == 0) {
            return;
        }
        if ((eventKind & 1) == 0) {
            return;
        }
        int state = event.getState();
        IServer parentServer = event.getServer();
        try {
            if (state == 3 || state == 4) {
                ITeiidServer teiidServer = this.factory.adaptServer(parentServer, new TeiidServerFactory.ServerOptions[0]);
                if (teiidServer != null) {
                    teiidServer.disconnect();
                }
            } else if (state == 2) {
                this.teiidServerStarted(parentServer);
            }
        }
        catch (Exception ex) {
            DqpPlugin.handleException(ex);
        }
    }

    private void teiidServerStarted(final IServer parentServer) {
        if (this.startTeiidServerThread != null && this.startTeiidServerThread.isAlive()) {
            return;
        }
        Runnable serverStartRunnable = new Runnable(){
            private boolean connected = false;

            @Override
            public void run() {
                try {
                    this.tryConnecting(parentServer);
                }
                catch (Exception ex) {
                    DqpPlugin.handleException(ex);
                }
            }

            private void tryConnecting(IServer parentServer2) throws Exception {
                ITeiidServer teiidServer = TeiidParentServerListener.this.factory.adaptServer(parentServer2, TeiidServerFactory.ServerOptions.ADD_TO_REGISTRY);
                boolean parentConnected = false;
                ITeiidServer queryServer = null;
                int attempts = 0;
                Exception logThisException = null;
                while (!(parentConnected && queryServer != null || attempts >= 10)) {
                    try {
                        ++attempts;
                        boolean bl = parentConnected = teiidServer != null && teiidServer.isParentConnected() && TeiidParentServerListener.this.adaptServerOK(parentServer2);
                        if (parentConnected) {
                            queryServer = TeiidParentServerListener.this.factory.adaptServer(parentServer2, TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY);
                        }
                        Thread.sleep(6000L);
                    }
                    catch (Exception ex) {
                        logThisException = ex;
                    }
                }
                if (queryServer != null) {
                    teiidServer.getTeiidAdminInfo().setAll((ITeiidConnectionInfo)queryServer.getTeiidAdminInfo());
                    teiidServer.getTeiidJdbcInfo().setPort(queryServer.getTeiidJdbcInfo().getPort());
                    teiidServer.reconnect();
                    try {
                        int defaultPort = Integer.parseInt(queryServer.getTeiidJdbcInfo().getPort());
                        DqpPlugin.getInstance().getServerManager().setJdbcPort(teiidServer, defaultPort, false);
                        if (DqpPlugin.getInstance().getServerManager().getJdbcPort(teiidServer, true) == null) {
                            DqpPlugin.getInstance().getServerManager().setJdbcPort(teiidServer, defaultPort, true);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    DqpPlugin.getInstance().getServerManager().removeServer(teiidServer);
                    if (logThisException != null) {
                        DqpPlugin.handleException(logThisException);
                    }
                    return;
                }
            }
        };
        this.startTeiidServerThread = new Thread(serverStartRunnable, "Teiid Server Starting Thread");
        this.startTeiidServerThread.start();
    }

    private boolean adaptServerOK(IServer parentServer) throws Exception {
        try {
            this.factory.adaptServer(parentServer, TeiidServerFactory.ServerOptions.NO_CHECK_SERVER_REGISTRY);
        }
        catch (JBoss7ManangerException e) {
            if (e.getMessage().contains(JBAS013493_CODE)) {
                return false;
            }
            throw new Exception(e);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return true;
    }

    public void sleep() {
        this.sleep = true;
    }

    public void wake() {
        this.sleep = false;
    }
}

