/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.datatools.connectivity.spi.ISecureStorageProvider;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.TeiidConnectionInfo;
import org.teiid.designer.runtime.TeiidServerUtils;
import org.teiid.designer.runtime.spi.ITeiidJdbcInfo;

public class TeiidJdbcInfo
extends TeiidConnectionInfo
implements ITeiidJdbcInfo {
    private static final String VDB_PLACEHOLDER = "<vdbname>";
    private static final String JDBC_TEIID_PREFIX = "jdbc:teiid:";
    private String vdbname;

    public TeiidJdbcInfo(String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        this(VDB_PLACEHOLDER, port, username, secureStorageProvider, password, secure);
    }

    private TeiidJdbcInfo(String vdbname, String port, String username, ISecureStorageProvider secureStorageProvider, String password, boolean secure) {
        super(port, username, secureStorageProvider, password, secure);
        CoreArgCheck.isNotEmpty((String)vdbname, (String)"vdbname");
        this.vdbname = vdbname;
        this.initPassword(password);
    }

    public TeiidJdbcInfo(String vdbname, ITeiidJdbcInfo teiidJdbcInfo) {
        this(vdbname, teiidJdbcInfo.getPort(), teiidJdbcInfo.getUsername(), teiidJdbcInfo.getSecureStorageProvider(), teiidJdbcInfo.getPassword(), teiidJdbcInfo.isSecure());
        this.setHostProvider(teiidJdbcInfo.getHostProvider());
    }

    @Override
    protected String getPasswordKey() {
        return "jdbc_password";
    }

    public ITeiidJdbcInfo clone() {
        TeiidJdbcInfo cloned = new TeiidJdbcInfo(this.getPort(), this.getUsername(), this.getSecureStorageProvider(), this.getPassword(), this.isSecure());
        cloned.setHostProvider(this.getHostProvider());
        return cloned;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.vdbname.equals(((TeiidJdbcInfo)object).vdbname);
    }

    @Override
    public String getType() {
        return DqpPlugin.Util.getString("jdbcInfoType", new Object[0]);
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(JDBC_TEIID_PREFIX);
        sb.append(this.vdbname);
        sb.append('@');
        return sb.append(super.getUrl()).toString();
    }

    @Override
    public int hashCode() {
        return HashCodeUtil.hashCode((int)super.hashCode(), (Object[])new Object[]{this.vdbname});
    }

    @Override
    public String toString() {
        return DqpPlugin.Util.getString("jdbcConnectionInfoProperties", new Object[]{super.toString(), this.vdbname});
    }

    @Override
    protected IStatus validateUrl() {
        try {
            TeiidServerUtils.validPortNumber(this.getPort());
        }
        catch (Exception e) {
            return new Status(4, "org.teiid.designer.dqp", DqpPlugin.Util.getString("invalidServerUrl", new Object[]{this.getType(), e.getMessage()}), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

