/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.util;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.fusesource.ide.camel.model.Activator;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.ICamelEditorInput;
import org.fusesource.ide.camel.model.io.XmlContainerMarshaller;
import org.fusesource.ide.commons.util.IOUtils;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.fusesource.ide.launcher.util.CamelDebugContextFileStoreEditorInput;

public class CamelDebugContextEditorInput
implements ICamelEditorInput {
    public static final String ID = CamelDebugContextEditorInput.class.getName();
    private final CamelDebugFacade debugger;
    private final ILaunchConfiguration launchConfig;
    private File tempFile;
    private IFile lastSaveAsFile;
    private CamelDebugContextFileStoreEditorInput lastInput;

    public CamelDebugContextEditorInput(CamelDebugFacade debugger, ILaunchConfiguration launchConfig) {
        this.debugger = debugger;
        this.launchConfig = launchConfig;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IFile.class) || adapter.equals(IResource.class)) {
            this.getFileEditorInput();
            IPath p = Path.fromOSString((String)this.tempFile.getPath());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(p);
            return file;
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("camel.png");
    }

    public String getName() {
        return "CamelContext: " + this.debugger.getContextId();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public RouteContainer loadModel() {
        return new XmlContainerMarshaller().loadRoutesFromText(this.debugger.getContextXmlDump());
    }

    public void save(String xml) {
        this.debugger.updateContext(xml);
    }

    public IEditorInput getFileEditorInput() {
        if (this.lastInput == null) {
            try {
                String fileUnderDebug = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.launchConfig);
                IProject p = CamelDebugUtils.getProjectForFilePath(fileUnderDebug);
                File targetFolder = p.getLocation().append("target").toFile();
                if (!targetFolder.exists()) {
                    targetFolder.mkdirs();
                }
                File tempDir = File.createTempFile(".CamelContextInDebug_", "_temp", targetFolder);
                tempDir.delete();
                tempDir.mkdirs();
                this.tempFile = new File(tempDir, fileUnderDebug.substring(fileUnderDebug.lastIndexOf("/") + 1));
                IFileSystem fileSystem = EFS.getLocalFileSystem();
                IFileStore fileStore = fileSystem.fromLocalFile(this.tempFile);
                String xml = this.debugger.getContextXmlDump();
                if (xml != null) {
                    IOUtils.writeText((File)this.tempFile, (String)xml);
                }
                this.lastInput = new CamelDebugContextFileStoreEditorInput(fileStore, this.debugger);
                return this.lastInput;
            }
            catch (Exception e) {
                Activator.getLogger().warning("Failed to create temporary file: " + e, (Throwable)e);
            }
        }
        return this.lastInput;
    }

    public void refresh() {
    }

    public IFile getLastSaveAsFile() {
        return this.lastSaveAsFile;
    }

    public void setLastSaveAsFile(IFile lastSaveAsFile) {
        this.lastSaveAsFile = lastSaveAsFile;
    }
}

