/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.run.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.fusesource.ide.commons.util.CamelUtils;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.fusesource.ide.launcher.run.launching.FuseMavenLaunchDelegate;
import org.fusesource.ide.launcher.run.util.MavenLaunchUtils;

public class CamelRunMavenLaunchDelegate
extends FuseMavenLaunchDelegate {
    public CamelRunMavenLaunchDelegate() {
        super("clean package");
    }

    @Override
    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        IFile pomFile = null;
        boolean isBluePrint = false;
        String newGoalsAdditionForFile = null;
        String filePath = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(configuration);
        if (filePath.trim().length() > 0) {
            IFile f;
            isBluePrint = CamelUtils.isBlueprintFile((String)filePath);
            if (filePath.trim().length() > 0) {
                newGoalsAdditionForFile = String.format(" -D%s=file:%s", "camel.fileApplicationContextUri", filePath);
                if (isBluePrint) {
                    newGoalsAdditionForFile = String.format("%s -D%s", newGoalsAdditionForFile, "camel.blueprint=true");
                }
            }
            if ((f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)filePath))) != null) {
                IProject p = f.getProject();
                pomFile = p.getFile("pom.xml");
            }
        }
        if (MavenLaunchUtils.isPackagingTypeWAR(pomFile)) {
            this.setGoals("clean package org.eclipse.jetty:jetty-maven-plugin:run ");
        } else {
            this.setGoals("clean package org.apache.camel:camel-maven-plugin:run ");
        }
        return String.valueOf(super.getGoals(configuration)) + newGoalsAdditionForFile;
    }

    @Override
    public String getEclipseProcessName() {
        return "Local Camel Context";
    }
}

