/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validator.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.JavaValidateType;
import org.switchyard.tools.models.switchyard1_0.validate.XmlValidateType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.internal.wizards.BaseWizard;
import org.switchyard.tools.ui.editor.validator.wizards.AddValidatorWizardJavaPage;
import org.switchyard.tools.ui.editor.validator.wizards.AddValidatorWizardStartPage;
import org.switchyard.tools.ui.editor.validator.wizards.AddValidatorWizardXMLPage;

public class AddValidatorWizard
extends BaseWizard {
    private AddValidatorWizardStartPage _startPage = null;
    private AddValidatorWizardXMLPage _xmlPage = null;
    private AddValidatorWizardJavaPage _javaPage = null;
    private ValidateType _validator = null;

    public AddValidatorWizard() {
        this.initPages();
        this.setWindowTitle(Messages.title_newValidator);
    }

    private void initPages() {
        this._startPage = new AddValidatorWizardStartPage("start");
        this._xmlPage = new AddValidatorWizardXMLPage(this._startPage, "xml");
        this._javaPage = new AddValidatorWizardJavaPage(this._startPage, "java");
    }

    public boolean performFinish() {
        if (this._startPage != null && this._startPage.getValidator() != null) {
            return true;
        }
        return this._validator != null;
    }

    public void addPages() {
        if (this._validator == null) {
            this.addPage((IWizardPage)this._startPage);
            this.addPage((IWizardPage)this._xmlPage);
            this.addPage((IWizardPage)this._javaPage);
        } else if (this._validator instanceof XmlValidateType) {
            this.addPage((IWizardPage)this._xmlPage);
        } else if (this._validator instanceof JavaValidateType) {
            this.addPage((IWizardPage)this._javaPage);
        }
    }

    public ValidateType getValidator() {
        if (this._startPage != null && this._startPage.getValidator() != null) {
            return this._startPage.getValidator();
        }
        if (this._validator != null) {
            return this._validator;
        }
        return null;
    }

    public void setValidator(ValidateType validator) {
        if (this._startPage != null) {
            this._validator = validator;
        }
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this._startPage)) {
            ValidateType validatorToTest = this._startPage.getValidator();
            if (validatorToTest instanceof XmlValidateType) {
                this._xmlPage.refresh();
                return this._xmlPage;
            }
            if (validatorToTest instanceof JavaValidateType) {
                this._javaPage.refresh();
                return this._javaPage;
            }
        }
        return null;
    }
}

