/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.JAXBTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.TransformDetails;
import org.switchyard.tools.ui.editor.transform.TransformProviderRegistry;

public class NewAdHocTransformWizardPage
extends WizardPage
implements ITransformProvider.IContainer {
    private TransformDetails _details;
    private IProject _project;
    private ComboViewer _transformProviderList;
    private ITransformProvider _selectedProvider;
    private ITransformControl _activeControl;
    private Map<ITransformProvider, ITransformControl> _providerControls = new HashMap<ITransformProvider, ITransformControl>();
    private Map<ITransformProvider, INewTransformWizard> _providerWizards = new HashMap<ITransformProvider, INewTransformWizard>();
    private Collection<TransformType> _newTransforms;
    private ComboViewer _fromCombo;
    private ComboViewer _toCombo;

    public NewAdHocTransformWizardPage() {
        super(NewAdHocTransformWizardPage.class.getCanonicalName());
        this.setTitle("New Transformer");
        this.setDescription("Create transformers for the selected transform pair.");
    }

    public void init(TransformDetails details) {
        this._details = details;
        this._project = PlatformResourceAdapterFactory.getContainingProject((Object)details.getSwitchYard());
        this.validate(null);
    }

    private void handleComboSelection() {
        if (this._activeControl == null) {
            INewTransformWizard providerWizard = this._providerWizards.get(this._selectedProvider);
            if (providerWizard != null) {
                providerWizard.setSelectedTransforms(this.getSelectedTransforms());
            }
        } else {
            this._activeControl.setSelectedTransforms(this.getSelectedTransforms());
        }
        this.validate(null);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite content = new Composite(parent, 0);
        content.setFont(parent.getFont());
        content.setLayout((Layout)new GridLayout(2, false));
        Label fromLabel = new Label(content, 0);
        fromLabel.setText("From Type");
        fromLabel.setLayoutData((Object)new GridData(16384, 128, true, false));
        Label toLabel = new Label(content, 0);
        toLabel.setText("To Type");
        toLabel.setLayoutData((Object)new GridData(16384, 128, true, false));
        this._fromCombo = new ComboViewer(content, 4);
        this._fromCombo.getCombo().setLayoutData((Object)new GridData(4, 128, true, false));
        this._fromCombo.setContentProvider((IContentProvider)new TransformDetailsContentProvider());
        this._fromCombo.setLabelProvider((IBaseLabelProvider)new TransformTypeFromLabelProvider());
        this._fromCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewAdHocTransformWizardPage.this.handleComboSelection();
            }
        });
        this._fromCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAdHocTransformWizardPage.this.handleComboSelection();
                NewAdHocTransformWizardPage.this.validate(null);
            }
        });
        this._toCombo = new ComboViewer(content, 4);
        this._toCombo.getCombo().setLayoutData((Object)new GridData(4, 128, true, false));
        this._toCombo.setContentProvider((IContentProvider)new TransformDetailsContentProvider());
        this._toCombo.setLabelProvider((IBaseLabelProvider)new TransformTypeToLabelProvider());
        this._toCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewAdHocTransformWizardPage.this.handleComboSelection();
            }
        });
        this._toCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAdHocTransformWizardPage.this.handleComboSelection();
                NewAdHocTransformWizardPage.this.validate(null);
            }
        });
        Label separator = new Label(content, 258);
        separator.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        ((GridData)separator.getLayoutData()).heightHint = 20;
        Label transformTypeLabel = new Label(content, 0);
        transformTypeLabel.setText(Messages.label_transformerType);
        this._transformProviderList = new ComboViewer(content);
        this._transformProviderList.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._transformProviderList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._transformProviderList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ITransformProvider)element).getName();
            }
        });
        this._transformProviderList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (NewAdHocTransformWizardPage.this._activeControl != null) {
                    NewAdHocTransformWizardPage.this._activeControl.setVisible(false);
                }
                if (event.getSelection().isEmpty()) {
                    NewAdHocTransformWizardPage.this._activeControl = null;
                    NewAdHocTransformWizardPage.this._selectedProvider = null;
                } else {
                    NewAdHocTransformWizardPage.this._selectedProvider = (ITransformProvider)((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (!NewAdHocTransformWizardPage.this._selectedProvider.providesWizard()) {
                        NewAdHocTransformWizardPage.this._activeControl = (ITransformControl)NewAdHocTransformWizardPage.this._providerControls.get(NewAdHocTransformWizardPage.this._selectedProvider);
                        if (NewAdHocTransformWizardPage.this._activeControl != null) {
                            NewAdHocTransformWizardPage.this._activeControl.setSelectedTransforms(NewAdHocTransformWizardPage.this.getSelectedTransforms());
                            NewAdHocTransformWizardPage.this._activeControl.setVisible(true);
                        }
                    } else {
                        NewAdHocTransformWizardPage.this._activeControl = null;
                    }
                }
                NewAdHocTransformWizardPage.this.validate(null);
                if (NewAdHocTransformWizardPage.this.getWizard().getContainer().getCurrentPage() != null) {
                    NewAdHocTransformWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        Composite providers = new Composite(content, 0);
        providers.setLayout((Layout)new FormLayout());
        providers.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        for (ITransformProvider provider : TransformProviderRegistry.instance().getProviders()) {
            if (provider.providesWizard()) continue;
            ITransformControl providerControl = provider.createTransformControl(providers, this);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0);
            formData.bottom = new FormAttachment(100);
            formData.left = new FormAttachment(0);
            formData.right = new FormAttachment(100);
            providerControl.setLayoutData(formData);
            providerControl.setVisible(false);
            this._providerControls.put(provider, providerControl);
        }
        this.setControl((Control)content);
        Dialog.applyDialogFont((Control)content);
        this.initControls();
        this.validate(null);
        this.setErrorMessage(null);
    }

    public void dispose() {
        for (ITransformControl control : this._providerControls.values()) {
            if (control == null) continue;
            try {
                control.dispose();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        for (INewTransformWizard wizard : this._providerWizards.values()) {
            if (wizard == null) continue;
            try {
                wizard.dispose();
            }
            catch (Exception e) {
                e.fillInStackTrace();
            }
        }
        super.dispose();
    }

    @Override
    public IRunnableContext getContext() {
        return this.getWizard().getContainer();
    }

    @Override
    public void updateStatus(ITransformControl control, IStatus status) {
        if (control != this._activeControl) {
            return;
        }
        this.validate(status);
    }

    @Override
    public IProject getContainingProject() {
        return this._project;
    }

    public boolean performFinish() {
        if (this._activeControl != null) {
            try {
                this._newTransforms = this._activeControl.createTransforms();
            }
            catch (CoreException e) {
                Activator.logStatus(e.getStatus());
            }
        }
        return true;
    }

    public Collection<TransformType> getCreatedTransforms() {
        if (this._activeControl == null) {
            INewTransformWizard providerWizard = this._providerWizards.get(this._selectedProvider);
            return providerWizard.getCreatedTransforms();
        }
        return this._newTransforms;
    }

    private void initControls() {
        this._fromCombo.setInput((Object)this._details);
        this._toCombo.setInput((Object)this._details);
        List<ITransformProvider> providers = TransformProviderRegistry.instance().getProviders();
        this._transformProviderList.setInput(providers);
        if (providers.size() > 0) {
            this._transformProviderList.setSelection((ISelection)new StructuredSelection((Object)providers.get(0)), true);
        }
    }

    private String typeIsValid(String value) {
        String javaStart = "java:";
        String nsPattern = "^\\{.*\\}";
        Pattern pattern = Pattern.compile(nsPattern);
        Matcher matcher = pattern.matcher(value);
        if (value.startsWith(javaStart)) {
            String className = value.replace(javaStart, "");
            if (!this.isValidClassOnClasspath(className)) {
                return "Java class '" + className + "' cannot be found in the project classpath";
            }
            return null;
        }
        if (matcher.find()) {
            return null;
        }
        return "Value must specify a Java type (java:class.name) or a namespaced type ({namespace}simpletype).";
    }

    private void validate(IStatus status) {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this._fromCombo != null && this._toCombo != null && (this._fromCombo.getCombo().getText().isEmpty() || this._toCombo.getCombo().getText().isEmpty())) {
            this.setErrorMessage("You must specify an input and an output for the new transformer.");
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        if (this._fromCombo != null && this._toCombo != null) {
            String fromType = this._fromCombo.getCombo().getText();
            String fromValidMsg = this.typeIsValid(fromType);
            if (fromValidMsg != null) {
                this.setErrorMessage("From type: " + fromValidMsg);
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            String toType = this._toCombo.getCombo().getText();
            String toValidMsg = this.typeIsValid(toType);
            if (toValidMsg != null) {
                this.setErrorMessage("To type: " + toValidMsg);
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
        }
        if (status == null && this._selectedProvider != null && !this._selectedProvider.providesWizard()) {
            status = this._activeControl.validate();
        }
        if (status != null && !status.isOK()) {
            switch (status.getSeverity()) {
                case 1: {
                    this.setMessage(status.getMessage(), 1);
                    break;
                }
                case 2: {
                    this.setMessage(status.getMessage(), 2);
                    break;
                }
                default: {
                    this.setErrorMessage(status.getMessage());
                }
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private boolean isValidClassOnClasspath(String className) {
        IType testClass;
        IJavaProject javaProject = JavaCore.create((IProject)SwitchyardSCAEditor.getActiveEditor().getTargetModelFile().getProject());
        try {
            testClass = javaProject.findType(className);
        }
        catch (JavaModelException javaModelException) {
            testClass = null;
        }
        return testClass != null;
    }

    protected INewTransformWizard getNextWizard() {
        if (this._selectedProvider == null || !this._selectedProvider.providesWizard()) {
            return null;
        }
        INewTransformWizard providerWizard = this._providerWizards.get(this._selectedProvider);
        if (providerWizard == null) {
            providerWizard = this._selectedProvider.createWizard();
            providerWizard.init(this._project);
            providerWizard.setSelectedTransforms(this.getSelectedTransforms());
            providerWizard.addPages();
            this._providerWizards.put(this._selectedProvider, providerWizard);
        }
        return providerWizard;
    }

    private Collection<TransformType> getSelectedTransforms() {
        if (this._fromCombo.getCombo().getText().isEmpty() || this._toCombo.getCombo().getText().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TransformType> transforms = new ArrayList<TransformType>(1);
        String fromType = this._fromCombo.getCombo().getText();
        String toType = this._toCombo.getCombo().getText();
        JAXBTransformType newTransform = TransformFactory.eINSTANCE.createJAXBTransformType();
        newTransform.setTo(toType);
        newTransform.setFrom(fromType);
        transforms.add((TransformType)newTransform);
        return transforms;
    }

    private static final class TransformDetailsContentProvider
    implements IStructuredContentProvider {
        private TransformDetailsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((TransformDetails)inputElement).getRequiredTransforms().toArray();
        }
    }

    private static final class TransformTypeFromLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        private TransformTypeFromLabelProvider() {
        }

        public String getText(Object element) {
            QName qname = QName.valueOf(((TransformType)element).getFrom());
            return qname.toString();
        }
    }

    private static final class TransformTypeToLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        private TransformTypeToLabelProvider() {
        }

        public String getText(Object element) {
            QName qname = QName.valueOf(((TransformType)element).getTo());
            return qname.toString();
        }
    }
}

