/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class InterfaceChangeDialog
extends TitleAreaDialog
implements ISelectionProvider {
    private InterfaceControl _interfaceControl;
    private Contract _service;
    private Interface _originalInterface;
    private Set<ISelectionChangedListener> _listeners = new LinkedHashSet<ISelectionChangedListener>();

    private static Set<InterfaceControl.InterfaceType> getSupportedInterfaceTypes(Interface original) {
        if (original.eContainer() == null || !(original.eContainer().eContainer() instanceof Component)) {
            return EnumSet.allOf(InterfaceControl.InterfaceType.class);
        }
        return ComponentTypeExtensionManager.getSupportedInterfaceTypes((Component)original.eContainer().eContainer());
    }

    public InterfaceChangeDialog(Shell parentShell, IContainer container, Interface originalIntfc) {
        super(parentShell);
        this._originalInterface = originalIntfc;
        this._interfaceControl = new InterfaceControl(null, InterfaceChangeDialog.getSupportedInterfaceTypes(originalIntfc));
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.title_editInterface);
        this.setMessage(Messages.description_editInterface);
        this.getShell().setText(Messages.title_editInterface);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(1808));
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        IProject project = null;
        IJavaProject javaProject = null;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (modelFile != null) {
            selectionToPass = new StructuredSelection((Object)modelFile);
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
            javaProject = JavaCore.create((IProject)project);
        }
        this._interfaceControl.createControl(composite, nColumns);
        this._interfaceControl.setProject(javaProject);
        this._interfaceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Interface intf = InterfaceChangeDialog.this._interfaceControl.getInterface();
                if (intf != null) {
                    InterfaceChangeDialog.this.validate();
                    InterfaceChangeDialog.this.fireSelectionChanged();
                }
            }
        });
        return parent;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public ISelection getSelection() {
        Interface intfc = this._interfaceControl.getInterface();
        return new StructuredSelection((Object)intfc);
    }

    public void setSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        this._service = (Contract)((IStructuredSelection)selection).getFirstElement();
        if (this._service.getInterface() != null) {
            Interface intfc = this._service.getInterface();
            this._interfaceControl.setSelection((ISelection)new StructuredSelection((Object)intfc));
        }
    }

    private void fireSelectionChanged() {
        LinkedHashSet<ISelectionChangedListener> listeners = new LinkedHashSet<ISelectionChangedListener>(this._listeners);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : listeners) {
            try {
                listener.selectionChanged(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void validate() {
        Interface intfc;
        this.setMessage(null);
        this.setErrorMessage(null);
        IStatus status = this._interfaceControl.getStatus();
        switch (status.getSeverity()) {
            case 4: {
                this.setErrorMessage(status.getMessage());
            }
        }
        if (this.getErrorMessage() == null) {
            this.setMessage(Messages.info_specifyInterfaceDetails);
        }
        if ((intfc = this._interfaceControl.getInterface()).equals(this._originalInterface)) {
            this.setMessage(Messages.info_specifyInterfaceDetailsDefaultSelected);
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(this.getErrorMessage() == null);
        }
    }
}

