/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAOutboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.JcaPackage;
import org.switchyard.tools.models.switchyard1_0.jca.Processor;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.jca.AbstractJCABindingComposite;
import org.switchyard.tools.ui.editor.components.jca.IJCAEndpointPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCACCIProcessorPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCACustomProcessorPropertiesExtension;
import org.switchyard.tools.ui.editor.components.jca.JCAJMSProcessorPropertiesExtension;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class JCABindingOutboundComposite
extends AbstractSYBindingComposite {
    private Map<ProcessorType, AbstractJCABindingComposite> _extensionComposites = new HashMap<ProcessorType, AbstractJCABindingComposite>();
    private ProcessorType _activeExtension;
    private Composite _panel;
    private JCABinding _binding = null;
    private Text _nameText;
    private Combo _resourceAdapterText;
    private Composite _stackComposite;
    private StackLayout _stackLayout;
    private WritableValue _bindingValue;
    private ComboViewer _processorMappingTypeCombo;

    JCABindingOutboundComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_jcaBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_jcaBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        this._binding = impl instanceof JCABinding ? (JCABinding)impl : null;
        this._bindingValue.setValue((Object)this._binding);
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getJCATabControl(this._panel, context);
        this.bindControls(context);
    }

    private Control getJCATabControl(Composite tabFolder, DataBindingContext context) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._resourceAdapterText = this.createLabelAndCombo(composite, Messages.label_resourceAdapterArchive, false);
        this._resourceAdapterText.add("hornetq-ra.rar");
        this._processorMappingTypeCombo = new ComboViewer(this.createLabelAndCombo(composite, "Processor Type", true));
        this._processorMappingTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._processorMappingTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProcessorType)((Object)element)).getLabel();
            }
        });
        this._processorMappingTypeCombo.setInput((Object)ProcessorType.values());
        this._processorMappingTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JCABindingOutboundComposite.this.processProcessorComboSelection();
            }
        });
        this._stackComposite = this.getToolkit().createComposite(composite, 0);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        this._stackComposite.setLayoutData((Object)gd);
        this._stackLayout = new StackLayout();
        this._stackComposite.setLayout((Layout)this._stackLayout);
        Composite dummy = this.getToolkit().createComposite(this._stackComposite, 0);
        this._stackLayout.topControl = dummy;
        ProcessorType[] processorTypeArray = ProcessorType.values();
        int n = processorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessorType processorType = processorTypeArray[n2];
            AbstractJCABindingComposite processorComposite = processorType.createComposite(this.getToolkit());
            processorComposite.setTargetObject(this.getTargetObject());
            processorComposite.createContents(this._stackComposite, 0, context);
            processorComposite.setBinding(null);
            this._extensionComposites.put(processorType, processorComposite);
            ++n2;
        }
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._stackComposite.getDisplay());
        this._bindingValue = new WritableValue(realm, null, JCABinding.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JCA binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath batchTimeoutFeaturePath = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__OUTBOUND_CONNECTION, JcaPackage.Literals.JCA_OUTBOUND_CONNECTION__RESOURCE_ADAPTER, JcaPackage.Literals.RESOURCE_ADAPTER__NAME});
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._resourceAdapterText), EMFProperties.value((FeaturePath)batchTimeoutFeaturePath).observeDetail((IObservableValue)this._bindingValue), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT, domain, (IObservableValue)this._bindingValue, batchTimeoutFeaturePath, true), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        IObservableValue processorType = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JcaPackage.Literals.JCA_BINDING__OUTBOUND_INTERACTION, JcaPackage.Literals.JCA_OUTBOUND_INTERACTION__PROCESSOR, JcaPackage.Literals.PROCESSOR__TYPE}));
        processorType.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ProcessorType newExtension = ProcessorType.fromProcessorType((String)event.diff.getNewValue());
                if (newExtension != JCABindingOutboundComposite.this._activeExtension) {
                    JCABindingOutboundComposite.this.swapExtensionComposites(newExtension, false);
                    JCABindingOutboundComposite.this._processorMappingTypeCombo.setSelection((ISelection)new StructuredSelection((Object)newExtension), true);
                } else {
                    JCABindingOutboundComposite.this._processorMappingTypeCombo.setSelection((ISelection)new StructuredSelection((Object)newExtension), true);
                }
            }
        });
    }

    private void processProcessorComboSelection() {
        IStructuredSelection selection = (IStructuredSelection)this._processorMappingTypeCombo.getSelection();
        this.swapExtensionComposites(selection.isEmpty() ? null : (ProcessorType)((Object)selection.getFirstElement()), true);
    }

    private void swapExtensionComposites(final ProcessorType newExtension, final boolean updateValues) {
        if (newExtension == null) {
            return;
        }
        TransactionalEditingDomain domain = this.getDomain((EObject)this._binding);
        if (updateValues && domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Change JCA processor type"){

                protected void doExecute() {
                    JCABindingOutboundComposite.this.deactivateExtension(JCABindingOutboundComposite.this._activeExtension);
                    JCABindingOutboundComposite.this.activateExtension(newExtension, updateValues);
                }
            });
        } else {
            this.deactivateExtension(this._activeExtension);
            this.activateExtension(newExtension, updateValues);
        }
        this._activeExtension = newExtension;
        AbstractJCABindingComposite processorComposite = this._extensionComposites.get((Object)newExtension);
        this._stackLayout.topControl = processorComposite.getPanel();
        this._stackComposite.layout();
        if (this._stackComposite.getParent() != null) {
            this._stackComposite.getParent().layout();
        }
    }

    private void activateExtension(ProcessorType extension, boolean updateValues) {
        if (extension == null) {
            return;
        }
        if (updateValues) {
            Processor processor;
            JCAOutboundInteraction interaction = this._binding.getOutboundInteraction();
            if (interaction == null) {
                interaction = JcaFactory.eINSTANCE.createJCAOutboundInteraction();
                this._binding.setOutboundInteraction(interaction);
            }
            if ((processor = interaction.getProcessor()) == null) {
                processor = JcaFactory.eINSTANCE.createProcessor();
                interaction.setProcessor(processor);
            }
            processor.setType(extension.getProcessorType());
        }
        this._extensionComposites.get((Object)extension).setBinding((Binding)this._binding);
    }

    private void deactivateExtension(ProcessorType extension) {
        if (extension == null) {
            return;
        }
        AbstractJCABindingComposite extensionComposite = this._extensionComposites.get((Object)extension);
        extensionComposite.setBinding(null);
    }

    public IResource browse(Shell shell, IJavaProject project) {
        IResource result;
        ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(shell, (IContainer)(project == null ? ResourcesPlugin.getWorkspace().getRoot() : project.getProject()));
        dialog.setInitialPattern("*.jar,*.rar");
        if (dialog.open() == 0 && (result = (IResource)dialog.getFirstResult()) != null) {
            this._resourceAdapterText.setText(result.getName());
            return result;
        }
        return null;
    }

    private static enum ProcessorType {
        JMS("JMS Processor", "org.switchyard.component.jca.processor.JMSProcessor", new JCAJMSProcessorPropertiesExtension()),
        CCI("CCI Processor", "org.switchyard.component.jca.processor.CCIProcessor", new JCACCIProcessorPropertiesExtension()),
        CUSTOM("Custom Processor", null, new JCACustomProcessorPropertiesExtension());

        private final String _label;
        private final String _processorType;
        private final IJCAEndpointPropertiesExtension _extension;

        private ProcessorType(String label, String processorType, IJCAEndpointPropertiesExtension extension) {
            this._label = label;
            this._processorType = processorType;
            this._extension = extension;
        }

        public String getLabel() {
            return this._label;
        }

        public String getProcessorType() {
            return this._processorType;
        }

        public AbstractJCABindingComposite createComposite(FormToolkit toolkit) {
            return this._extension.createComposite(toolkit);
        }

        public static ProcessorType fromProcessorType(String processorType) {
            if (ProcessorType.JMS._processorType.equals(processorType)) {
                return JMS;
            }
            if (ProcessorType.CCI._processorType.equals(processorType)) {
                return CCI;
            }
            return CUSTOM;
        }
    }
}

