/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.binding;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.core.CamelBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.core.CorePackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.CompoundValidator;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.databinding.URLValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class CamelComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelBindingType _binding = null;
    private Text _nameText;
    private Text _configURIText;
    private OperationSelectorComposite _opSelectorComposite;
    private WritableValue _bindingValue;

    CamelComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_camelBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_camelBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelBindingType) {
            this._binding = (CamelBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
                this._opSelectorComposite.setTargetObject(this.getTargetObject());
                this._opSelectorComposite.setBinding((Binding)this._binding);
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        if (this.getRootGridData() != null) {
            this._panel.setLayoutData((Object)this.getRootGridData());
        }
        this.getCamelTabControl(this._panel);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service && this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        this.bindControls(context);
    }

    private Control getCamelTabControl(Composite tabFolder) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._configURIText = this.createLabelAndText(composite, Messages.label_configUriStar);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service) {
            this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
            this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
            this._opSelectorComposite.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CamelComposite.this.handleModify((Control)CamelComposite.this._opSelectorComposite);
                }
            });
        }
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals((Object)this._opSelectorComposite)) {
            this.fireChangedEvent((Object)this._opSelectorComposite);
        }
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Camel binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Camel binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        IObservableValue configURIValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)CorePackage.Literals.CAMEL_BINDING_TYPE__CONFIG_URI);
        CompoundValidator uriValidator = new CompoundValidator(new StringEmptyValidator(Messages.error_configUriMayNotBeEmpty), new URLValidator("Potential problem with Camel URI"));
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._configURIText, (int[])new int[]{24}), configURIValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(uriValidator), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this._opSelectorComposite != null) {
            this._opSelectorComposite.bindControls(domain, context);
        }
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

