/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMPackage;
import org.switchyard.tools.models.switchyard1_0.bpm.RemoteRestType;
import org.switchyard.tools.ui.bpmn2.component.BpmExtraJaxbClassesTable;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;
import org.switchyard.tools.ui.editor.util.PropTypeUtil;

public class RemoteRestContainerDetailsComposite
extends AbstractChangeAwareModelComposite<BPMImplementationType> {
    private static final Pattern GAV_PATTERN = Pattern.compile("([^: ]*)(:([^: ]*)(:([^: ]*))?)?");
    private RemoteRestType _remoteREST = BPMFactory.eINSTANCE.createRemoteRestType();
    private boolean _updating;
    private Text _deploymentIdText;
    private Text _userNameText;
    private Text _passwordText;
    private Text _timeoutText;
    private Text _urlText;
    private Combo _useFormBasedAuthCombo;
    private BpmExtraJaxbClassesTable _extraJaxbClassesTable;

    public RemoteRestContainerDetailsComposite(ICompositeContainer container, Composite parent, int style, FormToolkit factory) {
        super(BPMImplementationType.class, container, parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Composite deploymentIdComposite = factory.createComposite((Composite)this);
        deploymentIdComposite.setLayout((Layout)new GridLayout(2, false));
        deploymentIdComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        factory.createLabel(deploymentIdComposite, "Deployment ID");
        this._deploymentIdText = factory.createText(deploymentIdComposite, "", 2048);
        this._deploymentIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._deploymentIdText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_DeploymentId());
        Group restGroup = new Group((Composite)this, 0);
        restGroup.setText("REST Details");
        restGroup.setLayout((Layout)new GridLayout(2, false));
        restGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        restGroup.setToolTipText("Details for the remote REST resources location");
        factory.createLabel(deploymentIdComposite, "REST URL");
        this._urlText = factory.createText(deploymentIdComposite, "", 2048);
        this._urlText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._urlText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteRestType_Url());
        factory.createLabel((Composite)restGroup, "User Name");
        this._userNameText = factory.createText((Composite)restGroup, "", 2048);
        this._userNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._userNameText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_UserName());
        factory.createLabel((Composite)restGroup, "Password");
        this._passwordText = factory.createText((Composite)restGroup, "", 2048);
        this._passwordText.setEchoChar('*');
        this._passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._passwordText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_Password());
        factory.createLabel((Composite)restGroup, "Timeout");
        this._timeoutText = factory.createText((Composite)restGroup, "", 2048);
        this._timeoutText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._timeoutText, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteType_Timeout());
        factory.createLabel((Composite)restGroup, "Use Form Based Authentication");
        this._useFormBasedAuthCombo = new Combo((Composite)restGroup, 2052);
        factory.adapt((Composite)this._useFormBasedAuthCombo);
        this._useFormBasedAuthCombo.add("true");
        this._useFormBasedAuthCombo.add("false");
        this._useFormBasedAuthCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addModifyText((Control)this._useFormBasedAuthCombo, (EStructuralFeature)BPMPackage.eINSTANCE.getRemoteRestType_UseFormBasedAuth());
        Composite actionsComposite = factory.createComposite((Composite)this);
        actionsComposite.setLayout((Layout)new GridLayout());
        GridData tableGD = new GridData(4, 4, true, true, 2, 4);
        actionsComposite.setLayoutData((Object)tableGD);
        Section actionsSection = factory.createSection(actionsComposite, 320);
        actionsSection.setText("Extra JAXB Classes");
        actionsSection.setLayout((Layout)new GridLayout());
        actionsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this._extraJaxbClassesTable = new BpmExtraJaxbClassesTable((Composite)actionsSection, 0);
        this._extraJaxbClassesTable.setLayoutData(new GridData(4, 4, true, true));
        factory.adapt((Composite)this._extraJaxbClassesTable);
        actionsSection.setClient((Control)this._extraJaxbClassesTable);
    }

    public void setRemoteREST(RemoteRestType remoteREST) {
        if (remoteREST == null) {
            remoteREST = BPMFactory.eINSTANCE.createRemoteRestType();
        }
        this._remoteREST = remoteREST;
        this._updating = true;
        this._deploymentIdText.setText(this._remoteREST.getDeploymentId() == null ? "" : this._remoteREST.getDeploymentId());
        this._passwordText.setText(this._remoteREST.getPassword() == null ? "" : this._remoteREST.getPassword());
        this._urlText.setText(this._remoteREST.getUrl() == null ? "" : this._remoteREST.getUrl());
        String timeoutValue = PropTypeUtil.getPropValueString((Object)this._remoteREST.getTimeout());
        this._timeoutText.setText(timeoutValue == null ? "" : timeoutValue);
        this._userNameText.setText(this._remoteREST.getUserName() == null ? "" : this._remoteREST.getUserName());
        String formBasedAuthValue = PropTypeUtil.getPropValueString((Object)this._remoteREST.getUseFormBasedAuth());
        this._useFormBasedAuthCombo.setText(formBasedAuthValue == null ? "" : formBasedAuthValue);
        this._extraJaxbClassesTable.setTargetObject((EObject)this._remoteREST);
        this._updating = false;
    }

    public RemoteRestType getRemoteREST() {
        return this._remoteREST;
    }

    protected void wrapOperation(final Runnable runner) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this._remoteREST);
        if (domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        runner.run();
                    }
                    catch (Exception e) {
                        Activator.logError((Exception)e);
                    }
                }
            });
        } else {
            try {
                runner.run();
            }
            catch (Exception e) {
                Activator.logError((Exception)e);
            }
        }
    }

    private void handleTextChange(Text text, final EObject eobj, final EStructuralFeature feature) {
        String newValue;
        String string = newValue = text.getText().length() == 0 ? null : text.getText();
        if (!this._updating && (newValue == null && eobj.eGet(feature) != null || newValue != null && !newValue.equals(eobj.eGet(feature)))) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    eobj.eSet(feature, (Object)newValue);
                }
            });
            this.fireChangedEvent((Object)this);
            if (this.getContainer() != null) {
                this.getContainer().validated(this.validate());
            }
        }
    }

    private void handleComboChange(Combo combo, final EObject eobj, final EStructuralFeature feature) {
        String newValue;
        String string = newValue = combo.getText().length() == 0 ? null : combo.getText();
        if (!this._updating && (newValue == null && eobj.eGet(feature) != null || newValue != null && !newValue.equals(eobj.eGet(feature)))) {
            this.wrapOperation(new Runnable(){

                @Override
                public void run() {
                    eobj.eSet(feature, (Object)newValue);
                }
            });
            this.fireChangedEvent((Object)this);
            if (this.getContainer() != null) {
                this.getContainer().validated(this.validate());
            }
        }
    }

    public void refresh() {
        if (((BPMImplementationType)this.getTargetObject()).getManifest() != null) {
            this.setRemoteREST(((BPMImplementationType)this.getTargetObject()).getManifest().getRemoteRest());
        }
    }

    private void addModifyText(Control control, final EStructuralFeature feature) {
        if (control instanceof Text) {
            final Text text = (Text)control;
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RemoteRestContainerDetailsComposite.this.handleTextChange(text, (EObject)RemoteRestContainerDetailsComposite.this.getRemoteREST(), feature);
                }
            });
        } else if (control instanceof Combo) {
            final Combo combo = (Combo)control;
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RemoteRestContainerDetailsComposite.this.handleComboChange(combo, (EObject)RemoteRestContainerDetailsComposite.this.getRemoteREST(), feature);
                }
            });
        }
    }

    public IStatus validate() {
        String errMessage = null;
        if (this.getRemoteREST() != null) {
            if (this.getRemoteREST().getDeploymentId() == null || this.getRemoteREST().getDeploymentId().trim().isEmpty()) {
                errMessage = "Deployment ID must be specified.";
            } else if (!this.getRemoteREST().getDeploymentId().matches(GAV_PATTERN.toString())) {
                errMessage = "Deployment ID must be specified in the GAV pattern - 'groupID:artifactId:version'.";
            } else if (this.getRemoteREST().getUrl() == null || this.getRemoteREST().getUrl().trim().isEmpty()) {
                errMessage = "REST URL must be specified.";
            } else if (this.getRemoteREST().getUrl() != null) {
                try {
                    new URL(this.getRemoteREST().getUrl());
                }
                catch (MalformedURLException e) {
                    errMessage = e.getLocalizedMessage();
                }
            }
        }
        if (errMessage != null) {
            return new Status(4, "org.switchyard.tools.ui.editor", errMessage);
        }
        return Status.OK_STATUS;
    }
}

