/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMOperationType;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMPackage;
import org.switchyard.tools.models.switchyard1_0.bpm.InputMappingType;
import org.switchyard.tools.models.switchyard1_0.bpm.InputsType;
import org.switchyard.tools.models.switchyard1_0.bpm.LoggerType1;
import org.switchyard.tools.models.switchyard1_0.bpm.LoggersType;
import org.switchyard.tools.models.switchyard1_0.bpm.ManifestType;
import org.switchyard.tools.models.switchyard1_0.bpm.MappingType;
import org.switchyard.tools.models.switchyard1_0.bpm.OperationType;
import org.switchyard.tools.models.switchyard1_0.bpm.OutputsType;
import org.switchyard.tools.models.switchyard1_0.bpm.ResourceType;
import org.switchyard.tools.models.switchyard1_0.bpm.ResourcesType;
import org.switchyard.tools.ui.bpmn2.Messages;
import org.switchyard.tools.ui.bpmn2.component.NewBPMProcessDetailsWizardPage;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.diagram.shared.BaseNewServiceFileWizard;

public class NewBPMComponentWizard
extends BaseNewServiceFileWizard
implements INewWizard {
    private static final String TEMPLATE = "ProcessTemplate.ftl";
    private static final String PACKAGE_NAME_PARAM = "packageName";
    private static final String PROCESS_NAME_PARAM = "processName";
    private static final String PROCESS_ID_PARAM = "processID";
    private static final String MESSAGE_IN_NAME_PARAM = "messageInName";
    private static final String MESSAGE_OUT_NAME_PARAM = "messageOutName";
    private BPMImplementationType _implementation;
    private NewBPMProcessDetailsWizardPage _processPage;

    public NewBPMComponentWizard(boolean openAfterCreate) {
        super(openAfterCreate, "bpmn");
    }

    public void addPages() {
        super.addPages();
        WizardNewFileCreationPage page = this.getFileCreationPage();
        page.setTitle(Messages.title_newSwitchYardBpmnFile);
        page.setDescription(Messages.description_newSwitchYardBpmnFile);
        if (this.getService() == null) {
            page.setFileName("ProcessComponent.bpmn");
        } else {
            page.setFileName(this.getService().getName() + "Process.bpmn");
        }
        this._processPage = new NewBPMProcessDetailsWizardPage(NewBPMProcessDetailsWizardPage.class.getCanonicalName());
        this.addPage((IWizardPage)this._processPage);
    }

    public boolean performFinish() {
        this._implementation = BPMFactory.eINSTANCE.createBPMImplementationType();
        this._implementation.setProcessId(this._processPage.getProcessId());
        BPMOperationType startAction = BPMFactory.eINSTANCE.createBPMOperationType();
        startAction.setType(OperationType.STARTPROCESS);
        if (this._processPage.getMessageInName() == null) {
            startAction.setInputs(null);
        } else {
            InputsType inputs = BPMFactory.eINSTANCE.createInputsType();
            InputMappingType inputMapping = BPMFactory.eINSTANCE.createInputMappingType();
            inputMapping.setFrom("message.content");
            inputMapping.setTo(this._processPage.getMessageInName());
            inputMapping.setOutput(null);
            inputs.getInput().add((Object)inputMapping);
            startAction.setInputs(inputs);
        }
        if (this._processPage.getMessageOutName() == null) {
            startAction.setOutputs(null);
        } else {
            OutputsType outputs = BPMFactory.eINSTANCE.createOutputsType();
            MappingType outputMapping = BPMFactory.eINSTANCE.createMappingType();
            outputMapping.setFrom(this._processPage.getMessageOutName());
            outputMapping.setTo("message.content");
            outputs.getOutput().add((Object)outputMapping);
            startAction.setOutputs(outputs);
        }
        this._implementation.setOperations(BPMFactory.eINSTANCE.createOperationsType());
        this._implementation.getOperations().getOperation().add((Object)startAction);
        this._implementation.setPersistent(this._processPage.isPersistent());
        if (this._processPage.isAuditingEnabled()) {
            LoggerType1 auditSettings = this._processPage.getAuditSettings();
            if (auditSettings.getLog() == null) {
                auditSettings.eUnset((EStructuralFeature)BPMPackage.eINSTANCE.getLoggerType1_Log());
            }
            LoggersType loggersType = BPMFactory.eINSTANCE.createLoggersType();
            loggersType.getLogger().add((Object)auditSettings);
            this._implementation.setLoggers(loggersType);
        } else {
            this._implementation.setLoggers(null);
        }
        if (!super.performFinish()) {
            return false;
        }
        ManifestType manifest = BPMFactory.eINSTANCE.createManifestType();
        ResourcesType resources = BPMFactory.eINSTANCE.createResourcesType();
        ResourceType resource = BPMFactory.eINSTANCE.createResourceType();
        resource.setLocation(this.getCreatedFilePath());
        resource.setType("BPMN2");
        resources.getResource().add((Object)resource);
        manifest.setResources(resources);
        this._implementation.setManifest(manifest);
        return true;
    }

    protected Implementation createImplementation() {
        return this._implementation;
    }

    protected List<ComponentReference> createReferences() {
        return Collections.emptyList();
    }

    public boolean canFinish() {
        this._processPage.update(this.getJavaProject(), this.getFileCreationPage().getFileName(), this.getService());
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        return nextPage;
    }

    protected InputStream getInitialContents() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "");
            config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template template = config.getTemplate(TEMPLATE);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(PACKAGE_NAME_PARAM, this._processPage.getPackageName());
            parameters.put(PROCESS_NAME_PARAM, this._processPage.getProcessName());
            parameters.put(PROCESS_ID_PARAM, this._processPage.getProcessId());
            parameters.put(MESSAGE_IN_NAME_PARAM, this._processPage.getMessageInName() == null ? "Parameter" : this._processPage.getMessageInName());
            parameters.put(MESSAGE_OUT_NAME_PARAM, this._processPage.getMessageOutName() == null ? "Result" : this._processPage.getMessageOutName());
            template.process(parameters, (Writer)new PrintWriter(baos));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_errorCreatingBpmn2File, (Throwable)e));
            return null;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
    }
}

