/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.part;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.layout.DiagramLayout;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlPackageNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.mapping.ui.editor.MappingAdapterFilter;
import org.teiid.designer.mapping.ui.editor.MappingDiagramController;
import org.teiid.designer.mapping.ui.editor.MappingExtent;
import org.teiid.designer.mapping.ui.model.MappingDiagramNode;
import org.teiid.designer.mapping.ui.model.MappingExtentNode;
import org.teiid.designer.mapping.ui.util.MappingUiUtil;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.InputSet;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.transformation.impl.MappingClassImpl;
import org.teiid.designer.transformation.ui.model.TransformationNode;
import org.teiid.designer.xsd.util.ModelerXsdUtils;

public class MappingDiagramLayout
extends DiagramLayout {
    public static final int TOP_MARGIN = 50;
    public static final int LEFT_PANEL_RIGHT_MARGIN = 30;
    public static final int RIGHT_PANEL_LEFT_MARGIN = 30;
    public static final int TABLE_GAP = 20;
    public static final int MAPPING_CLASS_MARGIN = 120;
    public static final int LEVEL_INCREMENT = 10;
    private boolean detailedMapping = false;
    private DiagramModelNode modelRoot = null;
    private DiagramModelNode transformationNode = null;
    private DiagramModelNode diagramModelNode = null;
    private List stagingTableNodes = null;
    private boolean bIsCoarseMapping = false;

    public MappingDiagramLayout() {
    }

    public MappingDiagramLayout(DiagramModelNode mappingDiagramModelNode, boolean bIsCoarseMapping) {
        super(Collections.EMPTY_LIST);
        this.bIsCoarseMapping = bIsCoarseMapping;
        this.init(mappingDiagramModelNode);
    }

    public int run(int startingX, int startingY) {
        this.layoutTransformation(startingX, startingY);
        return 0;
    }

    private void init(DiagramModelNode diagramModelNode) {
        this.diagramModelNode = diagramModelNode;
        if (((Diagram)diagramModelNode.getModelObject()).getType() != null && ((Diagram)diagramModelNode.getModelObject()).getType().equals("mappingTransformationDiagramType")) {
            this.detailedMapping = true;
        }
        this.setTransformation(this.getTransformationNode());
        this.modelRoot = this.getRootNode();
        this.resetAllExtentNodes();
        this.setSourceNodes();
        this.setStagingTableNodes();
    }

    public boolean isDetailedMapping() {
        return this.detailedMapping;
    }

    public void setTransformation(DiagramModelNode transNode) {
        this.transformationNode = transNode;
    }

    private void layoutTransformation(int startingX, int startY) {
        int transX = 0;
        int transY = 0;
        int stackX = 0;
        int stackHeight = this.getStackHeight();
        int startingY = Math.max(startY, 50);
        int initialY = 10;
        if (this.modelRoot != null) {
            this.modelRoot.setPosition(new Point(120, startingY));
            transY = this.modelRoot.getY();
            transX = 120 + this.modelRoot.getWidth() + 30 - this.transformationNode.getWidth() / 2;
            this.transformationNode.setPosition(new Point(transX, transY));
            initialY = transY + this.transformationNode.getHeight() / 2 - stackHeight / 2;
            if (initialY < 10) {
                initialY = 10;
            }
            stackX = 120 + this.modelRoot.getWidth() + 30 + 30;
        } else {
            stackX = 120;
        }
        int maxStackX = stackX;
        if (this.getComponentCount() > 0) {
            DiagramModelNode[] nodeArray = this.getNodeArray();
            int currentY = startingY;
            int nNodes = nodeArray.length;
            DiagramModelNode inputSetNode = this.getInputSetNode();
            if (inputSetNode != null) {
                inputSetNode.setPosition(new Point(stackX, currentY));
                stackX += inputSetNode.getWidth() + 20;
            }
            int i = 0;
            while (i < nNodes) {
                DiagramModelNode next = nodeArray[i];
                if (!this.isInputSet(next)) {
                    if (this.isDetailedMapping()) {
                        if (next != null && !this.isRootNode(next)) {
                            next.setPosition(new Point(stackX, currentY));
                            stackX += next.getWidth() + 20;
                        }
                    } else if (next != null && !this.isStagingTable(next)) {
                        int deltaX = this.getLevel(next) * 10;
                        next.setPosition(new Point(stackX + deltaX, currentY));
                        currentY += next.getSize().height + 20;
                        maxStackX = Math.max(maxStackX, stackX + next.getWidth());
                    }
                }
                ++i;
            }
        }
        if (!this.detailedMapping && this.stagingTableNodes != null && !this.stagingTableNodes.isEmpty()) {
            maxStackX += 50;
            Iterator stIter = this.stagingTableNodes.iterator();
            DiagramModelNode extentNode = null;
            DiagramModelNode nextNode = null;
            while (stIter.hasNext()) {
                nextNode = (DiagramModelNode)stIter.next();
                extentNode = this.getExtentNodeForStagingTable(nextNode);
                int deltaX = this.getLevel(nextNode) * 10;
                if (extentNode == null) continue;
                int xPos = maxStackX + deltaX;
                ((MappingExtentNode)extentNode).update("size");
                nextNode.setPosition(new Point(xPos, extentNode.getY()));
            }
            this.stackStagingTables();
        }
        if (MappingUiUtil.isLogicalModelType((Diagram)this.diagramModelNode.getModelObject())) {
            maxStackX += 50;
            HashMap typeNodesProcessedMap = new HashMap();
            List mappingClasses = this.getOrderedMappingClassList();
            Map mappingClassTypeNodesMap = this.getMappingClassEnumeratedTypeNodesMap();
            if (!mappingClassTypeNodesMap.isEmpty()) {
                EObject mc = null;
                List enumNodes = null;
                DiagramModelNode mcNode = null;
                DiagramModelNode prevTypeNode = null;
                int numMapClasses = mappingClasses.size();
                int i = 0;
                while (i < numMapClasses) {
                    mc = (EObject)mappingClasses.get(i);
                    enumNodes = (List)mappingClassTypeNodesMap.get(mc);
                    if (enumNodes != null && !enumNodes.isEmpty() && (mcNode = DiagramUiUtilities.getModelNode((EObject)mc, (DiagramModelNode)this.diagramModelNode)) != null) {
                        int numNodes = enumNodes.size();
                        int j = 0;
                        while (j < numNodes) {
                            DiagramModelNode typeNode = (DiagramModelNode)enumNodes.get(j);
                            if (!typeNodesProcessedMap.containsKey(typeNode)) {
                                int y = mcNode.getY();
                                typeNodesProcessedMap.put(typeNode, null);
                                if (prevTypeNode != null) {
                                    y = Math.max(prevTypeNode.getY() + prevTypeNode.getHeight() + 10, y);
                                }
                                prevTypeNode = typeNode;
                                typeNode.setPosition(new Point(maxStackX, y));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public DiagramModelNode[] getNodeArray() {
        DiagramModelNode[] nodeArray = super.getNodeArray();
        if (!this.bIsCoarseMapping) {
            return nodeArray;
        }
        int iTotalDiagramNodes = nodeArray.length;
        int iDiagramNodesMapped = 0;
        DiagramModelNode[] orderedNodeArray = new DiagramModelNode[this.getComponentCount()];
        Iterator it = this.getOrderedMappingClassList().iterator();
        block0: while (it.hasNext() && iDiagramNodesMapped < iTotalDiagramNodes) {
            MappingClassImpl mc = (MappingClassImpl)it.next();
            if (mc == null) continue;
            DiagramModelNode nextNode = null;
            int i = 0;
            while (i < nodeArray.length) {
                nextNode = nodeArray[i];
                if (nextNode instanceof UmlClassifierNode && nextNode.getModelObject() == mc) {
                    orderedNodeArray[iDiagramNodesMapped] = nextNode;
                    ++iDiagramNodesMapped;
                    continue block0;
                }
                ++i;
            }
        }
        return orderedNodeArray;
    }

    private DiagramModelNode[] getEnumeratedTypeNodes() {
        DiagramModelNode[] result = null;
        DiagramModelNode[] nodeArray = super.getNodeArray();
        if (nodeArray.length != 0) {
            ArrayList<DiagramModelNode> temp = new ArrayList<DiagramModelNode>();
            int i = 0;
            while (i < nodeArray.length) {
                if (ModelerXsdUtils.isEnumeratedType((EObject)nodeArray[i].getModelObject())) {
                    temp.add(nodeArray[i]);
                }
                ++i;
            }
            if (!temp.isEmpty()) {
                result = new DiagramModelNode[temp.size()];
                temp.toArray(result);
            }
        }
        if (result == null) {
            result = new DiagramModelNode[]{};
        }
        return result;
    }

    private Map getMappingClassEnumeratedTypeNodesMap() {
        DiagramModelNode[] enumTypeNodes = this.getEnumeratedTypeNodes();
        HashMap result = null;
        if (enumTypeNodes.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            List mappingClasses = this.getOrderedMappingClassList();
            result = new HashMap();
            int numMappingClasses = mappingClasses.size();
            int i = 0;
            while (i < numMappingClasses) {
                MappingClass mc = (MappingClass)mappingClasses.get(i);
                EList cols = mc.getColumns();
                if (!cols.isEmpty()) {
                    int numCols = cols.size();
                    int j = 0;
                    while (j < numCols) {
                        MappingClassColumn col = (MappingClassColumn)cols.get(j);
                        EObject type = col.getType();
                        if (ModelerXsdUtils.isEnumeratedType((EObject)type)) {
                            int k = 0;
                            while (k < enumTypeNodes.length) {
                                if (type == enumTypeNodes[k].getModelObject()) {
                                    ArrayList<DiagramModelNode> typeNodes = (ArrayList<DiagramModelNode>)result.get(mc);
                                    if (typeNodes == null) {
                                        typeNodes = new ArrayList<DiagramModelNode>();
                                        result.put(mc, typeNodes);
                                    }
                                    if (typeNodes.contains(enumTypeNodes[k])) break;
                                    typeNodes.add(enumTypeNodes[k]);
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private void setSourceNodes() {
        Iterator iter = this.getCurrentSourceNodes().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (this.isDetailedMapping()) {
                if (!(nextNode instanceof UmlClassifierNode)) continue;
                this.add(nextNode);
                continue;
            }
            if (!(nextNode instanceof UmlClassifierNode) || this.isStagingTable(nextNode)) continue;
            this.add(nextNode);
        }
    }

    private void setStagingTableNodes() {
        this.stagingTableNodes = Collections.EMPTY_LIST;
        if (!this.isDetailedMapping()) {
            this.stagingTableNodes = new ArrayList(10);
            Iterator iter = this.diagramModelNode.getChildren().iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                if (!this.isStagingTable(nextNode)) continue;
                this.stagingTableNodes.add(nextNode);
            }
        }
    }

    private void stackStagingTables() {
        if (this.stagingTableNodes != null || !this.stagingTableNodes.isEmpty() && this.stagingTableNodes.size() > 1) {
            this.orderStagingTableNodes();
            DiagramModelNode firstST = null;
            DiagramModelNode secondST = null;
            int firstTable = 0;
            int secondTable = 1;
            int nTables = this.stagingTableNodes.size();
            while (secondTable < nTables) {
                firstST = (DiagramModelNode)this.stagingTableNodes.get(firstTable);
                secondST = (DiagramModelNode)this.stagingTableNodes.get(secondTable);
                if (firstST.getY() + firstST.getHeight() > secondST.getY() - 10) {
                    secondST.setPosition(new Point(firstST.getX(), firstST.getY() + firstST.getHeight() + 10));
                }
                ++firstTable;
                ++secondTable;
            }
        }
    }

    private void orderStagingTableNodes() {
        if (this.stagingTableNodes != null || !this.stagingTableNodes.isEmpty()) {
            ArrayList<DiagramModelNode> sortedStagingTables = new ArrayList<DiagramModelNode>();
            boolean extentsLeftOver = true;
            while (extentsLeftOver) {
                List leftOverExtents = this.getLeftoverStagingTableExtentNodes(sortedStagingTables);
                if (!leftOverExtents.isEmpty()) {
                    DiagramModelNode lowestStagingTableNode = this.getStagingTableNodeForLowestExtentNode(leftOverExtents);
                    if (lowestStagingTableNode == null) continue;
                    sortedStagingTables.add(lowestStagingTableNode);
                    continue;
                }
                extentsLeftOver = false;
            }
            this.stagingTableNodes = new ArrayList(sortedStagingTables);
        }
    }

    private List getLeftoverStagingTableExtentNodes(List stagingTableNodes) {
        List allExtentNodes = this.getAllStagingTableExtentNodes();
        ArrayList<MappingExtentNode> leftOverExtentNodes = new ArrayList<MappingExtentNode>(allExtentNodes.size());
        if (stagingTableNodes == null || stagingTableNodes.isEmpty()) {
            leftOverExtentNodes.addAll(allExtentNodes);
        } else {
            Iterator iter = allExtentNodes.iterator();
            MappingExtentNode nextNode = null;
            DiagramModelNode nextStagingTableNode = null;
            EObject nextReference = null;
            while (iter.hasNext()) {
                nextNode = (MappingExtentNode)((Object)iter.next());
                nextReference = nextNode.getExtent().getMappingReference();
                if (nextReference != null) {
                    nextStagingTableNode = this.getStagingTable(nextReference);
                    if (nextStagingTableNode == null || stagingTableNodes.contains(nextStagingTableNode)) continue;
                    leftOverExtentNodes.add(nextNode);
                    continue;
                }
                leftOverExtentNodes.add(nextNode);
            }
        }
        if (leftOverExtentNodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return leftOverExtentNodes;
    }

    private List getAllStagingTableExtentNodes() {
        if (this.stagingTableNodes != null && !this.stagingTableNodes.isEmpty()) {
            ArrayList<DiagramModelNode> allExtentNodes = new ArrayList<DiagramModelNode>(this.stagingTableNodes.size());
            Iterator iter = this.stagingTableNodes.iterator();
            DiagramModelNode dmn = null;
            DiagramModelNode nextExtentNode = null;
            while (iter.hasNext()) {
                dmn = (DiagramModelNode)iter.next();
                if (dmn == null || (nextExtentNode = this.getExtentNodeForStagingTable(dmn)) == null) continue;
                allExtentNodes.add(nextExtentNode);
            }
            return allExtentNodes;
        }
        return Collections.EMPTY_LIST;
    }

    private DiagramModelNode getTransformationNode() {
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof TransformationNode)) continue;
            return nextNode;
        }
        return null;
    }

    private List getCurrentSourceNodes() {
        DiagramModelNode rootNode = this.getRootNode();
        ArrayList<DiagramModelNode> currentSourceNodes = new ArrayList<DiagramModelNode>();
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof UmlClassifierNode) && !(nextNode instanceof UmlPackageNode) || nextNode == rootNode) continue;
            currentSourceNodes.add(nextNode);
        }
        return currentSourceNodes;
    }

    private DiagramModelNode getRootNode() {
        EObject targetObject;
        Diagram diagram;
        DiagramModelNode root = null;
        DiagramModelNode transformationModelNode = this.getTransformationNode();
        if (transformationModelNode != null && (diagram = transformationModelNode.getDiagram()) != null && (targetObject = diagram.getTarget()) != null) {
            root = DiagramUiUtilities.getDiagramModelNode((EObject)targetObject, (DiagramModelNode)transformationModelNode.getParent());
        }
        return root;
    }

    private DiagramModelNode getInputSetNode() {
        DiagramModelNode[] nodeArray = this.getNodeArray();
        int nNodes = nodeArray.length;
        int i = 0;
        while (i < nNodes) {
            DiagramModelNode next = nodeArray[i];
            if (this.isInputSet(next)) {
                return next;
            }
            ++i;
        }
        return null;
    }

    private boolean isStagingTable(DiagramModelNode classNode) {
        return classNode.getModelObject() != null && classNode.getModelObject() instanceof StagingTable;
    }

    private boolean isInputSet(DiagramModelNode classNode) {
        return classNode != null && classNode.getModelObject() != null && classNode.getModelObject() instanceof InputSet;
    }

    private boolean isRootNode(DiagramModelNode classNode) {
        return classNode != null && classNode.getModelObject() != null && this.getRootNode().getModelObject() != null && classNode.getModelObject() == this.getRootNode().getModelObject();
    }

    private DiagramModelNode getExtentNodeForStagingTable(DiagramModelNode stagingTableNode) {
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        while (iter.hasNext()) {
            EObject mappingReference;
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof MappingExtentNode) || (mappingReference = ((MappingExtentNode)nextNode).getExtent().getMappingReference()) == null || !mappingReference.equals(stagingTableNode.getModelObject())) continue;
            return nextNode;
        }
        return null;
    }

    private void resetAllExtentNodes() {
        double zoomFactor = 1.0;
        if (((MappingDiagramNode)this.diagramModelNode).getViewer() != null) {
            DiagramViewer viewer = ((MappingDiagramNode)this.diagramModelNode).getViewer();
            ZoomManager zoomManager = ((ScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager();
            zoomFactor = zoomManager.getZoom();
        }
        Iterator iter = this.diagramModelNode.getChildren().iterator();
        DiagramModelNode nextNode = null;
        MappingExtent nextExtent = null;
        int nextY = 0;
        while (iter.hasNext()) {
            nextNode = (DiagramModelNode)iter.next();
            if (!(nextNode instanceof MappingExtentNode)) continue;
            nextExtent = ((MappingExtentNode)nextNode).getExtent();
            nextY = (int)(nextExtent.getOffset() / zoomFactor);
            nextNode.setPosition(new Point(4, nextY));
        }
    }

    private DiagramModelNode getStagingTableNodeForLowestExtentNode(List extentNodes) {
        int lowestY = 99999;
        DiagramModelNode stagingTableNode = null;
        EObject lowestMappingClass = null;
        MappingExtentNode nextNode2 = null;
        for (MappingExtentNode nextNode2 : extentNodes) {
            if (nextNode2.getY() >= lowestY) continue;
            lowestY = nextNode2.getY();
            lowestMappingClass = nextNode2.getExtent().getMappingReference();
        }
        if (lowestMappingClass != null) {
            stagingTableNode = this.getStagingTable(lowestMappingClass);
        }
        return stagingTableNode;
    }

    private DiagramModelNode getStagingTable(EObject stagingTableEObject) {
        if (this.stagingTableNodes != null && !this.stagingTableNodes.isEmpty()) {
            Iterator iter = this.stagingTableNodes.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                if (!nextNode.getModelObject().equals(stagingTableEObject)) continue;
                return nextNode;
            }
        }
        return null;
    }

    private int getStackHeight() {
        int stackHeight = 0;
        List sourceNodes = this.getCurrentSourceNodes();
        if (sourceNodes != null && !sourceNodes.isEmpty()) {
            DiagramModelNode nextNode2 = null;
            for (DiagramModelNode nextNode2 : sourceNodes) {
                stackHeight += nextNode2.getHeight() + 20;
            }
            stackHeight -= 20;
        }
        if (stackHeight < 10) {
            stackHeight = 10;
        }
        return stackHeight;
    }

    private int getLevel(DiagramModelNode node) {
        MappingDiagramController controller;
        EObject eObj = node.getModelObject();
        Diagram theDiagram = (Diagram)this.diagramModelNode.getModelObject();
        DiagramEditor deEditor = DiagramEditorUtil.getDiagramEditor((Diagram)theDiagram);
        if (deEditor != null && (controller = (MappingDiagramController)deEditor.getDiagramController()) != null) {
            MappingAdapterFilter filter = controller.getMappingFilter();
            if (eObj instanceof StagingTable) {
                return filter.getLevel((StagingTable)eObj);
            }
            if (eObj instanceof MappingClass) {
                return filter.getLevel((MappingClass)eObj);
            }
        }
        return 0;
    }

    private List getOrderedMappingClassList() {
        MappingDiagramController controller;
        Diagram theDiagram = (Diagram)this.diagramModelNode.getModelObject();
        DiagramEditor deEditor = DiagramEditorUtil.getDiagramEditor((Diagram)theDiagram);
        if (deEditor != null && (controller = (MappingDiagramController)deEditor.getDiagramController()) != null) {
            MappingAdapterFilter filter = controller.getMappingFilter();
            return filter.getMappingAdapter().getAllMappingClasses();
        }
        return Collections.EMPTY_LIST;
    }
}

