/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;

public class ToggleSyncTreeAndDiagramExpandsAction
extends MappingAction {
    private static String SYNC_TREE_AND_DIAGRAM_TOOLTIP = UiConstants.Util.getString("ToggleSyncTreeAndDiagramExpandsAction.sync.tooltip", new Object[0]);
    private static String SYNC_TREE_AND_DIAGRAM_TEXT = UiConstants.Util.getString("ToggleSyncTreeAndDiagramExpandsAction.sync.text", new Object[0]);

    public ToggleSyncTreeAndDiagramExpandsAction() {
        super(UiPlugin.getDefault(), 2);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/synced.gif"));
        this.setToolTipText(SYNC_TREE_AND_DIAGRAM_TOOLTIP);
        this.setText(SYNC_TREE_AND_DIAGRAM_TEXT);
    }

    @Override
    public void setDiagramEditor(DiagramEditor editor) {
        super.setDiagramEditor(editor);
        this.updateButtonState();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    private MappingDiagramBehavior getBehavior() {
        return MappingDiagramUtil.getCurrentMappingDiagramBehavior();
    }

    @Override
    protected void doRun() {
        boolean bSyncTreeAndDiagramState = this.getBehavior().getSyncTreeAndDiagramState();
        bSyncTreeAndDiagramState = !bSyncTreeAndDiagramState;
        this.getBehavior().setSyncTreeAndDiagramState(bSyncTreeAndDiagramState);
        this.updateButtonState();
        this.editor.doRefreshDiagram();
    }

    private void determineEnablement() {
        boolean enable = true;
        this.setEnabled(enable);
    }

    protected void updateButtonState() {
        this.setChecked(this.getBehavior().getSyncTreeAndDiagramState());
    }
}

