/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.DiagramEditorAction;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ShowParentDiagramAction
extends DiagramEditorAction {
    private static final String textString = "org.teiid.designer.mapping.ui.actions.ShowParentDiagramAction.text";
    private static final String toolTipString = "org.teiid.designer.mapping.ui.actions.ShowParentDiagramAction.toolTip";

    public ShowParentDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_show_parent_diagram.gif"));
        this.setToolTipText(UiConstants.Util.getString(toolTipString, new Object[0]));
        this.setText(UiConstants.Util.getString(textString, new Object[0]));
        this.setEnabled(false);
    }

    protected void doRun() {
        if (this.editor != null) {
            ModelEditorManager.closeObjectEditor();
            Diagram diagram = this.getParentDiagram();
            if (diagram != null) {
                UiUtil.getWorkbenchPage().getNavigationHistory().markLocation((IEditorPart)this.editor);
                ModelEditorManager.closeObjectEditor();
                this.editor.openContext((Object)diagram);
            }
        }
        this.determineEnablement();
    }

    public void determineEnablement() {
        if (this.editor != null) {
            Diagram diagram = this.getParentDiagram();
            if (diagram != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private Diagram getParentDiagram() {
        ModelResource modelResource;
        Diagram currentDiagram;
        Diagram parentDiagram = null;
        DiagramModelNode diagramNode = this.editor.getCurrentModel();
        if (diagramNode != null && (currentDiagram = (Diagram)diagramNode.getModelObject()) != null && currentDiagram.getType() != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram)) != null) {
            if (currentDiagram.getType().equals("mappingDiagramType")) {
                EObject diagramTarget = currentDiagram.getTarget();
                if (diagramTarget != null && diagramTarget instanceof EObject) {
                    try {
                        List diagramList = modelResource.getModelDiagrams().getDiagrams(null);
                        Iterator iter = diagramList.iterator();
                        Diagram nextDiagram = null;
                        while (iter.hasNext() && parentDiagram == null) {
                            nextDiagram = (Diagram)iter.next();
                            if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                            parentDiagram = nextDiagram;
                        }
                        if (parentDiagram == null) {
                            parentDiagram = DiagramUiPlugin.getDiagramTypeManager().getDiagramForContext((Object)modelResource);
                        }
                    }
                    catch (ModelWorkspaceException e) {
                        String message = "ShowParentDiagramAction cannot find parent package diagram";
                        DiagramUiConstants.Util.log(4, (Throwable)e, message);
                    }
                }
            } else if (currentDiagram.getType().equals("mappingTransformationDiagramType")) {
                parentDiagram = MappingDiagramUtil.getCoarseMappingDiagram(currentDiagram);
            }
        }
        return parentDiagram;
    }
}

