/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.ExpandableNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class ExpandAllEnumsAction
extends MappingAction {
    private boolean isLogicalModel = false;
    private boolean modelTypeChecked = false;

    public ExpandAllEnumsAction() {
        super(UiPlugin.getDefault(), -1);
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        DiagramModelNode[] allEnumNodes = MappingDiagramUtil.getEnumeratedTypeNodes();
        if (allEnumNodes.length > 0) {
            int i = 0;
            while (i < allEnumNodes.length) {
                if (allEnumNodes[i] instanceof ExpandableNode && !((UmlClassifierNode)allEnumNodes[i]).isExpanded()) {
                    ((UmlClassifierNode)allEnumNodes[i]).expand();
                }
                ++i;
            }
        }
    }

    private void checkModelType() {
        DiagramEditor dEditor;
        if (!this.modelTypeChecked && (dEditor = DiagramEditorUtil.getVisibleDiagramEditor()) != null) {
            this.isLogicalModel = ModelIdentifier.isLogicalModel((ModelResource)dEditor.getCurrentModelResource());
            this.modelTypeChecked = true;
        }
    }

    private void determineEnablement() {
        this.checkModelType();
        boolean enable = this.isLogicalModel;
        this.setEnabled(enable);
    }
}

