/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;

public class RemoveProperty
extends AbstractNode {
    public static final String PROPERTY_PROPERTYNAME = "RemoveProperty.PropertyName";
    private String propertyName;

    public RemoveProperty() {
    }

    public RemoveProperty(RemovePropertyDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "removePropertyNode";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        String oldValue = this.propertyName;
        this.propertyName = propertyName;
        if (!this.isSame(oldValue, propertyName)) {
            this.firePropertyChange(PROPERTY_PROPERTYNAME, oldValue, propertyName);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descPropertyName = new TextPropertyDescriptor((Object)PROPERTY_PROPERTYNAME, Messages.propertyLabelRemovePropertyPropertyName);
        descriptors.put(PROPERTY_PROPERTYNAME, (PropertyDescriptor)descPropertyName);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_PROPERTYNAME.equals(id)) {
            this.setPropertyName(Objects.convertTo(value, String.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_PROPERTYNAME.equals(id)) {
            return this.getPropertyName();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        RemovePropertyDefinition answer = new RemovePropertyDefinition();
        answer.setPropertyName(this.toXmlPropertyValue(PROPERTY_PROPERTYNAME, this.getPropertyName()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return RemovePropertyDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof RemovePropertyDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof RemovePropertyDefinition. Was " + processor.getClass().getName());
        }
        RemovePropertyDefinition node = (RemovePropertyDefinition)processor;
        this.setPropertyName(node.getPropertyName());
    }
}

