/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RemovePropertiesDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;

public class RemoveProperties
extends AbstractNode {
    public static final String PROPERTY_PATTERN = "RemoveProperties.Pattern";
    public static final String PROPERTY_EXCLUDEPATTERN = "RemoveProperties.ExcludePattern";
    private String pattern;
    private String excludePattern;

    public RemoveProperties() {
    }

    public RemoveProperties(RemovePropertiesDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "allEIPs";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        String oldValue = this.pattern;
        this.pattern = pattern;
        if (!this.isSame(oldValue, pattern)) {
            this.firePropertyChange(PROPERTY_PATTERN, oldValue, pattern);
        }
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        String oldValue = this.excludePattern;
        this.excludePattern = excludePattern;
        if (!this.isSame(oldValue, excludePattern)) {
            this.firePropertyChange(PROPERTY_EXCLUDEPATTERN, oldValue, excludePattern);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descPattern = new TextPropertyDescriptor((Object)PROPERTY_PATTERN, Messages.propertyLabelRemovePropertiesPattern);
        TextPropertyDescriptor descExcludePattern = new TextPropertyDescriptor((Object)PROPERTY_EXCLUDEPATTERN, Messages.propertyLabelRemovePropertiesExcludePattern);
        descriptors.put(PROPERTY_PATTERN, (PropertyDescriptor)descPattern);
        descriptors.put(PROPERTY_EXCLUDEPATTERN, (PropertyDescriptor)descExcludePattern);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_PATTERN.equals(id)) {
            this.setPattern(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_EXCLUDEPATTERN.equals(id)) {
            this.setExcludePattern(Objects.convertTo(value, String.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_PATTERN.equals(id)) {
            return this.getPattern();
        }
        if (PROPERTY_EXCLUDEPATTERN.equals(id)) {
            return this.getExcludePattern();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        RemovePropertiesDefinition answer = new RemovePropertiesDefinition();
        answer.setPattern(this.toXmlPropertyValue(PROPERTY_PATTERN, this.getPattern()));
        answer.setExcludePattern(this.toXmlPropertyValue(PROPERTY_EXCLUDEPATTERN, this.getExcludePattern()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return RemovePropertiesDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof RemovePropertiesDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof RemovePropertiesDefinition. Was " + processor.getClass().getName());
        }
        RemovePropertiesDefinition node = (RemovePropertiesDefinition)processor;
        this.setPattern(node.getPattern());
        this.setExcludePattern(node.getExcludePattern());
    }
}

