/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.InOnlyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;

public class InOnly
extends AbstractNode {
    public static final String PROPERTY_URI = "InOnly.Uri";
    private String uri;

    public InOnly() {
    }

    public InOnly(InOnlyDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "inOnlyEIP";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        String oldValue = this.uri;
        this.uri = uri;
        if (!this.isSame(oldValue, uri)) {
            this.firePropertyChange(PROPERTY_URI, oldValue, uri);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descUri = new TextPropertyDescriptor((Object)PROPERTY_URI, Messages.propertyLabelInOnlyUri);
        descriptors.put(PROPERTY_URI, (PropertyDescriptor)descUri);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_URI.equals(id)) {
            this.setUri(Objects.convertTo(value, String.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_URI.equals(id)) {
            return this.getUri();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        InOnlyDefinition answer = new InOnlyDefinition();
        answer.setUri(this.toXmlPropertyValue(PROPERTY_URI, this.getUri()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return InOnlyDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof InOnlyDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof InOnlyDefinition. Was " + processor.getClass().getName());
        }
        InOnlyDefinition node = (InOnlyDefinition)processor;
        this.setUri(node.getUri());
    }
}

