/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.generated;

import java.util.Map;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.fusesource.ide.camel.model.AbstractNode;
import org.fusesource.ide.camel.model.ExpressionPropertyDescriptor;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.generated.Messages;
import org.fusesource.ide.camel.model.util.Objects;
import org.fusesource.ide.commons.properties.BooleanPropertyDescriptor;

public class DynamicRouter
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "DynamicRouter.Expression";
    public static final String PROPERTY_URIDELIMITER = "DynamicRouter.UriDelimiter";
    public static final String PROPERTY_IGNOREINVALIDENDPOINTS = "DynamicRouter.IgnoreInvalidEndpoints";
    public static final String PROPERTY_CACHESIZE = "DynamicRouter.CacheSize";
    private ExpressionDefinition expression;
    private String uriDelimiter;
    private Boolean ignoreInvalidEndpoints;
    private Integer cacheSize;

    public DynamicRouter() {
    }

    public DynamicRouter(DynamicRouterDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "dynamicRouter.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "dynamicEIP";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        if (!this.isSame(oldValue, expression)) {
            this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
        }
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setUriDelimiter(String uriDelimiter) {
        String oldValue = this.uriDelimiter;
        this.uriDelimiter = uriDelimiter;
        if (!this.isSame(oldValue, uriDelimiter)) {
            this.firePropertyChange(PROPERTY_URIDELIMITER, oldValue, uriDelimiter);
        }
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        Boolean oldValue = this.ignoreInvalidEndpoints;
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
        if (!this.isSame(oldValue, ignoreInvalidEndpoints)) {
            this.firePropertyChange(PROPERTY_IGNOREINVALIDENDPOINTS, oldValue, ignoreInvalidEndpoints);
        }
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        Integer oldValue = this.cacheSize;
        this.cacheSize = cacheSize;
        if (!this.isSame(oldValue, cacheSize)) {
            this.firePropertyChange(PROPERTY_CACHESIZE, oldValue, cacheSize);
        }
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelDynamicRouterExpression);
        TextPropertyDescriptor descUriDelimiter = new TextPropertyDescriptor((Object)PROPERTY_URIDELIMITER, Messages.propertyLabelDynamicRouterUriDelimiter);
        BooleanPropertyDescriptor descIgnoreInvalidEndpoints = new BooleanPropertyDescriptor((Object)PROPERTY_IGNOREINVALIDENDPOINTS, Messages.propertyLabelDynamicRouterIgnoreInvalidEndpoints);
        TextPropertyDescriptor descCacheSize = new TextPropertyDescriptor((Object)PROPERTY_CACHESIZE, Messages.propertyLabelDynamicRouterCacheSize);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_URIDELIMITER, (PropertyDescriptor)descUriDelimiter);
        descriptors.put(PROPERTY_IGNOREINVALIDENDPOINTS, (PropertyDescriptor)descIgnoreInvalidEndpoints);
        descriptors.put(PROPERTY_CACHESIZE, (PropertyDescriptor)descCacheSize);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
            return;
        }
        if (PROPERTY_URIDELIMITER.equals(id)) {
            this.setUriDelimiter(Objects.convertTo(value, String.class));
            return;
        }
        if (PROPERTY_IGNOREINVALIDENDPOINTS.equals(id)) {
            this.setIgnoreInvalidEndpoints(Objects.convertTo(value, Boolean.class));
            return;
        }
        if (PROPERTY_CACHESIZE.equals(id)) {
            this.setCacheSize(Objects.convertTo(value, Integer.class));
            return;
        }
        super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_URIDELIMITER.equals(id)) {
            return this.getUriDelimiter();
        }
        if (PROPERTY_IGNOREINVALIDENDPOINTS.equals(id)) {
            return this.getIgnoreInvalidEndpoints();
        }
        if (PROPERTY_CACHESIZE.equals(id)) {
            return this.getCacheSize();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        DynamicRouterDefinition answer = new DynamicRouterDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setUriDelimiter(this.toXmlPropertyValue(PROPERTY_URIDELIMITER, this.getUriDelimiter()));
        answer.setIgnoreInvalidEndpoints(this.toXmlPropertyValue(PROPERTY_IGNOREINVALIDENDPOINTS, this.getIgnoreInvalidEndpoints()));
        answer.setCacheSize(this.toXmlPropertyValue(PROPERTY_CACHESIZE, this.getCacheSize()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return DynamicRouterDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof DynamicRouterDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof DynamicRouterDefinition. Was " + processor.getClass().getName());
        }
        DynamicRouterDefinition node = (DynamicRouterDefinition)processor;
        this.setExpression(node.getExpression());
        this.setUriDelimiter(node.getUriDelimiter());
        this.setIgnoreInvalidEndpoints(node.getIgnoreInvalidEndpoints());
        this.setCacheSize(node.getCacheSize());
    }
}

