/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model;

import org.apache.camel.model.ProcessorDefinition;
import org.fusesource.ide.camel.model.AbstractNode;

public class Flow
extends AbstractNode {
    private boolean isConnected;
    private AbstractNode source;
    private AbstractNode target;

    public Flow(AbstractNode source, AbstractNode target) {
        if (source == null) {
            throw new IllegalArgumentException("No source for Flow");
        }
        if (target == null) {
            throw new IllegalArgumentException("No target for Flow");
        }
        this.reconnect(source, target);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Flow other = (Flow)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public AbstractNode getSource() {
        return this.source;
    }

    public AbstractNode getTarget() {
        return this.target;
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(AbstractNode newSource, AbstractNode newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        return null;
    }

    @Override
    public String toString() {
        return "Flow " + this.source + " -> " + this.target;
    }
}

