/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.navigator.osgi;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Workbenches;
import org.fusesource.ide.commons.ui.drop.DropHandler;
import org.fusesource.ide.commons.ui.drop.DropHandlerFactory;
import org.fusesource.ide.commons.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.commons.ui.views.ViewPropertySheetPage;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.fusesource.ide.jmx.karaf.navigator.osgi.BundlesTableSheetPage;
import org.fusesource.ide.jmx.karaf.navigator.osgi.OsgiFacade;
import org.fusesource.ide.jmx.karaf.navigator.osgi.TabularDataHelper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class BundlesNode
extends RefreshableCollectionNode
implements ImageProvider,
DropHandlerFactory {
    private final OsgiFacade facade;
    private String bundlefilterText;
    private boolean startOnDeploy = true;

    public BundlesNode(Node parent, OsgiFacade facade) {
        super(parent);
        this.facade = facade;
    }

    public String toString() {
        return "Bundles";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySourceTablePage();
        }
        return super.getAdapter(adapter);
    }

    public ViewPropertySheetPage getPropertySourceTablePage() {
        return new BundlesTableSheetPage(this);
    }

    public Image getImage() {
        return KarafJMXPlugin.getDefault().getImage("bundle.png");
    }

    protected void loadChildren() {
    }

    public OsgiFacade getFacade() {
        return this.facade;
    }

    public boolean requiresContentsPropertyPage() {
        return false;
    }

    protected PropertySourceTableSheetPage createPropertySourceTableSheetPage() {
        return new BundlesTableSheetPage(this);
    }

    public List<IPropertySource> getPropertySourceList() {
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        try {
            TabularData tabularData = this.facade.listBundles();
            return TabularDataHelper.toPropertySources(tabularData);
        }
        catch (Exception e) {
            KarafJMXPlugin.getLogger().error("Failed to fetch bundle state: " + e, (Throwable)e);
            return answer;
        }
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return null;
    }

    public void refresh() {
        super.refresh();
        IPage currentPage = Workbenches.getPropertySheetPage();
        Refreshables.refresh((Object)currentPage);
    }

    public String getBundlefilterText() {
        return this.bundlefilterText;
    }

    public void setBundlefilterText(String bundlefilterText) {
        this.bundlefilterText = bundlefilterText;
    }

    public void setBundleFilterText(String bundlefilterText) {
        this.bundlefilterText = bundlefilterText;
    }
}

