/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.editor.DiagramController;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.figure.ExpandableFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierContainerFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierFigure;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlAttributeEditPart;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierContainerEditPart;
import org.teiid.designer.diagram.ui.part.AbstractNotationEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.ExpandableDiagram;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.HiliteDndNodeSelectionEditPolicy;
import org.teiid.designer.diagram.ui.util.SelectionTracker;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartEditPolicy;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartManager;
import org.teiid.designer.diagram.ui.util.directedit.LabelCellEditorLocator;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.IRevealHideListener;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class UmlClassifierEditPart
extends AbstractNotationEditPart
implements DirectEditPart {
    private static final int ARROW_BORDER_5 = 5;
    private static final int ARROW_BORDER_8 = 8;
    private DragTracker myDragTracker = null;
    private DirectEditManager manager;
    private IRevealHideListener revealHideListener;

    public UmlClassifierEditPart() {
    }

    public UmlClassifierEditPart(String diagramTypeId) {
        this.setDiagramTypeId(diagramTypeId);
        this.init();
    }

    private boolean canCollapse() {
        boolean bResult = this.getParent() instanceof ExpandableDiagram;
        return bResult;
    }

    private boolean clickedOnArrow() {
        SelectionTracker tracker;
        if (this.getDiagramFigure() instanceof ExpandableFigure && (tracker = (SelectionTracker)this.getDragTracker(null)) != null && tracker.getLastMouseLocation() != null) {
            DiagramViewer dvViewer = null;
            try {
                dvViewer = (DiagramViewer)this.getViewer();
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            if (dvViewer == null) {
                return false;
            }
            DiagramEditor deEditor = dvViewer.getEditor();
            double zoomFactor = deEditor.getCurrentZoomFactor();
            Point rawMousePoint = new Point(tracker.getLastMouseLocation());
            Point mousePoint = new Point((double)rawMousePoint.x / zoomFactor, (double)rawMousePoint.y / zoomFactor);
            Point rawViewportLoc = ((DiagramViewer)this.getViewer()).getViewportLocation();
            Point viewportLoc = new Point((double)rawViewportLoc.x / zoomFactor, (double)rawViewportLoc.y / zoomFactor);
            ExpandableFigure cFigure = (ExpandableFigure)((Object)this.getDiagramFigure());
            IFigure arrowFigure = cFigure.getExpansionFigure();
            if (arrowFigure != null) {
                Rectangle arrowRect = new Rectangle(arrowFigure.getBounds());
                arrowRect.x = arrowRect.x + ((IFigure)cFigure).getBounds().x - 5 - viewportLoc.x;
                arrowRect.y = arrowRect.y + ((IFigure)cFigure).getBounds().y - 5 - viewportLoc.y;
                arrowRect.width += 5;
                arrowRect.height += 8;
                if (arrowRect.contains(mousePoint)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void collapse() {
        if (this.canCollapse()) {
            List lstChildEObjects = this.getChildEObjects();
            ((UmlClassifierFigure)this.getDiagramFigure()).collapse();
            this.refresh();
            this.layout(true);
            if (this.getRevealHideListener() != null && this.getRevealHideListener().isRevealHideBehaviorEnabled() && lstChildEObjects != null && lstChildEObjects != Collections.EMPTY_LIST) {
                this.getRevealHideListener().notifyElementsHidden((Object)this, lstChildEObjects);
            }
        }
    }

    protected void createEditPolicies() {
        this.setPrimaryParent(true);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HiliteDndNodeSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPartEditPolicy());
    }

    @Override
    protected IFigure createFigure() {
        Point posn = new Point(100, 100);
        UmlClassifierFigure newFigure = (UmlClassifierFigure)this.getFigureGenerator().createFigure(this.getModel());
        UmlClassifierNode model = (UmlClassifierNode)this.getModel();
        if (model.getParent() instanceof ExpandableDiagram && ((ExpandableDiagram)((Object)model.getParent())).canExpand()) {
            newFigure.setExpandable(true);
        }
        newFigure.setLocation(posn);
        Image firstOverlayImage = model.getFirstOverlayImage();
        Image secondOverlayImage = model.getSecondOverlayImage();
        if (firstOverlayImage != null) {
            newFigure.addEditButton(firstOverlayImage);
        }
        if (secondOverlayImage != null) {
            newFigure.addImage(secondOverlayImage, 2);
        }
        int nameFontStyle = 1;
        if (model.isAbstract()) {
            nameFontStyle = 3;
        }
        newFigure.setNameFontStyle(nameFontStyle);
        return newFigure;
    }

    public boolean doubleClickedName() {
        SelectionTracker tracker = (SelectionTracker)this.getDragTracker(null);
        if (tracker != null && tracker.getLastMouseLocation() != null) {
            double zoomFactor = ((DiagramViewer)this.getViewer()).getEditor().getCurrentZoomFactor();
            Point rawMousePoint = new Point(tracker.getLastMouseLocation());
            Point mousePoint = new Point((double)rawMousePoint.x / zoomFactor, (double)rawMousePoint.y / zoomFactor);
            Point rawViewportLoc = ((DiagramViewer)this.getViewer()).getViewportLocation();
            Point viewportLoc = new Point((double)rawViewportLoc.x / zoomFactor, (double)rawViewportLoc.y / zoomFactor);
            UmlClassifierFigure cFigure = (UmlClassifierFigure)this.getDiagramFigure();
            IFigure nameFigure = cFigure.getNameFigure();
            Point nestedOffset = DiagramUiUtilities.getNestedRelativeLocation(this);
            if (nameFigure != null) {
                Rectangle nameRect = new Rectangle(nameFigure.getBounds());
                nameRect.x = nameRect.x + cFigure.getBounds().x - 3 - viewportLoc.x + nestedOffset.x;
                nameRect.y = nameRect.y + cFigure.getBounds().y - 3 - viewportLoc.y + nestedOffset.y;
                nameRect.width += 6;
                nameRect.height += 6;
                if (nameRect.contains(mousePoint)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void edit() {
        if (!this.clickedOnArrow()) {
            if (this.doubleClickedName()) {
                if (this.getSelectionHandler().shouldRename(this.getModelObject()) && ModelerCore.getModelEditor().hasName(this.getModelObject()) && !ModelObjectUtilities.isReadOnly((EObject)this.getModelObject())) {
                    this.performDirectEdit();
                }
            } else {
                ModelEditorManager.edit((EObject)this.getModelObject());
            }
        }
    }

    public void expand() {
        if (this.canCollapse()) {
            ((UmlClassifierFigure)this.getDiagramFigure()).expand();
            this.refresh();
            this.layout(true);
            Dimension newSize = this.getFigure().getSize();
            ((DiagramModelNode)this.getModel()).setSize(newSize);
            if (this.getRevealHideListener() != null && this.getRevealHideListener().isRevealHideBehaviorEnabled()) {
                this.getRevealHideListener().notifyElementsRevealed((Object)this, this.getChildEObjects());
            }
        }
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == AccessibleAnchorProvider.class) {
            return new AbstractGraphicalEditPart.DefaultAccessibleAnchorProvider(this){

                public List getSourceAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    Dimension thisSize = UmlClassifierEditPart.this.getFigure().getSize();
                    list.add(new Point(0, 0));
                    list.add(new Point(thisSize.width / 2, 0));
                    list.add(new Point(thisSize.width, 0));
                    list.add(new Point(thisSize.width, thisSize.height / 2));
                    list.add(new Point(thisSize.width, thisSize.height));
                    list.add(new Point(thisSize.width / 2, thisSize.height));
                    list.add(new Point(0, thisSize.height));
                    list.add(new Point(0, thisSize.height / 2));
                    return list;
                }

                public List getTargetAnchorLocations() {
                    ArrayList<Point> list = new ArrayList<Point>();
                    Dimension thisSize = UmlClassifierEditPart.this.getFigure().getSize();
                    list.add(new Point(0, 0));
                    list.add(new Point(thisSize.width / 2, 0));
                    list.add(new Point(thisSize.width, 0));
                    list.add(new Point(thisSize.width, thisSize.height / 2));
                    list.add(new Point(thisSize.width, thisSize.height));
                    list.add(new Point(thisSize.width / 2, thisSize.height));
                    list.add(new Point(0, thisSize.height));
                    list.add(new Point(0, thisSize.height / 2));
                    return list;
                }
            };
        }
        return super.getAdapter(key);
    }

    private List getChildEObjects() {
        ArrayList<EObject> lstChildren = Collections.EMPTY_LIST;
        ArrayList<EObject> arylEObjects = new ArrayList<EObject>();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            UmlClassifierContainerEditPart container = (UmlClassifierContainerEditPart)this.getChildren().get(0);
            lstChildren = container.getChildren();
            for (Object e : lstChildren) {
                if (!(e instanceof UmlAttributeEditPart)) continue;
                UmlAttributeEditPart attr = (UmlAttributeEditPart)e;
                arylEObjects.add(attr.getModelObject());
            }
            lstChildren = arylEObjects;
        }
        return lstChildren;
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectionTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    @Override
    public DirectEditPartManager getEditManager() {
        return (DirectEditPartManager)this.manager;
    }

    @Override
    public String getEditString() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    private Label getLabel() {
        Label label = null;
        if (this.getFigure() instanceof DirectEditFigure) {
            label = ((DirectEditFigure)this.getFigure()).getLabelFigure();
        }
        return label;
    }

    public IRevealHideListener getRevealHideListener() {
        DiagramController deController;
        if (this.revealHideListener == null && (deController = ((DiagramViewer)this.getViewer()).getEditor().getDiagramController()) instanceof IRevealHideListener) {
            this.revealHideListener = (IRevealHideListener)deController;
        }
        return this.revealHideListener;
    }

    @Override
    public String getText() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        this.getDiagramFigure().hiliteBackground(hiliteColor);
    }

    public void init() {
        if (this.getAnchorManager() == null) {
            this.setAnchorManager(this.getEditPartFactory().getAnchorManager(this));
        }
    }

    @Override
    public void layout(boolean layoutChildren) {
        this.resetContainerStackIndex();
        super.layout(layoutChildren);
    }

    @Override
    public void performDirectEdit() {
        if (this.manager == null) {
            this.manager = new DirectEditPartManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(this.getLabel()));
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (!this.getSelectionHandler().handleDoubleClick(this.getModelObject()) && ModelerCore.getModelEditor().hasName(this.getModelObject())) {
                this.performDirectEdit();
            }
        } else if (request.getType() == "selection" && this.canCollapse() && this.clickedOnArrow()) {
            if (((UmlClassifierNode)this.getModel()).isExpanded()) {
                ((UmlClassifierNode)this.getModel()).collapse();
            } else {
                ((UmlClassifierNode)this.getModel()).expand();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        super.propertyChange(evt);
        if (prop.equals("layout")) {
            this.getChangeManager().refresh(11, false);
        } else if (prop.equals("size")) {
            this.getChangeManager().refresh(9, false);
            this.getChangeManager().refresh(0, false);
            if (!((DiagramModelNode)this.getModel()).getSourceConnections().isEmpty() || !((DiagramModelNode)this.getModel()).getTargetConnections().isEmpty()) {
                ((DiagramModelNode)this.getModel()).updateAssociations();
            }
            this.getChangeManager().refresh(3, false);
        } else if (prop.equals("image")) {
            this.refreshImages();
        } else if (prop.equals("connection")) {
            this.getChangeManager().refresh(5, false);
            this.getChangeManager().refresh(6, false);
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(0, false);
            this.getChangeManager().refresh(3, false);
        } else if (prop.equals("location")) {
            if (!((DiagramModelNode)this.getModel()).getSourceConnections().isEmpty() || !((DiagramModelNode)this.getModel()).getTargetConnections().isEmpty()) {
                ((DiagramModelNode)this.getModel()).updateAssociations();
            }
            this.getChangeManager().refresh(3, false);
        } else if (prop.equals("image")) {
            this.refreshImages();
        }
        if (prop.equals("path")) {
            this.refreshPath();
            this.getChangeManager().refresh(9, false);
        }
        if (this.canCollapse()) {
            boolean handleConstruction;
            Diagram diagram;
            if (prop.equals("collapse")) {
                diagram = ((DiagramModelNode)this.getModel()).getDiagram();
                boolean bl = handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                }
                this.collapse();
                this.getChangeManager().refresh(1, false);
                this.getChangeManager().refresh(4, false);
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                }
            }
            if (prop.equals("expand")) {
                diagram = ((DiagramModelNode)this.getModel()).getDiagram();
                boolean bl = handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                }
                this.expand();
                this.getChangeManager().refresh(1, false);
                this.getChangeManager().refresh(4, false);
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                }
            }
        }
    }

    public void refreshImages() {
        DiagramModelNode dmn = (DiagramModelNode)this.getModel();
        if (dmn != null) {
            UmlClassifierFigure figure = (UmlClassifierFigure)this.getDiagramFigure();
            figure.addImage(dmn.getSecondOverlayImage(), 2);
            Button button = figure.getEditButton();
            if (button != null) {
                for (Object obj : button.getChildren()) {
                    if (!(obj instanceof Label)) continue;
                    ((Label)obj).setIcon(dmn.getFirstOverlayImage());
                    break;
                }
            }
            this.layout(true);
        }
    }

    @Override
    public void refreshName() {
        int nameFontStyle = 1;
        if (((UmlClassifierNode)this.getModel()).isAbstract()) {
            nameFontStyle = 3;
        }
        ((UmlClassifierFigure)this.getDiagramFigure()).setNameFontStyle(nameFontStyle);
        super.refreshName();
    }

    public void refreshPath() {
        ((UmlClassifierFigure)this.getDiagramFigure()).updateForPath(((UmlClassifierNode)this.getModel()).getPath());
    }

    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    private void resetContainerStackIndex() {
        Iterator iter = this.getChildren().iterator();
        EditPart nextChild = null;
        while (iter.hasNext()) {
            nextChild = (EditPart)iter.next();
            if (!(nextChild instanceof UmlClassifierContainerEditPart)) continue;
            UmlClassifierContainerNode cn = (UmlClassifierContainerNode)((DiagramEditPart)nextChild).getModel();
            UmlClassifierContainerFigure cf = (UmlClassifierContainerFigure)((DiagramEditPart)nextChild).getDiagramFigure();
            cf.setStackOrderValue(cn.getType());
        }
    }

    @Override
    public void resizeChildren() {
        this.getDiagramFigure().updateForSize(((DiagramModelNode)this.getModel()).getSize());
    }

    public void setRevealHideListener(IRevealHideListener listener) {
        this.revealHideListener = listener;
    }

    @Override
    public void setText(String newName) {
        ((DiagramModelNode)this.getModel()).setName(newName);
    }

    @Override
    public boolean shouldHiliteBackground(List sourceEditParts) {
        return true;
    }
}

