/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.LinkBendpointEditPolicy;
import org.teiid.designer.diagram.ui.connection.LinkEndpointEditPolicy;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.connection.decorator.DecoratorFactory;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.figure.DiagramPolylineConnection;
import org.teiid.designer.diagram.ui.util.ConnectionSelectionTracker;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;

public class UmlAssociationLinkEditPart
extends NodeConnectionEditPart {
    private DragTracker dragTracker = null;

    @Override
    protected IFigure createFigure() {
        DiagramPolylineConnection connectionFigure = new DiagramPolylineConnection();
        List toolTips = ((NodeConnectionModel)this.getModel()).getToolTipStrings();
        if (toolTips != null && !toolTips.isEmpty()) {
            connectionFigure.setToolTip(connectionFigure.createToolTip(toolTips));
        }
        int targetDecID = ((NodeConnectionModel)this.getModel()).getTargetDecoratorId();
        int sourceDecID = ((NodeConnectionModel)this.getModel()).getSourceDecoratorId();
        Color diagramBkgdColor = ((AbstractGraphicalEditPart)this.getDiagramViewer().getContents()).getFigure().getBackgroundColor();
        PolygonDecoration newTargetDecoration = DecoratorFactory.getDecorator(targetDecID);
        PolygonDecoration newSourceDecoration = DecoratorFactory.getDecorator(sourceDecID);
        int iStandardWidth = 1;
        if (newTargetDecoration != null) {
            newTargetDecoration.setLineWidth(iStandardWidth);
            if (targetDecID == 4 || targetDecID == 2) {
                newTargetDecoration.setBackgroundColor(diagramBkgdColor);
            }
            connectionFigure.setTargetDecoration((RotatableDecoration)newTargetDecoration);
        }
        if (newSourceDecoration != null) {
            newSourceDecoration.setLineWidth(iStandardWidth);
            if (sourceDecID == 4 || sourceDecID == 2) {
                newSourceDecoration.setBackgroundColor(diagramBkgdColor);
            }
            connectionFigure.setSourceDecoration((RotatableDecoration)newSourceDecoration);
        }
        connectionFigure.setLineStyle(((NodeConnectionModel)this.getModel()).getLineStyle());
        connectionFigure.setLineWidth(iStandardWidth);
        connectionFigure.setForegroundColor(ColorConstants.blue);
        return connectionFigure;
    }

    @Override
    protected void createEditPolicies() {
        this.refreshBendpointEditPolicy();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new LinkEndpointEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DiagramNodeSelectionEditPolicy());
    }

    public DragTracker getDragTracker(Request req) {
        if (this.dragTracker == null) {
            this.dragTracker = new ConnectionSelectionTracker((EditPart)this, this.getDiagramViewer().getSelectionHandler());
        }
        return this.dragTracker;
    }

    private void refreshBendpointEditPolicy() {
        if (DiagramEditorUtil.getCurrentDiagramRouterStyle() != 2) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new LinkBendpointEditPolicy());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        super.propertyChange(evt);
        if ("router".equals(prop)) {
            if (((DiagramUmlAssociation)this.getModel()).changedRouterFromOtoM((String)evt.getOldValue(), (String)evt.getNewValue())) {
                DiagramPolylineConnection dpc = (DiagramPolylineConnection)this.getFigure();
                Vector orthPts = new Vector(dpc.getInternalPoints());
                ((NodeConnectionModel)this.getModel()).clearBendpoints();
                ((NodeConnectionModel)this.getModel()).setBendpoints(orthPts);
            }
            this.refreshBendpointEditPolicy();
            this.refreshBendpoints();
        }
    }
}

