/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlAssociationNode;
import org.teiid.designer.diagram.ui.part.AbstractNotationEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.HiliteDndNodeSelectionEditPolicy;
import org.teiid.designer.diagram.ui.util.SelectionTracker;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartEditPolicy;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartManager;
import org.teiid.designer.diagram.ui.util.directedit.LabelCellEditorLocator;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class UmlAssociationEditPart
extends AbstractNotationEditPart
implements DirectEditPart {
    private DirectEditManager manager;
    private DragTracker myDragTracker = null;

    @Override
    protected IFigure createFigure() {
        Point location = new Point(100, 100);
        Figure newFigure = this.getFigureGenerator().createFigure(this.getModel());
        newFigure.setLocation(location);
        ((DiagramModelNode)this.getModel()).setPosition(location);
        ((DiagramModelNode)this.getModel()).setSize(newFigure.getSize());
        return newFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HiliteDndNodeSelectionEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPartEditPolicy());
    }

    @Override
    public void edit() {
        if (this.getSelectionHandler().shouldRename(this.getModelObject()) && ModelerCore.getModelEditor().hasName(this.getModelObject()) && !ModelObjectUtilities.isReadOnly((EObject)this.getModelObject())) {
            this.performDirectEdit();
        }
    }

    @Override
    public void performDirectEdit() {
        if (this.manager == null) {
            this.manager = new DirectEditPartManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(this.getLabel()));
        }
        this.manager.show();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && !this.getSelectionHandler().handleDoubleClick(this.getModelObject()) && ModelerCore.getModelEditor().hasName(this.getModelObject())) {
            this.performDirectEdit();
        }
    }

    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    @Override
    public String getText() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    @Override
    public void setText(String newName) {
        ((DiagramModelNode)this.getModel()).setName(newName);
    }

    @Override
    public String getEditString() {
        return ((DiagramModelNode)this.getModel()).getName();
    }

    private Label getLabel() {
        Label label = null;
        if (this.getFigure() instanceof DirectEditFigure) {
            label = ((DirectEditFigure)this.getFigure()).getLabelFigure();
        }
        return label;
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        this.getDiagramFigure().hiliteBackground(hiliteColor);
    }

    @Override
    public boolean shouldHiliteBackground(List sourceEditParts) {
        Iterator iter = sourceEditParts.iterator();
        DiagramEditPart nextEP = null;
        while (iter.hasNext()) {
            nextEP = (DiagramEditPart)iter.next();
            if (!nextEP.getParent().equals(this.getParent())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String prop = evt.getPropertyName();
        if (prop.equals("name")) {
            this.refreshName();
            ((DiagramEditPart)this.getParent().getParent()).layout(true);
            this.refreshVisuals();
        }
    }

    @Override
    public void refreshName() {
        this.getDiagramFigure().updateForName(((UmlAssociationNode)this.getModel()).getSignature());
    }

    @Override
    public void refreshFont(boolean refreshChildren) {
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().refreshFont();
            this.getDiagramFigure().layoutFigure();
            ((DiagramModelNode)this.getModel()).setSize(this.getFigure().getSize());
            ((DiagramModelNode)this.getModel()).setPosition(new Point(this.getFigure().getBounds().x, this.getFigure().getBounds().y));
        }
        this.refreshVisuals();
        this.refreshAllLabels();
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectionTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    @Override
    public List getDependencies() {
        DiagramModelNode modelNode = (DiagramModelNode)this.getModel();
        if (modelNode != null) {
            return modelNode.getDependencies();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public DirectEditPartManager getEditManager() {
        return (DirectEditPartManager)this.manager;
    }
}

